/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableManager;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteTable;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteTableColumn;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteTableForeignKey;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPPersistedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandDeleteObject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.utils.CommonUtils;

public class SQLiteTableManager
extends GenericTableManager
implements DBEObjectRenamer<GenericTableBase> {
    private static final Class<? extends DBSObject>[] CHILD_TYPES = (Class[])CommonUtils.array((Object[])new Class[]{SQLiteTableColumn.class, GenericUniqueKey.class, SQLiteTableForeignKey.class, GenericTableIndex.class});

    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES;
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        GenericDataSource dataSource = (GenericDataSource)((GenericTableBase)command.getObject()).getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER TABLE " + (String)(((GenericTableBase)command.getObject()).getSchema() != null ? DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)((GenericTableBase)command.getObject()).getSchema().getName()) + "." : "") + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }

    protected void addTableRecreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull TableRecreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        GenericTableBase table = (GenericTableBase)command.getObject();
        List<GenericTableColumn> attributes = CommonUtils.safeCollection((Collection)table.getAttributes(monitor)).stream().filter(DBPPersistedObject::isPersisted).toList();
        if (CommonUtils.isEmpty(attributes)) {
            throw new DBException("Table has no attributes");
        }
        String columns = attributes.stream().map(DBUtils::getQuotedIdentifier).collect(Collectors.joining(",\n  "));
        actions.add((DBEPersistAction)new SQLDatabasePersistActionComment(table.getDataSource(), "Table recreation to take into account some alterations (deletion of column, modification of foreign key...)"));
        GenericSchema schema = table.getSchema();
        String schemaPart = schema != null ? DBUtils.getQuotedIdentifier((DBSObject)schema) + "." : "";
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create temporary table from original table", "CREATE TEMPORARY TABLE " + schemaPart + "temp AS\nSELECT" + (String)(attributes.isEmpty() ? " *" : "\n  " + columns) + "\nFROM " + DBUtils.getQuotedIdentifier((DBSObject)table)));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop original table", "\nDROP TABLE " + table.getFullyQualifiedName(DBPEvaluationContext.DML) + ";\n"));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create new table", DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSEntity)table, (Map)DBPScriptObject.EMPTY_OPTIONS, (boolean)false)));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Insert values from temporary table to new table", "INSERT INTO " + schemaPart + DBUtils.getQuotedIdentifier((DBSObject)table) + (String)(attributes.isEmpty() ? "" : "\n (" + columns + ")") + "\nSELECT" + (String)(attributes.isEmpty() ? " *" : "\n  " + columns) + "\nFROM temp"));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop temporary table", "\nDROP TABLE " + schemaPart + "temp"));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableBase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        if (object.isView()) {
            throw new DBException("View rename is not supported");
        }
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected boolean isIncludeConstraintInDDL(DBRProgressMonitor monitor, DBSEntityConstraint constraint) {
        GenericUniqueKey key;
        List columns;
        if (constraint.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY && constraint instanceof GenericUniqueKey && (columns = (key = (GenericUniqueKey)constraint).getAttributeReferences(monitor)).size() == 1 && ((GenericTableConstraintColumn)columns.get(0)).getAttribute().isAutoIncrement()) {
            return false;
        }
        return super.isIncludeConstraintInDDL(monitor, constraint);
    }

    protected boolean isIncludeDropInDDL(@NotNull GenericTableBase tableBase) {
        return false;
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, GenericTableBase table, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter, Map<String, Object> options) {
        SQLiteTable sqliteTable;
        if (table instanceof SQLiteTable && (sqliteTable = (SQLiteTable)table).isHasStrictTyping()) {
            ddl.append(" STRICT");
        }
    }

    public void addRecreateCommand(DBECommandContext commandContext, SQLiteTable table, Map<String, Object> options, DBECommand sourceCommand) {
        commandContext.addCommand((DBECommand)new TableRecreateCommand(table, ModelMessages.model_jdbc_create_new_object, options, sourceCommand), (DBECommandReflector)new TableRecreateReflector(), true, sourceCommand);
    }

    public class TableRecreateCommand
    extends SQLStructEditor.StructCreateCommand {
        private DBECommand sourceCommand;

        public TableRecreateCommand(SQLiteTable object, String table, Map<String, Object> options, DBECommand sourceCommand) {
            super((SQLStructEditor)SQLiteTableManager.this, (DBSObject)object, table, options);
            this.sourceCommand = sourceCommand;
        }

        public void validateCommand(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
            if (this.sourceCommand != null) {
                this.sourceCommand.validateCommand(monitor, options);
            }
            super.validateCommand(monitor, options);
        }

        public boolean aggregateCommand(DBECommand<?> command) {
            DBSObject object;
            DBPObject dBPObject;
            if (command instanceof DBECommandDeleteObject && (dBPObject = command.getObject()) instanceof DBSObject && DBUtils.isParentOf((DBSObject)(object = (DBSObject)dBPObject), (DBSObject)((DBSObject)this.getObject()))) {
                return true;
            }
            return super.aggregateCommand(command);
        }

        @NotNull
        public DBEPersistAction[] getPersistActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull Map<String, Object> options) throws DBException {
            ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
            SQLiteTableManager.this.addTableRecreateActions(monitor, executionContext, actions, this, options);
            return actions.toArray(new DBEPersistAction[0]);
        }
    }

    public static class TableRecreateReflector
    implements DBECommandReflector<GenericTableBase, TableRecreateCommand> {
        public void redoCommand(TableRecreateCommand command) {
            DBUtils.fireObjectUpdate((DBSObject)((DBSObject)command.getObject()), (boolean)true);
        }

        public void undoCommand(TableRecreateCommand command) {
            DBUtils.fireObjectUpdate((DBSObject)((DBSObject)command.getObject()), (boolean)true);
        }
    }
}

