/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLMultilineCommentToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPartitionScanner;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SQLPartitionScanner
extends RuleBasedPartitionScanner
implements TPPartitionScanner {
    private static final Log log = Log.getLog(SQLPartitionScanner.class);
    private final DBPDataSource dataSource;
    private final List<IPredicateRule> rules = new ArrayList<IPredicateRule>();
    private final IToken commentToken = new Token((Object)"sql_comment");
    private final IToken multilineCommentToken = new Token((Object)"sql_multiline_comment");
    private final IToken sqlStringToken = new Token((Object)"sql_character");
    private final IToken sqlQuotedToken = new Token((Object)"sql_quoted");
    private final IToken controlToken = new Token((Object)"sql_command");

    private void setupRules() {
        IPredicateRule[] result = new IPredicateRule[this.rules.size()];
        this.rules.toArray(result);
        this.setPredicateRules(result);
    }

    private void initRules(SQLDialect dialect, SQLRuleManager ruleManager) {
        TPRuleProvider ruleProvider = (TPRuleProvider)GeneralUtils.adapt((Object)dialect, TPRuleProvider.class);
        if (ruleProvider != null) {
            TPRule[] partRules;
            for (TPRule pr : partRules = ruleProvider.extendRules(this.dataSource == null ? null : this.dataSource.getContainer(), TPRuleProvider.RulePosition.PARTITION)) {
                if (!(pr instanceof TPPredicateRule)) continue;
                this.rules.add(new PredicateRuleAdapter((TPPredicateRule)pr));
            }
        }
        this.adaptRules(ruleManager.getRulesByType(SQLTokenType.T_CONTROL));
        this.adaptRules(ruleManager.getRulesByType(SQLTokenType.T_COMMENT));
        this.adaptRules(ruleManager.getRulesByType(SQLTokenType.T_QUOTED));
        this.adaptRules(ruleManager.getRulesByType(SQLTokenType.T_STRING));
    }

    private void adaptRules(TPRule ... rules) {
        for (TPRule rule : rules) {
            if (!(rule instanceof TPPredicateRule)) continue;
            this.rules.add(new PredicateRuleAdapter((TPPredicateRule)rule));
        }
    }

    public SQLPartitionScanner(DBPDataSource dataSource, SQLDialect dialect, SQLRuleManager ruleManager) {
        this.dataSource = dataSource;
        this.initRules(dialect, ruleManager);
        this.setupRules();
    }

    @Override
    public String getScannedPartitionString() {
        try {
            return this.fDocument.get(this.fPartitionOffset, this.fOffset - this.fPartitionOffset);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static ITypedRegion[] getDocumentRegions(IDocument doc) {
        ITypedRegion[] regions = null;
        try {
            regions = TextUtilities.computePartitioning((IDocument)doc, (String)"___sql_partitioning", (int)0, (int)doc.getLength(), (boolean)false);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return regions;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    private IToken adaptToken(TPToken token) {
        if (token instanceof TPTokenDefault && token.getData() instanceof SQLTokenType) {
            switch ((SQLTokenType)token.getData()) {
                case T_STRING: {
                    return this.sqlStringToken;
                }
                case T_QUOTED: {
                    return this.sqlQuotedToken;
                }
                case T_COMMENT: {
                    return token instanceof SQLMultilineCommentToken ? this.multilineCommentToken : this.commentToken;
                }
                case T_CONTROL: {
                    return this.controlToken;
                }
            }
        }
        return Token.UNDEFINED;
    }

    private class PredicateRuleAdapter
    implements IPredicateRule {
        private final TPPredicateRule rule;

        PredicateRuleAdapter(TPPredicateRule rule) {
            this.rule = rule;
        }

        public IToken getSuccessToken() {
            return SQLPartitionScanner.this.adaptToken(this.rule.getSuccessToken());
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return SQLPartitionScanner.this.adaptToken(this.rule.evaluate((TPCharacterScanner)scanner, resume));
        }

        public IToken evaluate(ICharacterScanner scanner) {
            return SQLPartitionScanner.this.adaptToken(this.rule.evaluate((TPCharacterScanner)scanner));
        }
    }
}

