/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator.resultset;

import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDResultSetDataProvider;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQueryGeneratorUpdate;
import org.jkiss.dbeaver.model.sql.generator.resultset.SQLGeneratorResultSet;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorUpdateFromData
extends SQLGeneratorResultSet {
    @Override
    public boolean isDMLOption() {
        return true;
    }

    @Override
    protected void generateSQL(@NotNull DBRProgressMonitor monitor, @NotNull StringBuilder sql, @NotNull DBDResultSetDataProvider dataProvider) throws DBException {
        DBSEntity dbsEntity = dataProvider.getSingleSource();
        String entityName = this.getEntityName(dbsEntity);
        String separator = this.getLineSeparator();
        for (DBDValueRow firstRow : dataProvider.getSelectedRows()) {
            List<DBDAttributeBinding> keyAttributes = this.getKeyAttributes(monitor, dataProvider);
            Collection<DBSAttributeBase> valueAttributes = this.getValueAttributes(monitor, dataProvider, keyAttributes);
            if (dbsEntity instanceof SQLQueryGeneratorUpdate) {
                SQLQueryGeneratorUpdate dataStatement = (SQLQueryGeneratorUpdate)dbsEntity;
                sql.append(dataStatement.generateTableUpdateBegin(entityName));
                String updateSet = dataStatement.generateTableUpdateSet();
                if (CommonUtils.isNotEmpty((String)updateSet)) {
                    sql.append(separator).append(updateSet);
                }
            } else {
                sql.append("UPDATE ").append(entityName);
                sql.append(separator).append("SET ");
            }
            boolean hasAttr = false;
            if (CommonUtils.isEmpty(valueAttributes)) {
                valueAttributes = keyAttributes;
            }
            for (DBSAttributeBase attr : valueAttributes) {
                if (DBUtils.isPseudoAttribute((DBSAttributeBase)attr) || DBUtils.isHiddenObject((Object)attr)) continue;
                if (hasAttr) {
                    sql.append(", ");
                }
                sql.append(DBUtils.getObjectFullName((DBPNamedObject)attr, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
                DBDAttributeBinding binding = DBUtils.findBinding((DBDAttributeBinding[])dataProvider.getAttributes(), (DBSAttributeBase)attr);
                if (binding == null) {
                    this.appendDefaultValue(sql, attr);
                } else {
                    this.appendAttributeValue(dataProvider, sql, binding, firstRow, true);
                }
                hasAttr = true;
            }
            if (!CommonUtils.isEmpty(keyAttributes)) {
                sql.append(separator).append("WHERE ");
                this.appendKeyConditions(sql, keyAttributes, firstRow);
            }
            sql.append(";\n");
        }
    }
}

