/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.formdev.flatlaf.util.HiDPIUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ColorUtils;

public class JColorButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final int COLOR_ICON_BORDER_SIZE = (int)(4.0f * UITools.FONT_SCALE_FACTOR);
    private static final Paint TEXTURE = JColorButton.createTexture();
    private Color color;
    private String text;
    int textWidth;
    int textHeight;

    private static TexturePaint createTexture() {
        int cellSize = (int)(6.0f * UITools.FONT_SCALE_FACTOR);
        BufferedImage image = new BufferedImage(cellSize, cellSize, 1);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, cellSize / 2, cellSize / 2);
        graphics.fillRect(cellSize / 2, cellSize / 2, cellSize / 2, cellSize / 2);
        return new TexturePaint(image, new Rectangle(cellSize, cellSize));
    }

    public JColorButton(Action a) {
        super(a);
        this.setText(" ");
        this.color = null;
        this.text = " ";
    }

    public JColorButton() {
        super(" ");
        this.color = null;
        this.text = " ";
    }

    public void setColor(Color color) {
        this.color = color;
        this.text = color != null ? ColorUtils.colorToRGBPercentString(color) : " ";
        this.textHeight = 0;
        this.textWidth = 0;
        this.revalidate();
        this.repaint();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    protected void paintComponent(Graphics g) {
        String textBackup = this.text;
        try {
            this.text = null;
            super.paintComponent(g);
        }
        finally {
            this.text = textBackup;
        }
        this.paintColor(g);
    }

    private void paintColor(Graphics g) {
        if (this.color != null) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.color.getAlpha() < 255) {
                g2.setPaint(TEXTURE);
                g.fillRect(COLOR_ICON_BORDER_SIZE, COLOR_ICON_BORDER_SIZE, this.getWidth() - COLOR_ICON_BORDER_SIZE * 2, this.getHeight() - COLOR_ICON_BORDER_SIZE * 2);
            }
            g.setColor(this.color);
            g.setFont(this.getFont());
            g.fillRect(COLOR_ICON_BORDER_SIZE, COLOR_ICON_BORDER_SIZE, this.getWidth() - COLOR_ICON_BORDER_SIZE * 2, this.getHeight() - COLOR_ICON_BORDER_SIZE * 2);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.calculateTextSize();
            int xText = (this.getWidth() - this.textWidth) / 2;
            int yText = (this.getHeight() + 3 * this.textHeight / 4) / 2;
            Color backgroundColor = ColorUtils.makeNonTransparent(this.color);
            if (this.color.getAlpha() < 255) {
                g.setColor(backgroundColor);
                g.fillRect(xText - COLOR_ICON_BORDER_SIZE / 2, (this.getHeight() - this.textHeight - COLOR_ICON_BORDER_SIZE) / 2, this.textWidth + COLOR_ICON_BORDER_SIZE, this.textHeight + COLOR_ICON_BORDER_SIZE);
            }
            Color textColor = this.getModel().isEnabled() ? UITools.getTextColorForBackground(backgroundColor) : UITools.getDisabledTextColorForBackground(backgroundColor);
            g.setColor(textColor);
            HiDPIUtils.drawStringUnderlineCharAtWithYCorrection((JComponent)this, (Graphics2D)g2, (String)this.text, (int)-1, (int)xText, (int)yText);
        }
    }

    private void calculateTextSize() {
        Graphics2D g;
        if (this.textWidth == 0 && (g = (Graphics2D)this.getGraphics()) != null) {
            Rectangle2D textBounds = g.getFont().getStringBounds(this.text, g.getFontRenderContext());
            this.textWidth = (int)textBounds.getWidth();
            this.textHeight = (int)textBounds.getHeight();
        }
    }
}

