/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api;

import ghidra.feature.vt.api.FunctionNode;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTScore;

public class FunctionPair {
    private FunctionNode sourceNode;
    private FunctionNode destNode;
    private double simResult;
    private double confResult;

    public FunctionPair(FunctionNode source, FunctionNode dest, double simRes, double confRes) {
        this.sourceNode = source;
        this.destNode = dest;
        this.simResult = simRes;
        this.confResult = confRes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destNode == null ? 0 : this.destNode.hashCode());
        result = 31 * result + (this.sourceNode == null ? 0 : this.sourceNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionPair other = (FunctionPair)obj;
        if (this.destNode == null ? other.destNode != null : !this.destNode.equals(other.destNode)) {
            return false;
        }
        return !(this.sourceNode == null ? other.sourceNode != null : !this.sourceNode.equals(other.sourceNode));
    }

    public VTMatchInfo getMatch(VTMatchSet matchSet) {
        VTMatchInfo result = new VTMatchInfo(matchSet);
        result.setSimilarityScore(new VTScore(this.simResult));
        result.setConfidenceScore(new VTScore(this.confResult));
        result.setAssociationType(VTAssociationType.FUNCTION);
        result.setSourceAddress(this.sourceNode.getAddress());
        result.setDestinationAddress(this.destNode.getAddress());
        result.setSourceLength(this.sourceNode.getLen());
        result.setDestinationLength(this.destNode.getLen());
        return result;
    }

    public String toString() {
        return this.sourceNode.toString() + "," + this.destNode.toString();
    }

    public FunctionNode getSourceNode() {
        return this.sourceNode;
    }

    public FunctionNode getDestNode() {
        return this.destNode;
    }

    public double getSimResult() {
        return this.simResult;
    }

    public double getConfResult() {
        return this.confResult;
    }
}

