/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordTypes;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Omf51Content
extends OmfRecord {
    private int segId;
    private int offset;
    private long dataIndex;
    private int dataSize;
    boolean largeSegmentId;

    public Omf51Content(BinaryReader reader, boolean largeSegmentId) throws IOException {
        super(reader);
        this.largeSegmentId = largeSegmentId;
    }

    @Override
    public void parseData() throws IOException, OmfException {
        this.segId = this.largeSegmentId ? this.dataReader.readNextUnsignedShort() : this.dataReader.readNextUnsignedByte();
        this.offset = this.dataReader.readNextUnsignedShort();
        this.dataIndex = this.dataReader.getPointerIndex();
        this.dataSize = (int)(this.dataEnd - this.dataIndex);
    }

    public int getSegId() {
        return this.segId;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public long getDataIndex() {
        return this.dataIndex;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(Omf51RecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        struct.add(this.largeSegmentId ? WORD : BYTE, "SEG ID", null);
        struct.add(WORD, "offset", null);
        if (this.dataSize > 0) {
            struct.add((DataType)new ArrayDataType(BYTE, this.dataSize, 1), "data", null);
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }
}

