/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.c;

import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;

public enum HB {
    NOT,
    ACCEPTOR,
    DONOR,
    UNKNOWN;


    public static HB getType(Atom atom) {
        Group group = atom.group;
        boolean considerHydrogens = !atom.isHetero();
        switch (atom.getElementNumber()) {
            default: {
                return NOT;
            }
            case 1: {
                if (atom.getCovalentBondCount() == 0) {
                    return DONOR;
                }
                Bond[] bonds = atom.bonds;
                if (bonds == null) {
                    return NOT;
                }
                switch (bonds[0].getOtherAtom(atom).getElementNumber()) {
                    case 7: 
                    case 8: 
                    case 16: {
                        return DONOR;
                    }
                }
                return NOT;
            }
            case 7: {
                if (atom == group.getNitrogenAtom()) {
                    return DONOR;
                }
                if (group.groupID == 9) {
                    return UNKNOWN;
                }
                if (atom.getCovalentHydrogenCount() > 0) {
                    return DONOR;
                }
                if (considerHydrogens) {
                    return ACCEPTOR;
                }
                switch (group.groupID) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 12: 
                    case 19: {
                        return DONOR;
                    }
                }
                return UNKNOWN;
            }
            case 8: 
        }
        if (atom == group.getCarbonylOxygenAtom() || atom.getFormalCharge() == -1) {
            return ACCEPTOR;
        }
        if (atom.getCovalentBondCount() == 0 || atom.getCovalentHydrogenCount() > 0) {
            return UNKNOWN;
        }
        if (considerHydrogens) {
            return ACCEPTOR;
        }
        switch (group.groupID) {
            case 4: 
            case 7: {
                return ACCEPTOR;
            }
        }
        return UNKNOWN;
    }

    public static boolean isPossibleHBond(HB typeA, HB typeB) {
        return typeA == NOT || typeB == NOT ? false : typeA == UNKNOWN || typeA != typeB;
    }
}

