/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.node.printer;

import java.io.PrintWriter;
import org.apache.kafka.image.node.printer.MetadataNodePrinter;
import org.apache.kafka.image.node.printer.MetadataNodeRedactionCriteria;

public class ShellNodePrinter
implements MetadataNodePrinter {
    private final PrintWriter writer;
    private int indentationLevel;

    public ShellNodePrinter(PrintWriter writer) {
        this.writer = writer;
    }

    String indentationString() {
        return " ".repeat(2).repeat(Math.max(0, this.indentationLevel));
    }

    public MetadataNodeRedactionCriteria redactionCriteria() {
        return MetadataNodeRedactionCriteria.Disabled.INSTANCE;
    }

    public void enterNode(String name) {
        this.writer.append(String.format("%s%s:%n", this.indentationString(), name));
        ++this.indentationLevel;
    }

    public void leaveNode() {
        --this.indentationLevel;
    }

    public void output(String text) {
        this.writer.append(String.format("%s%s%n", this.indentationString(), text));
    }
}

