/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.services.resources.admin.fgap.GroupPermissionEvaluator;

public class GroupUtils {
    public static Stream<GroupRepresentation> populateGroupHierarchyFromSubGroups(KeycloakSession session, RealmModel realm, Stream<GroupModel> groups, boolean full, GroupPermissionEvaluator groupEvaluator, boolean subGroupsCount) {
        HashMap groupIdToGroups = new HashMap();
        groups.forEach(group -> {
            if (!(AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(realm) || groupEvaluator.canView() || groupEvaluator.canView((GroupModel)group))) {
                return;
            }
            GroupRepresentation currGroup = GroupUtils.toRepresentation(groupEvaluator, group, full);
            if (subGroupsCount) {
                GroupUtils.populateSubGroupCount(group, currGroup);
            }
            groupIdToGroups.putIfAbsent(currGroup.getId(), currGroup);
            while (currGroup.getParentId() != null) {
                Optional duplicateGroup;
                GroupModel parentModel = session.groups().getGroupById(realm, currGroup.getParentId());
                if (!(AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(realm) || groupEvaluator.canView() || groupEvaluator.canView(parentModel))) {
                    groupIdToGroups.remove(currGroup.getId());
                    break;
                }
                GroupRepresentation parent = groupIdToGroups.computeIfAbsent(currGroup.getParentId(), id -> GroupUtils.toRepresentation(groupEvaluator, parentModel, full));
                if (subGroupsCount) {
                    GroupUtils.populateSubGroupCount(parentModel, parent);
                }
                GroupRepresentation finalCurrGroup = currGroup;
                Optional<Object> optional = duplicateGroup = parent.getSubGroups() == null ? Optional.empty() : parent.getSubGroups().stream().filter(g -> g.equals((Object)finalCurrGroup)).findFirst();
                if (duplicateGroup.isPresent()) {
                    ((GroupRepresentation)duplicateGroup.get()).merge(currGroup);
                } else {
                    parent.getSubGroups().add(currGroup);
                }
                groupIdToGroups.remove(currGroup.getId());
                currGroup = parent;
            }
        });
        return groupIdToGroups.values().stream().sorted(Comparator.comparing(GroupRepresentation::getName));
    }

    public static GroupRepresentation populateSubGroupCount(GroupModel group, GroupRepresentation representation) {
        representation.setSubGroupCount(group.getSubGroupsCount());
        return representation;
    }

    public static GroupRepresentation toRepresentation(GroupPermissionEvaluator groupsEvaluator, GroupModel groupTree, boolean full) {
        GroupRepresentation rep = ModelToRepresentation.toRepresentation((GroupModel)groupTree, (boolean)full);
        rep.setAccess(groupsEvaluator.getAccess(groupTree));
        return rep;
    }
}

