/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.type.Type;

public final class TypedValue
implements Serializable {
    private final Type type;
    private final Object value;
    private transient ValueHolder<Integer> hashcode;

    public TypedValue(Type type, Object value) {
        this.type = type;
        this.value = value;
        this.hashcode = TypedValue.hashCode(type, value);
    }

    public Object getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    public int hashCode() {
        return this.hashcode.getValue();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TypedValue that = (TypedValue)other;
        return this.type.getReturnedClass() == that.type.getReturnedClass() && this.type.isEqual(that.value, this.value);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.hashcode = TypedValue.hashCode(this.type, this.value);
    }

    private static ValueHolder<Integer> hashCode(Type type, Object value) {
        return new ValueHolder<ValueHolder.DeferredInitializer<Integer>>(() -> value == null ? 0 : type.getHashCode(value));
    }
}

