/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.representations.idm.authorization.DecisionStrategy;

public abstract class AbstractDecisionCollector
implements Decision<Evaluation> {
    protected final Map<ResourcePermission, Result> results = new LinkedHashMap<ResourcePermission, Result>();

    @Override
    public void onDecision(Evaluation evaluation) {
        Policy parentPolicy = evaluation.getParentPolicy();
        ResourcePermission permission = evaluation.getPermission();
        if (parentPolicy != null) {
            if (parentPolicy.equals(evaluation.getPolicy())) {
                this.results.computeIfAbsent(permission, permission1 -> {
                    for (Result result : this.results.values()) {
                        Result.PolicyResult policyResult = result.getPolicy(parentPolicy);
                        if (policyResult == null) continue;
                        Result newResult = new Result((ResourcePermission)permission1, evaluation);
                        Result.PolicyResult newPolicyResult = newResult.policy(parentPolicy);
                        for (Result.PolicyResult associatePolicy : policyResult.getAssociatedPolicies()) {
                            newPolicyResult.policy(associatePolicy.getPolicy(), associatePolicy.getEffect());
                        }
                        Map<String, Set<String>> claims = result.getPermission().getClaims();
                        if (!claims.isEmpty()) {
                            permission1.addClaims(claims);
                        }
                        return newResult;
                    }
                    return new Result((ResourcePermission)permission1, evaluation);
                }).policy(parentPolicy);
            } else {
                this.results.computeIfAbsent(permission, p -> new Result((ResourcePermission)p, evaluation)).policy(parentPolicy).policy(evaluation.getPolicy(), evaluation.getEffect());
            }
        } else {
            this.results.computeIfAbsent(permission, p -> new Result((ResourcePermission)p, evaluation)).setStatus(evaluation.getEffect());
        }
    }

    @Override
    public void onComplete() {
        this.onComplete(this.results.values());
    }

    @Override
    public void onComplete(ResourcePermission permission) {
        Result result = this.results.get(permission);
        if (result != null) {
            this.onComplete(result);
        }
    }

    protected void onComplete(Result result) {
    }

    protected void onComplete(Collection<Result> permissions) {
    }

    protected boolean isGranted(Result.PolicyResult policyResult) {
        Policy policy = policyResult.getPolicy();
        DecisionStrategy decisionStrategy = policy.getDecisionStrategy();
        switch (decisionStrategy) {
            case AFFIRMATIVE: {
                for (Result.PolicyResult decision : policyResult.getAssociatedPolicies()) {
                    if (!Decision.Effect.PERMIT.equals((Object)decision.getEffect())) continue;
                    return true;
                }
                return false;
            }
            case CONSENSUS: {
                int grantCount = 0;
                int denyCount = policy.getAssociatedPolicies().size();
                for (Result.PolicyResult decision : policyResult.getAssociatedPolicies()) {
                    if (!decision.getEffect().equals((Object)Decision.Effect.PERMIT)) continue;
                    ++grantCount;
                    --denyCount;
                }
                return grantCount > denyCount;
            }
        }
        for (Result.PolicyResult decision : policyResult.getAssociatedPolicies()) {
            if (!Decision.Effect.DENY.equals((Object)decision.getEffect())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEvaluated(String scope) {
        for (Result result : this.results.values()) {
            for (Result.PolicyResult policyResult : result.getResults()) {
                Policy policy = policyResult.getPolicy();
                if (!policy.getScopes().stream().anyMatch(s -> s.getName().equals(scope))) continue;
                return true;
            }
        }
        return false;
    }
}

