/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter.internal;

import jakarta.persistence.AttributeConverter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.hibernate.internal.util.GenericsHelper;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.converter.internal.AttributeConverterBean;
import org.hibernate.type.descriptor.converter.internal.AttributeConverterInstance;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;

public class ConverterHelper {
    public static <X, Y> BasicValueConverter<X, Y> createValueConverter(AttributeConverter<X, Y> converter, JavaTypeRegistry registry) {
        ParameterizedType converterType = GenericsHelper.extractParameterizedType(converter.getClass(), AttributeConverter.class);
        Type[] typeArguments = converterType.getActualTypeArguments();
        Class<?> domainJavaClass = GenericsHelper.extractClass(typeArguments[0]);
        Class<?> relationalJavaClass = GenericsHelper.extractClass(typeArguments[1]);
        return new AttributeConverterInstance<X, Y>(converter, registry.resolveDescriptor(domainJavaClass), registry.resolveDescriptor(relationalJavaClass));
    }

    public static <X, Y> JpaAttributeConverter<X, Y> createJpaAttributeConverter(ManagedBean<? extends AttributeConverter<X, Y>> bean, JavaTypeRegistry registry) {
        ParameterizedType converterType = GenericsHelper.extractParameterizedType(bean.getBeanClass(), AttributeConverter.class);
        Type[] typeArguments = converterType.getActualTypeArguments();
        Class<?> domainJavaClass = GenericsHelper.extractClass(typeArguments[0]);
        Class<?> relationalJavaClass = GenericsHelper.extractClass(typeArguments[1]);
        return new AttributeConverterBean(bean, registry.resolveDescriptor(bean.getBeanClass()), registry.resolveDescriptor(domainJavaClass), registry.resolveDescriptor(relationalJavaClass));
    }
}

