/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.util.CssPreprocessorUtils;
import org.netbeans.spi.editor.document.OnSaveTask;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class CPOnSaveHook
implements OnSaveTask.Factory {
    private static final RequestProcessor RP = new RequestProcessor(CPOnSaveHook.class);
    private static final Logger LOG = Logger.getLogger(CPOnSaveHook.class.getSimpleName());

    public OnSaveTask createTask(OnSaveTask.Context context) {
        Document doc = context.getDocument();
        final FileObject fileObject = DataLoadersBridge.getDefault().getFileObject(doc);
        final Project project = fileObject == null ? null : FileOwnerQuery.getOwner((FileObject)fileObject);
        return project == null ? null : new OnSaveTask(){
            private boolean cancelled;
            final /* synthetic */ CPOnSaveHook this$0;
            {
                this.this$0 = this$0;
            }

            public void performTask() {
                if (!this.cancelled) {
                    RP.post(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            String mimeType = fileObject.getMIMEType();
                            CssPreprocessorType type = CssPreprocessorType.find(mimeType);
                            if (type == null) {
                                LOG.log(Level.WARNING, "Cannot find CssPreprocessorType for MIME type {0} (filename: {1})", new Object[]{mimeType, fileObject.getNameExt()});
                                return;
                            }
                            CssPreprocessorUtils.processSavedFile(project, type);
                            LOG.log(Level.INFO, "processSavedFile called for {0} type on project {1}.", new Object[]{type.getDisplayName(), project.getProjectDirectory().getPath()});
                        }
                    });
                }
            }

            public void runLocked(Runnable run) {
                run.run();
            }

            public boolean cancel() {
                this.cancelled = true;
                return true;
            }
        };
    }
}

