/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.breakpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class DAPLineBreakpoint
extends Breakpoint {
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_HIDDEN = "hidden";
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final AtomicBoolean hidden = new AtomicBoolean(false);
    private final FileObject fileObject;
    private final int lineNumber;
    private volatile String condition;

    private DAPLineBreakpoint(FileObject fileObject, String filePath, int lineNumber) {
        this.fileObject = fileObject;
        this.lineNumber = lineNumber;
    }

    public static DAPLineBreakpoint create(Line line) {
        int lineNumber = line.getLineNumber() + 1;
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        return DAPLineBreakpoint.create(fileObject, lineNumber);
    }

    public static DAPLineBreakpoint create(FileObject fileObject, int lineNumber) {
        String filePath = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        return new DAPLineBreakpoint(fileObject, filePath, lineNumber);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @NonNull
    public FileObject getFileObject() {
        return this.fileObject;
    }

    @CheckForNull
    public Line getLine() {
        Line.Set ls;
        DataObject dataObject;
        FileObject fo = this.fileObject;
        if (fo == null) {
            return null;
        }
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
        if (lineCookie != null && (ls = lineCookie.getLineSet()) != null) {
            try {
                return ls.getCurrent(this.lineNumber - 1);
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void disable() {
        if (this.enabled.compareAndSet(true, false)) {
            this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void enable() {
        if (this.enabled.compareAndSet(false, true)) {
            this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
        }
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String condition) {
        String oldCondition;
        DAPLineBreakpoint dAPLineBreakpoint = this;
        synchronized (dAPLineBreakpoint) {
            oldCondition = this.condition;
            if (Objects.equals(oldCondition, condition)) {
                return;
            }
            this.condition = condition;
        }
        this.firePropertyChange(PROP_CONDITION, oldCondition, condition);
    }

    public boolean isHidden() {
        return this.hidden.get();
    }

    public void setHidden(boolean h) {
        boolean old = this.hidden.getAndSet(h);
        if (old != h) {
            this.firePropertyChange(PROP_HIDDEN, old, h);
        }
    }

    public Breakpoint.GroupProperties getGroupProperties() {
        return new CPPGroupProperties();
    }

    private final class CPPGroupProperties
    extends Breakpoint.GroupProperties {
        private CPPEngineListener engineListener;

        private CPPGroupProperties() {
        }

        public String getLanguage() {
            return "C/C++";
        }

        public String getType() {
            return NbBundle.getMessage(DAPLineBreakpoint.class, (String)"LineBrkp_Type");
        }

        private FileObject getFile() {
            return DAPLineBreakpoint.this.getFileObject();
        }

        public FileObject[] getFiles() {
            return new FileObject[]{DAPLineBreakpoint.this.getFileObject()};
        }

        public Project[] getProjects() {
            FileObject f = this.getFile();
            while (!(f == null || (f = f.getParent()) != null && ProjectManager.getDefault().isProject(f))) {
            }
            if (f != null) {
                try {
                    return new Project[]{ProjectManager.getDefault().findProject(f)};
                }
                catch (IOException iOException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }

        public DebuggerEngine[] getEngines() {
            DebuggerEngine[] engines;
            if (this.engineListener == null) {
                this.engineListener = new CPPEngineListener();
                DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)((Object)this.engineListener), (Object)DebuggerManager.getDebuggerManager()));
            }
            if ((engines = DebuggerManager.getDebuggerManager().getDebuggerEngines()).length == 0) {
                return null;
            }
            if (engines.length == 1) {
                if (this.isDAPEngine(engines[0])) {
                    return engines;
                }
                return null;
            }
            ArrayList<DebuggerEngine> antEngines = null;
            for (DebuggerEngine e : engines) {
                if (!this.isDAPEngine(e)) continue;
                if (antEngines == null) {
                    antEngines = new ArrayList<DebuggerEngine>();
                }
                antEngines.add(e);
            }
            if (antEngines == null) {
                return null;
            }
            return antEngines.toArray(new DebuggerEngine[0]);
        }

        private boolean isDAPEngine(DebuggerEngine e) {
            return e.lookupFirst(null, DAPDebugger.class) != null;
        }

        public boolean isHidden() {
            return false;
        }

        private final class CPPEngineListener
        extends DebuggerManagerAdapter {
            private CPPEngineListener() {
            }

            public void engineAdded(DebuggerEngine engine) {
                if (CPPGroupProperties.this.isDAPEngine(engine)) {
                    DAPLineBreakpoint.this.firePropertyChange("groupProperties", null, (Object)CPPGroupProperties.this);
                }
            }

            public void engineRemoved(DebuggerEngine engine) {
                if (CPPGroupProperties.this.isDAPEngine(engine)) {
                    DAPLineBreakpoint.this.firePropertyChange("groupProperties", null, (Object)CPPGroupProperties.this);
                }
            }
        }
    }
}

