/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.containerengine.model.CreateWorkloadMappingDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateWorkloadMappingRequest
extends BmcRequest<CreateWorkloadMappingDetails> {
    private String clusterId;
    private CreateWorkloadMappingDetails createWorkloadMappingDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getClusterId() {
        return this.clusterId;
    }

    public CreateWorkloadMappingDetails getCreateWorkloadMappingDetails() {
        return this.createWorkloadMappingDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateWorkloadMappingDetails getBody$() {
        return this.createWorkloadMappingDetails;
    }

    public Builder toBuilder() {
        return new Builder().clusterId(this.clusterId).createWorkloadMappingDetails(this.createWorkloadMappingDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",clusterId=").append(String.valueOf(this.clusterId));
        sb.append(",createWorkloadMappingDetails=").append(String.valueOf((Object)this.createWorkloadMappingDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateWorkloadMappingRequest)) {
            return false;
        }
        CreateWorkloadMappingRequest other = (CreateWorkloadMappingRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.clusterId, other.clusterId) && Objects.equals((Object)this.createWorkloadMappingDetails, (Object)other.createWorkloadMappingDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.clusterId == null ? 43 : this.clusterId.hashCode());
        result = result * 59 + (this.createWorkloadMappingDetails == null ? 43 : this.createWorkloadMappingDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateWorkloadMappingRequest, CreateWorkloadMappingDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String clusterId = null;
        private CreateWorkloadMappingDetails createWorkloadMappingDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder createWorkloadMappingDetails(CreateWorkloadMappingDetails createWorkloadMappingDetails) {
            this.createWorkloadMappingDetails = createWorkloadMappingDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateWorkloadMappingRequest o) {
            this.clusterId(o.getClusterId());
            this.createWorkloadMappingDetails(o.getCreateWorkloadMappingDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateWorkloadMappingRequest build() {
            CreateWorkloadMappingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateWorkloadMappingDetails body) {
            this.createWorkloadMappingDetails(body);
            return this;
        }

        public CreateWorkloadMappingRequest buildWithoutInvocationCallback() {
            CreateWorkloadMappingRequest request = new CreateWorkloadMappingRequest();
            request.clusterId = this.clusterId;
            request.createWorkloadMappingDetails = this.createWorkloadMappingDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

