/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.openide.util.WeakListeners;

public class CssPreferences {
    public static final String FIND_IN_UNRELATED_FILES = "cssFindInUnrelatedFiles";
    public static final boolean FIND_IN_UNRELATED_FILES_DEFAULT = true;
    private static boolean findInUnrelatedFiles;
    private static final AtomicBoolean initialized;
    private static Preferences preferences;
    private static final PreferenceChangeListener preferencesTracker;

    private static void lazyIntialize() {
        if (initialized.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)CssTokenId.language().mimeType()).lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferencesTracker, (Object)preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    private CssPreferences() {
    }

    public static boolean findInUnrelatedFiles() {
        CssPreferences.lazyIntialize();
        return findInUnrelatedFiles;
    }

    public static void setFindInUnrelatedFiles(boolean value) {
        CssPreferences.lazyIntialize();
        preferences.putBoolean(FIND_IN_UNRELATED_FILES, value);
    }

    static {
        initialized = new AtomicBoolean(false);
        preferencesTracker = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String settingName;
                String string = settingName = evt == null ? null : evt.getKey();
                if (settingName == null || CssPreferences.FIND_IN_UNRELATED_FILES.equals(settingName)) {
                    findInUnrelatedFiles = preferences.getBoolean(CssPreferences.FIND_IN_UNRELATED_FILES, true);
                }
            }
        };
    }
}

