/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.actions.OpenPOMAction;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.nodes.Bundle;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.netbeans.modules.project.ui.api.ProjectActionUtils;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class ModulesNode
extends AbstractNode {
    private static final String MODULES_BADGE = "org/netbeans/modules/maven/modules-badge.png";
    private final NbMavenProjectImpl proj;

    public ModulesNode(NbMavenProjectImpl proj) {
        super(Children.create((ChildFactory)new ModulesChildFactory(proj), (boolean)true));
        this.proj = proj;
        this.setName("Modules");
        this.setDisplayName(Bundle.LBL_Modules());
    }

    public Action[] getActions(boolean bool) {
        return new Action[]{new AddModuleAction(), new CreateModuleAction()};
    }

    private Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)MODULES_BADGE, (boolean)true);
        return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
    }

    public Image getIcon(int type) {
        return this.getIcon(false);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(true);
    }

    private static class ModulesChildFactory
    extends ChildFactory<Wrapper> {
        private final NbMavenProjectImpl project;
        private final PropertyChangeListener listener;

        ModulesChildFactory(NbMavenProjectImpl proj) {
            this.project = proj;
            NbMavenProject watcher = this.project.getProjectWatcher();
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        this.refresh(false);
                    }
                }
            };
            watcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)watcher));
        }

        protected boolean createKeys(List<Wrapper> modules) {
            for (String module : this.project.getOriginalMavenProject().getModules()) {
                File base = this.project.getOriginalMavenProject().getBasedir();
                File projDir = FileUtil.normalizeFile((File)new File(base, module));
                FileObject fo = FileUtil.toFileObject((File)projDir);
                if (fo == null) continue;
                try {
                    Project prj = ProjectManager.getDefault().findProject(fo);
                    if (prj == null) {
                        ProjectManager.getDefault().clearNonProjectCache();
                        prj = ProjectManager.getDefault().findProject(fo);
                    }
                    if (prj == null || prj.getLookup().lookup(NbMavenProjectImpl.class) == null) continue;
                    Wrapper wr = new Wrapper();
                    wr.proj = (NbMavenProjectImpl)prj;
                    MavenProject mp = wr.proj.getOriginalMavenProject();
                    wr.isAggregator = "pom".equals(mp.getPackaging()) && !mp.getModules().isEmpty();
                    wr.provider = (LogicalViewProvider)prj.getLookup().lookup(LogicalViewProvider.class);
                    assert (wr.provider != null);
                    modules.add(wr);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return true;
        }

        protected Node createNodeForKey(Wrapper wr) {
            return new ProjectFilterNode(this.project, wr.proj, wr.provider.createLogicalView(), wr.isAggregator);
        }
    }

    private class AddModuleAction
    extends AbstractAction {
        AddModuleAction() {
            super(Bundle.BTN_add_module());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser c = ProjectChooser.projectChooser();
            File basedir = FileUtil.toFile((FileObject)ModulesNode.this.proj.getProjectDirectory());
            c.setCurrentDirectory(basedir);
            if (c.showOpenDialog(org.openide.util.Utilities.findDialogParent()) != 0) {
                return;
            }
            final ArrayList<String> mods = new ArrayList<String>();
            for (File d : c.getSelectedFiles()) {
                String mod = FileUtilities.relativizeFile(basedir, d);
                if (mod == null || mod.equals(".")) continue;
                mods.add(mod);
            }
            if (mods.isEmpty()) {
                return;
            }
            Utilities.performPOMModelOperations((FileObject)ModulesNode.this.proj.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(new ModelOperation<POMModel>(){
                final /* synthetic */ AddModuleAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void performOperation(POMModel model) {
                    for (String mod : mods) {
                        model.getProject().addModule(mod);
                    }
                }
            }));
        }
    }

    private class CreateModuleAction
    extends AbstractAction {
        CreateModuleAction() {
            super(Bundle.BTN_create_module());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Action act = CommonProjectActions.newProjectAction();
            act.putValue("PRESELECT_CATEGORY", "Maven2");
            act.putValue("projdir", ModulesNode.this.proj.getPOMFile().getParentFile());
            act.putValue("initialValueProperties", new String[]{"groupId", "version"});
            act.putValue("groupId", ModulesNode.this.proj.getOriginalMavenProject().getGroupId());
            act.putValue("version", ModulesNode.this.proj.getOriginalMavenProject().getVersion());
            act.actionPerformed(new ActionEvent(this, 1001, "actionPerformed"));
        }
    }

    private static class OpenProjectAction
    extends AbstractAction
    implements ContextAwareAction {
        static final OpenProjectAction SINGLETON = new OpenProjectAction();

        private OpenProjectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(final Lookup context) {
            return new AbstractAction(this, Bundle.BTN_Open_Project()){
                final /* synthetic */ OpenProjectAction this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collection projects = context.lookupAll(NbMavenProjectImpl.class);
                    final NbMavenProjectImpl[] projectsArray = projects.toArray(new NbMavenProjectImpl[0]);
                    if (projectsArray.length > 0) {
                        RequestProcessor.getDefault().post(new Runnable(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                OpenProjects.getDefault().open((Project[])projectsArray, false, true);
                                RequestProcessor.getDefault().post(new Runnable(){
                                    final /* synthetic */ OpenProjectAction.1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        ProjectActionUtils.selectAndExpandProject((Project)projectsArray[0]);
                                    }
                                }, 500);
                            }
                        });
                    }
                }
            };
        }
    }

    private static class RemoveModuleAction
    extends AbstractAction {
        private final NbMavenProjectImpl project;
        private final NbMavenProjectImpl parent;

        RemoveModuleAction(NbMavenProjectImpl parent, NbMavenProjectImpl proj) {
            this.putValue("Name", Bundle.BTN_Remove_Module());
            this.project = proj;
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)Bundle.MSG_Remove_Module(), 0);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (ret == NotifyDescriptor.YES_OPTION) {
                FileObject fo = FileUtil.toFileObject((File)this.parent.getPOMFile());
                ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                    public void performOperation(POMModel model) {
                        List modules = model.getProject().getModules();
                        if (modules != null) {
                            for (String path : modules) {
                                File rel = new File(parent.getPOMFile().getParent(), path);
                                File norm = FileUtil.normalizeFile((File)rel);
                                FileObject folder = FileUtil.toFileObject((File)norm);
                                if (folder == null || !folder.equals(project.getProjectDirectory())) continue;
                                model.getProject().removeModule(path);
                                break;
                            }
                        }
                    }
                };
                Utilities.performPOMModelOperations((FileObject)fo, Collections.singletonList(operation));
                NbMavenProject.fireMavenProjectReload(this.project);
            }
        }
    }

    private static class ProjectFilterNode
    extends FilterNode {
        private final NbMavenProjectImpl project;
        private final NbMavenProjectImpl parent;

        ProjectFilterNode(NbMavenProjectImpl parent, NbMavenProjectImpl proj, Node original, boolean isAggregator) {
            super(original, isAggregator ? FilterNode.Children.create((ChildFactory)new ModulesChildFactory(proj), (boolean)true) : FilterNode.Children.LEAF);
            this.project = proj;
            this.parent = parent;
        }

        public Action[] getActions(boolean b) {
            ArrayList<Object> lst = new ArrayList<Object>();
            lst.add(OpenProjectAction.SINGLETON);
            lst.add(OpenPOMAction.instance());
            lst.add(new RemoveModuleAction(this.parent, this.project));
            return lst.toArray(new Action[0]);
        }

        public Action getPreferredAction() {
            return OpenProjectAction.SINGLETON;
        }
    }

    private static class Wrapper {
        boolean isAggregator;
        LogicalViewProvider provider;
        NbMavenProjectImpl proj;

        private Wrapper() {
        }
    }
}

