/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.openide.util.NbBundle;

public class DatabaseTypePropertyEditor
implements PropertyEditor {
    private int[] constants;
    private String[] names;
    private int index;
    private String name;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public DatabaseTypePropertyEditor() {
        this.constants = new int[]{2003, -5, -2, -7, 2004, 1, 2005, 91, 3, 2001, 8, 6, 4, 2000, -4, -1, 2, 7, 2006, 5, 92, 93, -6, -3, 12, 1111};
        this.names = new String[]{NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_ARRAY"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_BIGINT"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_BINARY"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_BIT"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_BLOB"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_CHAR"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_CLOB"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_DATE"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_DECIMAL"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_DISTINCT"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_DOUBLE"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_FLOAT"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_INTEGER"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_JAVA_OBJECT"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_LONGVARBINARY"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_LONGVARCHAR"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_NUMERIC"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_REAL"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_REF"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_SMALLINT"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_TIME"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_TIMESTAMP"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_TINYINT"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_VARBINARY"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_VARCHAR"), NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_OTHER")};
    }

    public DatabaseTypePropertyEditor(int[] types, String[] titles) {
        this.constants = types;
        this.names = titles;
    }

    @Override
    public Object getValue() {
        return this.constants[this.index];
    }

    @Override
    public void setValue(Object object) {
        int i;
        Integer type;
        try {
            type = Integer.valueOf(object.toString());
        }
        catch (NumberFormatException exc) {
            String message = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"EXC_CannotOperateWith", (Object)object.toString());
            throw new IllegalArgumentException(message);
        }
        int ii = type;
        int k = this.constants.length;
        for (i = 0; i < k && this.constants[i] != ii; ++i) {
        }
        if (i == k) {
            switch (ii) {
                case -7: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_BIT");
                    break;
                }
                case -6: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_TINYINT");
                    break;
                }
                case 5: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_SMALLINT");
                    break;
                }
                case 4: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_INTEGER");
                    break;
                }
                case -5: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_BIGINT");
                    break;
                }
                case 6: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_FLOAT");
                    break;
                }
                case 7: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_REAL");
                    break;
                }
                case 8: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_DOUBLE");
                    break;
                }
                case 2: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_NUMERIC");
                    break;
                }
                case 3: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_DECIMAL");
                    break;
                }
                case 1: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_CHAR");
                    break;
                }
                case 12: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_VARCHAR");
                    break;
                }
                case -1: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_LONGVARCHAR");
                    break;
                }
                case 91: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_DATE");
                    break;
                }
                case 92: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_TIME");
                    break;
                }
                case 93: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_TIMESTAMP");
                    break;
                }
                case -2: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_BINARY");
                    break;
                }
                case -3: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_VARBINARY");
                    break;
                }
                case -4: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_LONGVARBINARY");
                    break;
                }
                case 0: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_NULL");
                    break;
                }
                case 1111: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_OTHER");
                    break;
                }
                case 2000: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_JAVA_OBJECT");
                    break;
                }
                case 2001: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_DISTINCT");
                    break;
                }
                case 2002: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_STRUCT");
                    break;
                }
                case 2003: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_ARRAY");
                    break;
                }
                case 2004: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_BLOB");
                    break;
                }
                case 2005: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_CLOB");
                    break;
                }
                case 2006: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_REF");
                    break;
                }
                default: {
                    this.name = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"SQL_UNKNOWN");
                }
            }
            this.index = 0;
        } else {
            this.index = i;
            this.name = this.names[i];
        }
        this.support.firePropertyChange(null, null, null);
    }

    @Override
    public String getAsText() {
        return this.name;
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        int i;
        int k = this.names.length;
        for (i = 0; i < k && !this.names[i].equals(string); ++i) {
        }
        if (i == k) {
            String message = NbBundle.getMessage(DatabaseTypePropertyEditor.class, (String)"EXC_CannotFindAsText", (Object)string);
            throw new IllegalArgumentException(message);
        }
        this.index = i;
        this.name = this.names[i];
    }

    @Override
    public String getJavaInitializationString() {
        return "" + this.index;
    }

    @Override
    public String[] getTags() {
        return this.names;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

