/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.moduletask.classfile;

import java.io.IOException;
import java.util.Arrays;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.Reader;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.Writer;

public class Attribute {
    private final int nameIndex;
    private final byte[] info;

    public Attribute(int nameIndex, byte[] info) {
        this.nameIndex = nameIndex;
        this.info = info;
    }

    Attribute(Reader in) throws IOException {
        this.nameIndex = in.readUnsignedShort();
        this.info = new byte[(int)in.readUnsignedInt()];
        for (int i = 0; i < this.info.length; ++i) {
            this.info[i] = in.readByte();
        }
    }

    void write(Writer out) throws IOException {
        out.writeUnsignedShort(this.nameIndex);
        out.writeUnsignedInt(this.info.length);
        for (int i = 0; i < this.info.length; ++i) {
            out.writeByte(this.info[i]);
        }
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public byte[] getValue() {
        return Arrays.copyOf(this.info, this.info.length);
    }

    public String toString() {
        return "nameIndex: " + this.nameIndex + ", length: " + this.info.length;
    }
}

