/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.lexer;

import java.util.logging.Logger;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.php.smarty.SmartyFramework;
import org.netbeans.modules.php.smarty.editor.TplMetaData;
import org.netbeans.modules.php.smarty.editor.lexer.TplTopTokenId;
import org.netbeans.modules.php.smarty.editor.utlis.LexerUtils;
import org.netbeans.modules.php.smarty.editor.utlis.TplUtils;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class TplTopLexer
implements Lexer<TplTopTokenId> {
    private static final Logger LOG = Logger.getLogger(TplTopLexer.class.getName());
    private final TplTopColoringLexer scanner;
    private TokenFactory<TplTopTokenId> tokenFactory;
    private final InputAttributes inputAttributes;
    private final TplMetaData tplMetaData;

    private TplTopLexer(LexerRestartInfo<TplTopTokenId> info) {
        CompoundState state = info.state() == null ? new CompoundState(State.INIT, SubState.NO_SUB_STATE, 0, TplTopTokenId.T_HTML, null) : (CompoundState)info.state();
        this.tokenFactory = info.tokenFactory();
        this.inputAttributes = info.inputAttributes();
        this.tplMetaData = this.inputAttributes != null ? (TplMetaData)this.inputAttributes.getValue(LanguagePath.get(TplTopTokenId.language()), TplMetaData.class) : TplUtils.getProjectPropertiesForFileObject(null);
        this.scanner = new TplTopColoringLexer(info, state, this.tplMetaData);
    }

    public static synchronized TplTopLexer create(LexerRestartInfo<TplTopTokenId> info) {
        return new TplTopLexer(info);
    }

    public Token<TplTopTokenId> nextToken() {
        TplTopTokenId tokenId = this.scanner.nextToken();
        Token token = null;
        if (tokenId != null) {
            token = this.tokenFactory.createToken((TokenId)tokenId);
        }
        return token;
    }

    public Object state() {
        return this.scanner.getState();
    }

    public void release() {
    }

    private static class CompoundState {
        private State lexerState;
        private SubState lexerSubState;
        private int embeddingLevel;
        private TplTopTokenId lastState;
        private String stringDelimiter;

        public CompoundState(State lexerState, SubState lexerSubState, int embeddingLevel, TplTopTokenId lastState, String stringDelimiter) {
            this.lexerState = lexerState;
            this.lexerSubState = lexerSubState;
            this.embeddingLevel = embeddingLevel;
            this.lastState = lastState;
            this.stringDelimiter = stringDelimiter;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompoundState other = (CompoundState)obj;
            if (this.lexerState != other.lexerState) {
                return false;
            }
            if (this.lexerSubState != other.lexerSubState) {
                return false;
            }
            if (this.embeddingLevel != other.embeddingLevel) {
                return false;
            }
            if (this.lastState != other.lastState) {
                return false;
            }
            return !(this.stringDelimiter == null ? other.stringDelimiter != null : !this.stringDelimiter.equals(other.stringDelimiter));
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + this.lexerState.ordinal();
            hash = 17 * hash + this.lexerSubState.ordinal();
            hash = 17 * hash + this.embeddingLevel;
            hash = 17 * hash + this.lastState.ordinal();
            hash = this.stringDelimiter != null ? 17 * hash + this.stringDelimiter.hashCode() : 17 * hash;
            return hash;
        }

        public String toString() {
            return "State(hash=" + this.hashCode() + ",s=" + (Object)((Object)this.lexerState) + ",ss=" + (Object)((Object)this.lexerSubState) + ",ls=" + (Object)((Object)this.lastState) + ",sdel=" + this.stringDelimiter + ")";
        }
    }

    private static enum State {
        INIT,
        OUTER,
        AFTER_DELIMITER,
        OPEN_DELIMITER,
        CLOSE_DELIMITER,
        IN_COMMENT,
        IN_SMARTY,
        IN_STRING,
        IN_PHP,
        AFTER_SUBSTATE,
        IN_LITERAL;

    }

    private static enum SubState {
        NO_SUB_STATE,
        PHP_CODE,
        LITERAL;

    }

    private static class TplTopColoringLexer {
        private final LexerInput input;
        private final TplMetaData metadata;
        private State state;
        private SubState subState;
        private int embeddingLevel;
        private TplTopTokenId lastState;
        private String stringDelimiter;

        public TplTopColoringLexer(LexerRestartInfo<TplTopTokenId> info, CompoundState state, TplMetaData metadata) {
            this.input = info.input();
            this.state = state.lexerState;
            this.subState = state.lexerSubState;
            this.embeddingLevel = state.embeddingLevel;
            this.lastState = state.lastState;
            this.stringDelimiter = state.stringDelimiter;
            this.metadata = metadata != null ? metadata : TplUtils.getProjectPropertiesForFileObject(null);
        }

        public TplTopTokenId nextToken() {
            int c = this.input.read();
            int openDelimiterLength = this.getOpenDelimiterLength();
            int closeDelimiterLength = this.getCloseDelimiterLength();
            if (c == -1) {
                return null;
            }
            while (c != -1) {
                char cc = (char)c;
                CharSequence text = this.input.readText();
                int textLength = text.length();
                block0 : switch (this.state.ordinal()) {
                    case 0: 
                    case 1: {
                        if (!this.isSmartyOpenDelimiter(text)) break;
                        c = this.input.read();
                        this.input.backup(1);
                        if ((LexerUtils.isWS(c) || this.getSmartyVersion() != SmartyFramework.Version.SMARTY3) && this.getSmartyVersion() != SmartyFramework.Version.SMARTY2) break;
                        this.state = State.OPEN_DELIMITER;
                        this.input.backup(openDelimiterLength);
                        if (textLength <= openDelimiterLength) break;
                        return TplTopTokenId.T_HTML;
                    }
                    case 3: {
                        if (textLength < openDelimiterLength) break;
                        this.state = State.AFTER_DELIMITER;
                        if (this.subState == SubState.NO_SUB_STATE) {
                            if (this.isSmartyOpenDelimiter("{")) {
                                c = this.input.read();
                                this.input.backup(1);
                                if (c == -1) {
                                    return TplTopTokenId.T_SMARTY_OPEN_DELIMITER;
                                }
                                if (LexerUtils.isWS(c) && c != -1 && this.getSmartyVersion() == SmartyFramework.Version.SMARTY3) {
                                    this.state = this.lastState == TplTopTokenId.T_SMARTY ? State.IN_SMARTY : State.OUTER;
                                    return this.lastState;
                                }
                                ++this.embeddingLevel;
                                this.lastState = TplTopTokenId.T_SMARTY;
                                return TplTopTokenId.T_SMARTY_OPEN_DELIMITER;
                            }
                            return TplTopTokenId.T_SMARTY_OPEN_DELIMITER;
                        }
                        if (this.input.readLength() <= openDelimiterLength) break;
                        this.input.backup(this.input.readLength() - openDelimiterLength);
                        if (this.subState == SubState.LITERAL) {
                            return TplTopTokenId.T_HTML;
                        }
                        return TplTopTokenId.T_PHP;
                    }
                    case 2: {
                        if (LexerUtils.isWS(c)) {
                            if (this.subState != SubState.NO_SUB_STATE) break;
                            this.lastState = TplTopTokenId.T_SMARTY;
                            return TplTopTokenId.T_SMARTY;
                        }
                        String lastWord = this.readNextWord(c);
                        switch (this.subState.ordinal()) {
                            case 2: {
                                if (lastWord.startsWith("/literal")) {
                                    this.subState = SubState.NO_SUB_STATE;
                                    this.state = State.OPEN_DELIMITER;
                                    this.input.backup(this.input.readLength());
                                    break block0;
                                }
                                this.input.backup(this.input.readLength() - 1);
                                this.state = State.IN_LITERAL;
                                return TplTopTokenId.T_HTML;
                            }
                            case 1: {
                                if (lastWord.startsWith("/php")) {
                                    this.subState = SubState.NO_SUB_STATE;
                                    this.state = State.OPEN_DELIMITER;
                                    this.input.backup(this.input.readLength());
                                    break block0;
                                }
                                this.state = State.IN_PHP;
                                return TplTopTokenId.T_PHP;
                            }
                        }
                        if (lastWord.charAt(0) == '*') {
                            this.state = State.IN_COMMENT;
                            this.input.backup(lastWord.length() - 1);
                            return TplTopTokenId.T_COMMENT;
                        }
                        if (lastWord.startsWith("literal" + this.metadata.getCloseDelimiter())) {
                            this.subState = SubState.LITERAL;
                            this.state = State.AFTER_SUBSTATE;
                            this.input.backup(lastWord.length() - 7);
                            return TplTopTokenId.T_SMARTY;
                        }
                        if (lastWord.startsWith("php" + this.metadata.getCloseDelimiter())) {
                            this.subState = SubState.PHP_CODE;
                            this.state = State.AFTER_SUBSTATE;
                            this.input.backup(lastWord.length() - 3);
                            return TplTopTokenId.T_SMARTY;
                        }
                        this.state = State.IN_SMARTY;
                        this.input.backup(lastWord.length());
                        break;
                    }
                    case 5: {
                        if (cc == '*') {
                            int nextChar = this.input.read();
                            while (this.input.readLength() <= this.getCloseDelimiterLength() && nextChar != -1) {
                                nextChar = this.input.read();
                            }
                            if (nextChar != -1) {
                                if (this.isSmartyCloseDelimiter(this.input.readText())) {
                                    this.input.backup(this.input.readLength() - 1);
                                    this.state = State.AFTER_SUBSTATE;
                                    return TplTopTokenId.T_COMMENT;
                                }
                                this.input.backup(1);
                                return TplTopTokenId.T_COMMENT;
                            }
                            this.input.backup(this.input.readLength() - 1);
                        }
                        return TplTopTokenId.T_COMMENT;
                    }
                    case 9: {
                        if (LexerUtils.isWS(c)) {
                            return TplTopTokenId.T_SMARTY;
                        }
                        if (!this.isSmartyCloseDelimiter(text)) break;
                        this.state = State.CLOSE_DELIMITER;
                        this.input.backup(closeDelimiterLength);
                        break;
                    }
                    case 4: {
                        if (textLength < closeDelimiterLength) break;
                        if (this.subState == SubState.NO_SUB_STATE) {
                            c = this.input.read();
                            this.input.backup(1);
                            if (c == -1) {
                                --this.embeddingLevel;
                                this.state = this.getStateFromEmbeddingLevel(this.embeddingLevel);
                                return TplTopTokenId.T_SMARTY_CLOSE_DELIMITER;
                            }
                            --this.embeddingLevel;
                            this.state = this.getStateFromEmbeddingLevel(this.embeddingLevel);
                            this.lastState = this.state == State.IN_SMARTY ? TplTopTokenId.T_SMARTY : TplTopTokenId.T_HTML;
                            return TplTopTokenId.T_SMARTY_CLOSE_DELIMITER;
                        }
                        switch (this.subState.ordinal()) {
                            case 2: {
                                this.state = State.IN_LITERAL;
                                break;
                            }
                            case 1: {
                                this.state = State.IN_PHP;
                                break;
                            }
                        }
                        this.lastState = TplTopTokenId.T_HTML;
                        --this.embeddingLevel;
                        return TplTopTokenId.T_SMARTY_CLOSE_DELIMITER;
                    }
                    case 8: {
                        if (this.isSmartyOpenDelimiter(text)) {
                            this.state = State.OPEN_DELIMITER;
                            this.input.backup(openDelimiterLength);
                            if (this.input.readLength() > 0) {
                                return TplTopTokenId.T_PHP;
                            }
                        }
                        if (this.input.readLength() <= 1) break;
                        return TplTopTokenId.T_PHP;
                    }
                    case 10: {
                        while (!this.isSmartyOpenDelimiterWithFinalizingChar(text)) {
                            c = this.input.read();
                            if (c == -1 && this.input.readLength() > 0) {
                                return TplTopTokenId.T_HTML;
                            }
                            text = this.input.readText();
                        }
                        this.state = State.OPEN_DELIMITER;
                        this.input.backup(openDelimiterLength + 1);
                        if (this.input.readLength() <= 0) break;
                        return TplTopTokenId.T_HTML;
                    }
                    case 7: {
                        String currentStringDelimiter = this.endingStringDelimiter(text);
                        if (currentStringDelimiter == null || !this.stringDelimiter.equals(currentStringDelimiter) || CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)('\\' + currentStringDelimiter))) break;
                        this.state = State.IN_SMARTY;
                        this.stringDelimiter = null;
                        break;
                    }
                    case 6: {
                        if (this.isSmartyCloseDelimiter(text)) {
                            if (textLength == closeDelimiterLength) {
                                --this.embeddingLevel;
                                this.state = this.getStateFromEmbeddingLevel(this.embeddingLevel);
                                return TplTopTokenId.T_SMARTY_CLOSE_DELIMITER;
                            }
                            this.state = State.CLOSE_DELIMITER;
                            this.input.backup(closeDelimiterLength);
                            if (this.input.readLength() != 0) {
                                return TplTopTokenId.T_SMARTY;
                            }
                        } else if (this.isSmartyOpenDelimiter(text)) {
                            this.state = State.OPEN_DELIMITER;
                            this.input.backup(openDelimiterLength);
                            if (textLength > openDelimiterLength) {
                                return TplTopTokenId.T_SMARTY;
                            }
                        } else {
                            this.stringDelimiter = this.endingStringDelimiter(text);
                            if (this.stringDelimiter != null) {
                                this.state = State.IN_STRING;
                            }
                        }
                        switch (c) {
                            case -1: {
                                return TplTopTokenId.T_SMARTY;
                            }
                        }
                    }
                }
                c = this.input.read();
            }
            return this.getTokenId(this.state);
        }

        private State getStateFromEmbeddingLevel(int embeddingLevel) {
            if (embeddingLevel > 0) {
                return State.IN_SMARTY;
            }
            return State.OUTER;
        }

        private TplTopTokenId getTokenId(State state) {
            switch (state.ordinal()) {
                case 6: {
                    return TplTopTokenId.T_SMARTY;
                }
                case 3: {
                    return TplTopTokenId.T_SMARTY_OPEN_DELIMITER;
                }
                case 4: {
                    return TplTopTokenId.T_SMARTY_CLOSE_DELIMITER;
                }
            }
            return TplTopTokenId.T_HTML;
        }

        Object getState() {
            return new CompoundState(this.state, this.subState, this.embeddingLevel, this.lastState, this.stringDelimiter);
        }

        private String endingStringDelimiter(CharSequence text) {
            if (CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)"\"")) {
                return "\"";
            }
            if (CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)"'")) {
                return "'";
            }
            return null;
        }

        private boolean isSmartyOpenDelimiter(CharSequence text) {
            return CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)this.metadata.getOpenDelimiter());
        }

        private boolean isSmartyOpenDelimiterWithFinalizingChar(CharSequence text) {
            return CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)(this.metadata.getOpenDelimiter() + "/"));
        }

        private boolean isSmartyCloseDelimiter(CharSequence text) {
            return CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)this.metadata.getCloseDelimiter());
        }

        private int getOpenDelimiterLength() {
            return this.metadata.getOpenDelimiter().length();
        }

        private int getCloseDelimiterLength() {
            return this.metadata.getCloseDelimiter().length();
        }

        private SmartyFramework.Version getSmartyVersion() {
            return this.metadata.getSmartyVersion();
        }

        private String readNextWord(int lastChar) {
            int c;
            StringBuilder sb = new StringBuilder();
            sb.append((char)lastChar);
            while (!LexerUtils.isWS(c = this.input.read()) && c != -1) {
                sb.append((char)c);
            }
            this.input.backup(1);
            return sb.toString();
        }
    }
}

