/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.classfile.Method;
import com.sun.tools.classfile.StackMapTable_attribute;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.InstructionDetailWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class StackMapWriter
extends InstructionDetailWriter {
    private Map<Integer, StackMap> map;
    private ClassWriter classWriter;
    private final StackMapTable_attribute.verification_type_info[] empty = new StackMapTable_attribute.verification_type_info[0];

    static StackMapWriter instance(Context context) {
        StackMapWriter instance = context.get(StackMapWriter.class);
        if (instance == null) {
            instance = new StackMapWriter(context);
        }
        return instance;
    }

    protected StackMapWriter(Context context) {
        super(context);
        context.put(StackMapWriter.class, this);
        this.classWriter = ClassWriter.instance(context);
    }

    public void reset(Code_attribute attr) {
        this.setStackMap((StackMapTable_attribute)attr.attributes.get("StackMapTable"));
    }

    void setStackMap(StackMapTable_attribute attr) {
        String[] args;
        if (attr == null) {
            this.map = null;
            return;
        }
        Method m = this.classWriter.getMethod();
        Descriptor d = m.descriptor;
        try {
            ConstantPool cp = this.classWriter.getClassFile().constant_pool;
            String argString = d.getParameterTypes(cp);
            args = argString.substring(1, argString.length() - 1).split("[, ]+");
        }
        catch (ConstantPoolException | Descriptor.InvalidDescriptor e) {
            return;
        }
        boolean isStatic = m.access_flags.is(8);
        StackMapTable_attribute.verification_type_info[] initialLocals = new StackMapTable_attribute.verification_type_info[(isStatic ? 0 : 1) + args.length];
        if (!isStatic) {
            initialLocals[0] = new CustomVerificationTypeInfo("this");
        }
        for (int i = 0; i < args.length; ++i) {
            initialLocals[(isStatic ? 0 : 1) + i] = new CustomVerificationTypeInfo(args[i].replace(".", "/"));
        }
        this.map = new HashMap<Integer, StackMap>();
        StackMapBuilder builder = new StackMapBuilder();
        int pc = -1;
        this.map.put(pc, new StackMap(initialLocals, this.empty));
        for (int i = 0; i < attr.entries.length; ++i) {
            pc = attr.entries[i].accept(builder, pc);
        }
    }

    public void writeInitialDetails() {
        this.writeDetails(-1);
    }

    @Override
    public void writeDetails(Instruction instr) {
        this.writeDetails(instr.getPC());
    }

    private void writeDetails(int pc) {
        if (this.map == null) {
            return;
        }
        StackMap m = this.map.get(pc);
        if (m != null) {
            this.print("StackMap locals: ", m.locals);
            this.print("StackMap stack: ", m.stack);
        }
    }

    void print(String label, StackMapTable_attribute.verification_type_info[] entries) {
        this.print(label);
        for (int i = 0; i < entries.length; ++i) {
            this.print(" ");
            this.print(entries[i]);
        }
        this.println();
    }

    void print(StackMapTable_attribute.verification_type_info entry) {
        if (entry == null) {
            this.print("ERROR");
            return;
        }
        switch (entry.tag) {
            case -1: {
                this.print(((CustomVerificationTypeInfo)entry).text);
                break;
            }
            case 0: {
                this.print("top");
                break;
            }
            case 1: {
                this.print("int");
                break;
            }
            case 2: {
                this.print("float");
                break;
            }
            case 4: {
                this.print("long");
                break;
            }
            case 3: {
                this.print("double");
                break;
            }
            case 5: {
                this.print("null");
                break;
            }
            case 6: {
                this.print("uninit_this");
                break;
            }
            case 7: {
                try {
                    ConstantPool cp = this.classWriter.getClassFile().constant_pool;
                    ConstantPool.CONSTANT_Class_info class_info = cp.getClassInfo(((StackMapTable_attribute.Object_variable_info)entry).cpool_index);
                    this.print(cp.getUTF8Value(class_info.name_index));
                }
                catch (ConstantPoolException e) {
                    this.print("??");
                }
                break;
            }
            case 8: {
                this.print(((StackMapTable_attribute.Uninitialized_variable_info)entry).offset);
            }
        }
    }

    static class CustomVerificationTypeInfo
    extends StackMapTable_attribute.verification_type_info {
        private String text;

        public CustomVerificationTypeInfo(String text) {
            super(-1);
            this.text = text;
        }
    }

    class StackMapBuilder
    implements StackMapTable_attribute.stack_map_frame.Visitor<Integer, Integer> {
        StackMapBuilder() {
        }

        @Override
        public Integer visit_same_frame(StackMapTable_attribute.same_frame frame, Integer pc) {
            int new_pc = pc + frame.getOffsetDelta() + 1;
            StackMap m = (StackMap)StackMapWriter.this.map.get(pc);
            assert (m != null);
            StackMapWriter.this.map.put(new_pc, m);
            return new_pc;
        }

        @Override
        public Integer visit_same_locals_1_stack_item_frame(StackMapTable_attribute.same_locals_1_stack_item_frame frame, Integer pc) {
            int new_pc = pc + frame.getOffsetDelta() + 1;
            StackMap prev = (StackMap)StackMapWriter.this.map.get(pc);
            assert (prev != null);
            StackMap m = new StackMap(prev.locals, frame.stack);
            StackMapWriter.this.map.put(new_pc, m);
            return new_pc;
        }

        @Override
        public Integer visit_same_locals_1_stack_item_frame_extended(StackMapTable_attribute.same_locals_1_stack_item_frame_extended frame, Integer pc) {
            int new_pc = pc + frame.getOffsetDelta() + 1;
            StackMap prev = (StackMap)StackMapWriter.this.map.get(pc);
            assert (prev != null);
            StackMap m = new StackMap(prev.locals, frame.stack);
            StackMapWriter.this.map.put(new_pc, m);
            return new_pc;
        }

        @Override
        public Integer visit_chop_frame(StackMapTable_attribute.chop_frame frame, Integer pc) {
            int new_pc = pc + frame.getOffsetDelta() + 1;
            StackMap prev = (StackMap)StackMapWriter.this.map.get(pc);
            assert (prev != null);
            int k = 251 - frame.frame_type;
            StackMapTable_attribute.verification_type_info[] new_locals = Arrays.copyOf(prev.locals, prev.locals.length - k);
            StackMap m = new StackMap(new_locals, StackMapWriter.this.empty);
            StackMapWriter.this.map.put(new_pc, m);
            return new_pc;
        }

        @Override
        public Integer visit_same_frame_extended(StackMapTable_attribute.same_frame_extended frame, Integer pc) {
            int new_pc = pc + frame.getOffsetDelta();
            StackMap m = (StackMap)StackMapWriter.this.map.get(pc);
            assert (m != null);
            StackMapWriter.this.map.put(new_pc, m);
            return new_pc;
        }

        @Override
        public Integer visit_append_frame(StackMapTable_attribute.append_frame frame, Integer pc) {
            int new_pc = pc + frame.getOffsetDelta() + 1;
            StackMap prev = (StackMap)StackMapWriter.this.map.get(pc);
            assert (prev != null);
            StackMapTable_attribute.verification_type_info[] new_locals = new StackMapTable_attribute.verification_type_info[prev.locals.length + frame.locals.length];
            System.arraycopy(prev.locals, 0, new_locals, 0, prev.locals.length);
            System.arraycopy(frame.locals, 0, new_locals, prev.locals.length, frame.locals.length);
            StackMap m = new StackMap(new_locals, StackMapWriter.this.empty);
            StackMapWriter.this.map.put(new_pc, m);
            return new_pc;
        }

        @Override
        public Integer visit_full_frame(StackMapTable_attribute.full_frame frame, Integer pc) {
            int new_pc = pc + frame.getOffsetDelta() + 1;
            StackMap m = new StackMap(frame.locals, frame.stack);
            StackMapWriter.this.map.put(new_pc, m);
            return new_pc;
        }
    }

    static class StackMap {
        private final StackMapTable_attribute.verification_type_info[] locals;
        private final StackMapTable_attribute.verification_type_info[] stack;

        StackMap(StackMapTable_attribute.verification_type_info[] locals, StackMapTable_attribute.verification_type_info[] stack) {
            this.locals = locals;
            this.stack = stack;
        }
    }
}

