/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.clone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.ui.clone.Bundle;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class FetchBranchesStep
extends AbstractWizardPanel
implements ChangeListener {
    private final ItemSelector<Branch> branches = new ItemSelector(NbBundle.getMessage(FetchBranchesStep.class, (String)"LBL_RemoteBranchesTitle"));

    public FetchBranchesStep() {
        this.branches.addChangeListener(this);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                FetchBranchesStep.this.validateBeforeNext();
            }
        });
        this.getJComponent().setName(NbBundle.getMessage(FetchBranchesStep.class, (String)"LBL_FetchBranches.remoteBranches"));
    }

    @Override
    protected final boolean validateBeforeNext() {
        boolean valid = true;
        this.setValid(true, null);
        if (this.branches.isEmpty()) {
            this.setValid(true, new AbstractWizardPanel.Message(Bundle.MSG_FetchRefsPanel_warningNoBranchInRepository(), true));
        } else if (this.branches.getSelectedBranches().isEmpty()) {
            valid = false;
            this.setValid(false, new AbstractWizardPanel.Message(Bundle.MSG_FetchRefsPanel_errorNoBranchSelected(), true));
        } else {
            this.setValid(true, null);
        }
        return valid;
    }

    @Override
    protected final JComponent getJComponent() {
        return this.branches.getPanel();
    }

    public void fillRemoteBranches(Collection<GitBranch> remoteBranches) {
        ArrayList<Branch> l = new ArrayList<Branch>(remoteBranches.size());
        boolean preselected = remoteBranches.size() == 1;
        for (GitBranch gitBranch : remoteBranches) {
            l.add(new Branch(gitBranch, preselected || "master".equals(gitBranch.getName())));
        }
        this.branches.setBranches(l);
        this.validateBeforeNext();
    }

    public List<GitBranch> getSelectedBranches() {
        List<Branch> selected = this.branches.getSelectedBranches();
        ArrayList<GitBranch> l = new ArrayList<GitBranch>(selected.size());
        for (Branch b : selected) {
            l.add(b.branch);
        }
        return l;
    }

    public List<String> getSelectedBranchNames() {
        List<String> selectedBranchNames;
        if (this.branches.isEmpty()) {
            selectedBranchNames = Collections.singletonList("*");
        } else {
            List<Branch> selectedBranches = this.branches.getSelectedBranches();
            selectedBranchNames = new ArrayList<String>(selectedBranches.size());
            for (Branch b : selectedBranches) {
                selectedBranchNames.add(b.branch.getName());
            }
        }
        return selectedBranchNames;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.validateBeforeNext();
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(FetchBranchesStep.class);
    }

    private static class Branch
    extends ItemSelector.Item {
        private final GitBranch branch;

        public Branch(GitBranch branch, boolean selected) {
            super(selected, false);
            this.branch = branch;
        }

        @Override
        public String getText() {
            return this.branch.getName() + (this.branch.isActive() ? "*" : "");
        }

        @Override
        public String getTooltipText() {
            return this.getText();
        }

        public String getName() {
            return this.branch.getName();
        }

        public String getId() {
            return this.branch.getId();
        }

        public boolean isRemote() {
            return this.branch.isRemote();
        }

        public boolean isActive() {
            return this.branch.isActive();
        }

        @Override
        public int compareTo(ItemSelector.Item t) {
            if (t == null) {
                return 1;
            }
            if (t instanceof Branch) {
                return this.getName().compareTo(((Branch)t).getName());
            }
            return 0;
        }
    }
}

