/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartDecorator;
import org.netbeans.lib.profiler.charts.axis.AxisMark;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.swing.Utils;

public class AxisComponent
extends JComponent {
    public static final int NO_MESH = 0;
    public static final int MESH_BACKGROUND = 1;
    public static final int MESH_FOREGROUND = 2;
    private final int location;
    private final boolean horizontal;
    private final ChartComponent chart;
    private final AxisMarksComputer marksComputer;
    private final AxisMarksPainter marksPainter;
    private int maxExtent = 0;
    private final Paint meshPaint = Utils.checkedColor(new Color(80, 80, 80, 50));
    private final Stroke meshStroke = new BasicStroke(1.0f);

    public AxisComponent(ChartComponent chart, AxisMarksComputer marksComputer, AxisMarksPainter marksPainter, int location, int mesh) {
        this.location = location;
        this.horizontal = location == 1 || location == 5;
        this.chart = chart;
        this.marksComputer = marksComputer;
        this.marksPainter = marksPainter;
        this.setOpaque(false);
        chart.addConfigurationListener(new ChartListener());
        if (mesh == 1) {
            chart.addPreDecorator(this.createMeshPainter());
        } else if (mesh == 2) {
            chart.addPostDecorator(this.createMeshPainter());
        }
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            clip = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        final Dimension dim = this.getPreferredSize();
        final int axisBasisExtent = this.getAxisBasisExtent();
        Rectangle chartBounds = SwingUtilities.convertRectangle(this.chart.getParent(), this.chart.getBounds(), this);
        if (this.horizontal) {
            chartBounds.y = clip.y;
            chartBounds.height = clip.height;
        } else {
            chartBounds.x = clip.x;
            chartBounds.width = clip.width;
        }
        if (this.marksComputer instanceof AxisMarksComputer.Abstract) {
            ((AxisMarksComputer.Abstract)this.marksComputer).refreshConfiguration();
        }
        this.paintAxis(g, clip, chartBounds);
        if (this.horizontal) {
            if (dim.height < this.maxExtent + axisBasisExtent) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ AxisComponent this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        dim.height = this.this$0.maxExtent + axisBasisExtent;
                        this.this$0.setPreferredSize(dim);
                        this.this$0.invalidate();
                        ((JComponent)this.this$0.getParent()).revalidate();
                        this.this$0.getParent().repaint();
                    }
                });
            }
        } else if (dim.width < this.maxExtent + axisBasisExtent) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ AxisComponent this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    dim.width = this.this$0.maxExtent + axisBasisExtent;
                    this.this$0.setPreferredSize(dim);
                    this.this$0.invalidate();
                    ((JComponent)this.this$0.getParent()).revalidate();
                    this.this$0.getParent().repaint();
                }
            });
        }
    }

    protected void paintAxisMesh(Graphics2D g, Rectangle clip, Rectangle chartMask) {
        if (this.horizontal) {
            this.paintHorizontalMesh(g, clip, chartMask);
        } else {
            this.paintVerticalMesh(g, clip, chartMask);
        }
    }

    protected void paintHorizontalMesh(Graphics2D g, Rectangle clip, Rectangle chartMask) {
        Iterator<AxisMark> marks = this.marksComputer.marksIterator(chartMask.x, chartMask.x + chartMask.width);
        while (marks.hasNext()) {
            AxisMark mark = marks.next();
            int x = mark.getPosition();
            g.setPaint(this.meshPaint);
            g.setStroke(this.meshStroke);
            g.drawLine(x, chartMask.y, x, chartMask.y + chartMask.height);
        }
    }

    protected void paintVerticalMesh(Graphics2D g, Rectangle clip, Rectangle chartMask) {
        Iterator<AxisMark> marks = this.marksComputer.marksIterator(chartMask.y, chartMask.y + chartMask.height);
        while (marks.hasNext()) {
            AxisMark mark = marks.next();
            int y = mark.getPosition();
            g.setPaint(this.meshPaint);
            g.setStroke(this.meshStroke);
            g.drawLine(chartMask.x, y, chartMask.x + chartMask.width, y);
        }
    }

    protected void paintAxis(Graphics g, Rectangle clip, Rectangle chartMask) {
        if (this.horizontal) {
            this.paintHorizontalAxis(g, clip, chartMask);
        } else {
            this.paintVerticalAxis(g, clip, chartMask);
        }
    }

    protected int getAxisBasisExtent() {
        return 5;
    }

    protected void paintHorizontalBasis(Graphics g, Rectangle clip, Rectangle chartMask) {
        Rectangle dirty = clip.intersection(chartMask);
        g.setColor(this.getForeground());
        if (this.location == 1) {
            g.drawLine(dirty.x - 1, this.getHeight() - 1, dirty.x + dirty.width, this.getHeight() - 1);
        } else {
            g.drawLine(dirty.x, 0, dirty.x + dirty.width, 0);
        }
    }

    protected void paintHorizontalTick(Graphics g, AxisMark mark, int x, Rectangle clip, Rectangle chartMask) {
        g.setColor(this.getForeground());
        if (this.location == 1) {
            g.drawLine(x, this.getHeight() - 2 - this.getAxisBasisExtent(), x, this.getHeight() - 2);
        } else {
            g.drawLine(x, 1, x, 1 + this.getAxisBasisExtent());
        }
    }

    protected void paintHorizontalAxis(Graphics g, Rectangle clip, Rectangle chartMask) {
        int rZeroOffset;
        this.paintHorizontalBasis(g, clip, chartMask);
        int viewStart = SwingUtilities.convertPoint((Component)this, (int)chartMask.x, (int)0, (Component)this.chart).x - 1;
        int viewEnd = viewStart + chartMask.width + 2;
        Iterator<AxisMark> marks = this.marksComputer.marksIterator(viewStart, viewEnd);
        int lZeroOffset = this.chart.isRightBased() ? 0 : 1;
        int n = rZeroOffset = this.chart.isRightBased() ? 1 : 0;
        while (marks.hasNext()) {
            AxisMark mark = marks.next();
            int x = SwingUtilities.convertPoint((Component)this.chart, (int)mark.getPosition(), (int)0, (Component)this).x;
            if (x < chartMask.x - lZeroOffset || x >= chartMask.x + chartMask.width + rZeroOffset) continue;
            Component painter = this.marksPainter.getPainter(mark);
            painter.setSize(painter.getPreferredSize());
            int markHeight = painter.getHeight();
            int markOffsetX = painter.getWidth() / 2;
            if (x + markOffsetX < clip.x || x - markOffsetX >= clip.x + clip.width) continue;
            this.maxExtent = Math.max(this.maxExtent, markHeight);
            this.paintHorizontalTick(g, mark, x, clip, chartMask);
            g.setColor(this.getForeground());
            if (this.location == 1) {
                g.translate(x - markOffsetX, 0);
                painter.paint(g);
                g.translate(-x + markOffsetX, 0);
                continue;
            }
            g.translate(x - markOffsetX, this.getAxisBasisExtent());
            painter.paint(g);
            g.translate(-x + markOffsetX, -this.getAxisBasisExtent());
        }
    }

    protected void paintVerticalBasis(Graphics g, Rectangle clip, Rectangle chartMask) {
        g.setColor(this.getForeground());
        if (this.location == 7) {
            g.drawLine(this.getWidth() - 1, chartMask.y - 1, this.getWidth() - 1, chartMask.y + chartMask.height);
        } else {
            g.drawLine(0, chartMask.y, 0, chartMask.y + chartMask.height);
        }
    }

    protected void paintVerticalTick(Graphics g, AxisMark mark, int y, Rectangle clip, Rectangle chartMask) {
        g.setColor(this.getForeground());
        if (this.location == 7) {
            g.drawLine(this.getWidth() - 2 - this.getAxisBasisExtent(), y, this.getWidth() - 2, y);
        } else {
            g.drawLine(1, y, 1 + this.getAxisBasisExtent(), y);
        }
    }

    protected void paintVerticalAxis(Graphics g, Rectangle clip, Rectangle chartMask) {
        this.paintVerticalBasis(g, clip, chartMask);
        int viewStart = SwingUtilities.convertPoint((Component)this, (int)0, (int)chartMask.y, (Component)this.chart).y;
        int viewEnd = viewStart + chartMask.height;
        Iterator<AxisMark> marks = this.marksComputer.marksIterator(viewStart, viewEnd);
        int tZeroOffset = this.chart.isBottomBased() ? 0 : 1;
        int bZeroOffset = this.chart.isBottomBased() ? 1 : 0;
        int currentExtent = this.maxExtent;
        while (marks.hasNext()) {
            AxisMark mark = marks.next();
            int y = SwingUtilities.convertPoint((Component)this.chart, (int)0, (int)mark.getPosition(), (Component)this).y;
            if (y < chartMask.y - tZeroOffset || y >= chartMask.y + chartMask.height + bZeroOffset) continue;
            Component painter = this.marksPainter.getPainter(mark);
            painter.setSize(painter.getPreferredSize());
            int markWidth = painter.getWidth();
            int markOffsetY = painter.getHeight() / 2;
            if (y + markOffsetY < clip.y || y - markOffsetY >= clip.y + clip.height) continue;
            this.maxExtent = Math.max(this.maxExtent, markWidth);
            this.paintVerticalTick(g, mark, y, clip, chartMask);
            g.setColor(this.getForeground());
            if (this.location == 7) {
                g.translate(currentExtent - markWidth, y - markOffsetY);
                painter.paint(g);
                g.translate(-currentExtent + markWidth, -y + markOffsetY);
                continue;
            }
            g.translate(this.getAxisBasisExtent(), y - markOffsetY);
            painter.paint(g);
            g.translate(-this.getAxisBasisExtent(), -y + markOffsetY);
        }
    }

    private ChartDecorator createMeshPainter() {
        return new ChartDecorator(){

            @Override
            public void paint(Graphics2D g, Rectangle dirtyArea, ChartContext context) {
                AxisComponent.this.paintAxisMesh(g, dirtyArea, dirtyArea);
            }
        };
    }

    private class ChartListener
    extends ChartConfigurationListener.Adapter {
        private boolean updateAxis;

        private ChartListener() {
        }

        @Override
        public void contentsWillBeUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY) {
            if (AxisComponent.this.marksComputer instanceof AxisMarksComputer.Abstract) {
                AxisMarksComputer.Abstract computer = (AxisMarksComputer.Abstract)AxisComponent.this.marksComputer;
                this.updateAxis = computer.refreshConfiguration();
            } else {
                this.updateAxis = true;
            }
        }

        @Override
        public void contentsUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY, int shiftX, int shiftY) {
            if (!this.updateAxis) {
                if (AxisComponent.this.horizontal) {
                    this.updateAxis = shiftX != 0 || lastOffsetX != offsetX || lastScaleX != scaleX;
                } else {
                    boolean bl = this.updateAxis = shiftY != 0 || lastOffsetY != offsetY || lastScaleY != scaleY;
                }
            }
            if (this.updateAxis) {
                AxisComponent.this.repaint();
            }
        }
    }
}

