/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.CreateOAuth2ClientCredentialDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateOAuthClientCredentialRequest
extends BmcRequest<CreateOAuth2ClientCredentialDetails> {
    private String userId;
    private CreateOAuth2ClientCredentialDetails createOAuth2ClientCredentialDetails;
    private String opcRetryToken;

    public String getUserId() {
        return this.userId;
    }

    public CreateOAuth2ClientCredentialDetails getCreateOAuth2ClientCredentialDetails() {
        return this.createOAuth2ClientCredentialDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateOAuth2ClientCredentialDetails getBody$() {
        return this.createOAuth2ClientCredentialDetails;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).createOAuth2ClientCredentialDetails(this.createOAuth2ClientCredentialDetails).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",createOAuth2ClientCredentialDetails=").append(String.valueOf((Object)this.createOAuth2ClientCredentialDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOAuthClientCredentialRequest)) {
            return false;
        }
        CreateOAuthClientCredentialRequest other = (CreateOAuthClientCredentialRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals((Object)this.createOAuth2ClientCredentialDetails, (Object)other.createOAuth2ClientCredentialDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.createOAuth2ClientCredentialDetails == null ? 43 : this.createOAuth2ClientCredentialDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateOAuthClientCredentialRequest, CreateOAuth2ClientCredentialDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private CreateOAuth2ClientCredentialDetails createOAuth2ClientCredentialDetails = null;
        private String opcRetryToken = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder createOAuth2ClientCredentialDetails(CreateOAuth2ClientCredentialDetails createOAuth2ClientCredentialDetails) {
            this.createOAuth2ClientCredentialDetails = createOAuth2ClientCredentialDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateOAuthClientCredentialRequest o) {
            this.userId(o.getUserId());
            this.createOAuth2ClientCredentialDetails(o.getCreateOAuth2ClientCredentialDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateOAuthClientCredentialRequest build() {
            CreateOAuthClientCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateOAuth2ClientCredentialDetails body) {
            this.createOAuth2ClientCredentialDetails(body);
            return this;
        }

        public CreateOAuthClientCredentialRequest buildWithoutInvocationCallback() {
            CreateOAuthClientCredentialRequest request = new CreateOAuthClientCredentialRequest();
            request.userId = this.userId;
            request.createOAuth2ClientCredentialDetails = this.createOAuth2ClientCredentialDetails;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

