/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.BaseSectionNodeInnerPanel;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.tables.InnerTableModel;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;

public class InnerTablePanel
extends BaseSectionNodeInnerPanel {
    private final TablePanel tablePanel;
    private JTable table;

    public InnerTablePanel(SectionNodeView sectionNodeView, InnerTableModel model, ASDDVersion version) {
        super(sectionNodeView, version);
        this.tablePanel = new TablePanel(model);
        this.initUserComponents(model);
        this.scheduleRefreshView();
    }

    protected void initUserComponents(InnerTableModel model) {
        this.setAlignmentX(0.0f);
        this.setOpaque(false);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int type = e.getType();
                if (type == 1 || type == -1) {
                    InnerTablePanel.this.scheduleRefreshView();
                }
            }
        });
        this.table = this.tablePanel.getTable();
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    InnerTablePanel.this.editCell(InnerTablePanel.this.table.getSelectedRow(), InnerTablePanel.this.table.getSelectedColumn());
                }
            }
        });
        InputMap inputMap = this.table.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "selectNextColumnCell");
        inputMap.put(KeyStroke.getKeyStroke("shift ENTER"), "selectPreviousColumnCell");
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.tablePanel), "West");
        this.setColumnWidths();
        this.setButtonListeners();
        this.setColumnEditors(model);
    }

    protected void setButtonListeners() {
        this.getAddButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InnerTablePanel.this.addRowActionPerformed(e);
            }
        });
        this.getEditButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InnerTablePanel.this.editRowActionPerformed(e);
            }
        });
        this.getRemoveButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InnerTablePanel.this.removeRowActionPerformed(e);
            }
        });
    }

    protected void addRowActionPerformed(ActionEvent e) {
        this.stopCellEditing(this.table);
        InnerTableModel model = (InnerTableModel)this.table.getModel();
        this.selectCell(model.addRow(), 0);
        model.modelUpdatedFromUI();
        Utils.scrollToVisible((JComponent)((Object)this.tablePanel));
    }

    protected void editRowActionPerformed(ActionEvent e) {
        this.editCell(this.table.getSelectedRow(), this.table.getSelectedColumn());
    }

    protected void removeRowActionPerformed(ActionEvent e) {
        int column;
        int row = this.table.getSelectedRow();
        TableCellEditor cellEditor = this.table.getCellEditor(row, column = this.table.getSelectedColumn());
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
        InnerTableModel model = (InnerTableModel)this.table.getModel();
        int rowCount = model.getRowCount() - 1;
        model.removeRow(row);
        model.modelUpdatedFromUI();
        if (row >= rowCount) {
            row = rowCount - 1;
        }
        if (row >= 0) {
            final int n = row;
            Utils.runInAwtDispatchThread((Runnable)new Runnable(){
                final /* synthetic */ InnerTablePanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.selectCell(n, column);
                }
            });
        }
    }

    private void stopCellEditing(JTable table) {
        table.editCellAt(-1, -1);
    }

    private void setColumnEditors(InnerTableModel model) {
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableCellEditor cellEditor = model.getCellEditor(i);
            if (cellEditor == null) continue;
            columnModel.getColumn(i).setCellEditor(cellEditor);
        }
    }

    public JTable getTable() {
        return this.table;
    }

    public JButton getAddButton() {
        return this.tablePanel.getAddButton();
    }

    public JButton getEditButton() {
        return this.tablePanel.getEditButton();
    }

    public JButton getRemoveButton() {
        return this.tablePanel.getRemoveButton();
    }

    public void setColumnWidths() {
        JTable theTable = this.tablePanel.getTable();
        InnerTableModel tableModel = (InnerTableModel)theTable.getModel();
        TableColumnModel columnModel = theTable.getColumnModel();
        int n = columnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int width = tableModel.getDefaultColumnWidth(i);
            TableColumn column = columnModel.getColumn(i);
            column.setPreferredWidth(width);
            column.setWidth(width);
        }
    }

    protected void editCell(final int row, final int column) {
        if (this.table.isCellEditable(row, column)) {
            this.selectCell(row, column);
            Utils.runInAwtDispatchThread((Runnable)new Runnable(){
                final /* synthetic */ InnerTablePanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    JTable table = this.this$0.getTable();
                    table.editCellAt(row, column);
                    Component editorComponent = table.getEditorComponent();
                    editorComponent.requestFocus();
                }
            });
        }
    }

    private void selectCell(final int row, final int column) {
        Utils.runInAwtDispatchThread((Runnable)new Runnable(){
            final /* synthetic */ InnerTablePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                JTable table = this.this$0.getTable();
                table.getSelectionModel().setLeadSelectionIndex(row);
                table.getColumnModel().getSelectionModel().setLeadSelectionIndex(column);
                table.requestFocus();
            }
        });
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        ((InnerTableModel)this.getTable().getModel()).tableChanged();
        this.scheduleRefreshView();
    }

    private class TablePanel
    extends DefaultTablePanel {
        public TablePanel(AbstractTableModel model) {
            super(model);
            final JTable table = this.getTable();
            table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
                final /* synthetic */ TablePanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selectedRowCount = table.getSelectedRowCount();
                    this.this$1.removeButton.setEnabled(selectedRowCount > 0);
                    this.this$1.editButton.setEnabled(selectedRowCount == 1);
                }
            });
        }

        public JButton getAddButton() {
            return this.addButton;
        }

        public JButton getEditButton() {
            return this.editButton;
        }

        public JButton getRemoveButton() {
            return this.removeButton;
        }
    }
}

