/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.janitor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.janitor.Bundle;
import org.netbeans.modules.janitor.JanitorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.modules.Places;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class Janitor {
    private static final Logger LOG;
    private static final int UNUSED_DAYS = 30;
    public static final String PROP_JANITOR_ENABLED = "janitorEnabled";
    public static final String PROP_UNUSED_DAYS = "UnusedDays";
    public static final String PROP_AUTO_REMOVE_ABANDONED_CACHE = "autoRemoveAbandonedCache";
    private static final String LOGFILE_NAME = "var/log/messages.log";
    private static final String ALL_CHECKSUM_NAME = "lastModified/all-checksum.txt";
    private static final String LAST_VERSION_NAME = ".lastUsedVersion";
    private static final String NB_VERSION;
    private static final String CLEAN_ICON = "org/netbeans/modules/janitor/resources/clean.gif";
    static final RequestProcessor JANITOR_RP;
    static final Map<ActionListener, Notification> CLEANUP_TASKS;

    static void scanForJunk() {
        CLEANUP_TASKS.values().forEach(nf -> nf.clear());
        CLEANUP_TASKS.clear();
        ImageIcon clean = ImageUtilities.loadImageIcon((String)CLEAN_ICON, (boolean)false);
        List<CleanupPair> candidates = Janitor.getCandidates();
        Instant now = Instant.now();
        int maxUnused = Janitor.getUnusedDays();
        for (CleanupPair candidate : candidates) {
            Notification nf2;
            ActionListener cleanupListener;
            int age = candidate.age(now);
            int toFree = candidate.size();
            String name = candidate.getName();
            if (candidate.userdir != null) {
                if (age <= maxUnused) continue;
                cleanupListener = Janitor.cleanupAction(candidate, Bundle.TXT_CONFIRM_CLEANUP(name));
                nf2 = NotificationDisplayer.getDefault().notify(Bundle.TIT_ABANDONED_USERDIR(name, age, toFree), (Icon)clean, Bundle.DESC_ABANDONED_USERDIR(name, age, toFree), cleanupListener);
                CLEANUP_TASKS.put(cleanupListener, nf2);
                continue;
            }
            if (Janitor.isAutoRemoveAbandonedCache()) {
                LOG.log(Level.INFO, "Janitor autoremove abandoned cache: " + candidate.cachedir.dir);
                JANITOR_RP.post(() -> Janitor.cleanup(candidate));
                continue;
            }
            cleanupListener = Janitor.cleanupAction(candidate, Bundle.TXT_CONFIRM_CACHE_CLEANUP(name));
            nf2 = NotificationDisplayer.getDefault().notify(Bundle.TIT_ABANDONED_CACHEDIR(name, toFree), (Icon)clean, Bundle.DESC_ABANDONED_CACHEDIR(name, toFree), cleanupListener);
            CLEANUP_TASKS.put(cleanupListener, nf2);
        }
    }

    static ActionListener cleanupAction(final CleanupPair cp, final String label) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JanitorPanel panel = new JanitorPanel(label);
                DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.TIT_CONFIRM_CLEANUP(), true, 0, DialogDescriptor.YES_OPTION, null);
                if (DialogDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor)) {
                    JANITOR_RP.post(() -> Janitor.cleanup(cp));
                }
                Janitor.setEnabled(panel.isEnabledOnStartup());
                Notification nf = CLEANUP_TASKS.get(this);
                if (nf != null) {
                    nf.clear();
                }
            }
        };
    }

    static void cleanup(CleanupPair cp) {
        try (ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.LBL_CLEANUP(cp.getName()));){
            handle.start();
            cp.delete();
        }
    }

    public static final Preferences getPreferences() {
        return NbPreferences.forModule(Janitor.class);
    }

    static void markUserCacheDirs() {
        Janitor.writeVersion(Places.getCacheDirectory());
        Janitor.writeVersion(Places.getUserDirectory());
    }

    static void runNow() {
        JANITOR_RP.post(Janitor::scanForJunk);
    }

    static void writeVersion(File baseDir) {
        File lastUsedVersion = new File(baseDir, LAST_VERSION_NAME);
        if (NB_VERSION != null) {
            try (FileWriter fw = new FileWriter(lastUsedVersion);){
                fw.write(NB_VERSION);
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "Could not write version info.", ex);
            }
        }
    }

    static List<CleanupPair> getCandidates() {
        File cacheDir;
        HashSet<String> names = new HashSet<String>();
        File userDir = Places.getUserDirectory();
        if (userDir != null) {
            File userParent = userDir.getParentFile();
            for (File f : userParent.listFiles()) {
                if (!f.isDirectory() || f.equals(userDir)) continue;
                names.add(f.getName());
            }
        }
        if ((cacheDir = Places.getCacheDirectory()) != null) {
            File cacheParent = cacheDir.getParentFile();
            for (File f : cacheParent.listFiles()) {
                if (!f.isDirectory() || f.equals(cacheDir)) continue;
                names.add(f.getName());
            }
        }
        LinkedList<CleanupPair> ret = new LinkedList<CleanupPair>();
        for (String name : names) {
            CleanupDir user = CleanupDir.get(CleanupDir.Kind.USERDIR, name);
            CleanupDir cache = CleanupDir.get(CleanupDir.Kind.CACHEDIR, name);
            if (user == null && cache == null) continue;
            ret.add(new CleanupPair(user, cache));
        }
        return ret;
    }

    static void setEnabled(boolean b) {
        Janitor.getPreferences().putBoolean(PROP_JANITOR_ENABLED, b);
    }

    static boolean isEnabled() {
        return Janitor.getPreferences().getBoolean(PROP_JANITOR_ENABLED, true);
    }

    static void setUnusedDays(int days) {
        Janitor.getPreferences().putInt(PROP_UNUSED_DAYS, days);
    }

    static int getUnusedDays() {
        return Janitor.getPreferences().getInt(PROP_UNUSED_DAYS, 30);
    }

    static boolean isAutoRemoveAbandonedCache() {
        return Janitor.getPreferences().getBoolean(PROP_AUTO_REMOVE_ABANDONED_CACHE, true);
    }

    static void setAutoRemoveAbandonedCache(boolean b) {
        Janitor.getPreferences().putBoolean(PROP_AUTO_REMOVE_ABANDONED_CACHE, b);
    }

    static {
        int dash;
        LOG = Logger.getLogger(Janitor.class.getName());
        JANITOR_RP = new RequestProcessor("janitor", 1);
        CLEANUP_TASKS = new WeakHashMap<ActionListener, Notification>();
        String version = System.getProperty("netbeans.buildnumber");
        if (version != null && (dash = version.lastIndexOf(45)) + 41 == version.length()) {
            version = version.substring(0, dash);
        }
        NB_VERSION = version;
    }

    private static class CleanupPair {
        final CleanupDir userdir;
        final CleanupDir cachedir;

        public CleanupPair(CleanupDir userdir, CleanupDir cachedir) {
            this.userdir = userdir;
            this.cachedir = cachedir;
            if (userdir == null && cachedir == null) {
                throw new IllegalArgumentException("Both user and cache dirs cannot be null!");
            }
        }

        public String getName() {
            return this.userdir != null ? this.userdir.getName() : this.cachedir.getName();
        }

        public int age(Instant now) {
            return this.userdir != null ? this.userdir.age(now) : this.cachedir.age(now);
        }

        public int size() {
            int sum = 0;
            sum = (int)((long)sum + (this.userdir != null ? this.userdir.size() : 0L));
            sum = (int)((long)sum + (this.cachedir != null ? this.cachedir.size() : 0L));
            return sum / 1000000 + 1;
        }

        public void delete() {
            if (this.userdir != null) {
                this.userdir.delete();
            }
            if (this.cachedir != null) {
                this.cachedir.delete();
            }
        }
    }

    private static class CleanupDir {
        private final Path dir;
        private final Kind kind;

        private CleanupDir(Path dir, Kind kind) {
            this.dir = dir;
            this.kind = kind;
        }

        static CleanupDir get(Kind kind, String version) {
            Path dir = kind == Kind.USERDIR ? Places.getUserDirectory().toPath() : Places.getCacheDirectory().toPath();
            Path f = dir.getParent().resolve(version);
            Path test = f.resolve(kind == Kind.USERDIR ? Janitor.LOGFILE_NAME : Janitor.ALL_CHECKSUM_NAME);
            return !f.equals(dir) && Files.isDirectory(f, new LinkOption[0]) && Files.isRegularFile(test, new LinkOption[0]) ? new CleanupDir(f, kind) : null;
        }

        public long size() {
            if (this.dir == null) {
                return 0L;
            }
            final AtomicLong size = new AtomicLong(0L);
            try {
                Files.walkFileTree(this.dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
                    final /* synthetic */ CleanupDir this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        size.addAndGet(attrs.size());
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOG.log(Level.FINE, "Something went wrong calculating the size of " + this.dir, e);
            }
            return size.get();
        }

        public String getName() {
            String name;
            block23: {
                name = this.dir.getFileName().toString();
                Path f = this.dir.resolve(Janitor.LAST_VERSION_NAME);
                if (Files.isRegularFile(f, new LinkOption[0])) {
                    try {
                        if (Files.size(f) < 100L) {
                            try (BufferedReader br = Files.newBufferedReader(f);){
                                name = br.readLine();
                                break block23;
                            }
                        }
                        LOG.log(Level.WARNING, "Skipped version file " + f + " as it is suspiciously large.");
                    }
                    catch (IOException iOException) {}
                } else {
                    LOG.log(Level.INFO, f.toString() + " is missing fallback to dirname: " + name);
                    switch (name) {
                        case "80": {
                            return "18";
                        }
                        case "76": {
                            return "17";
                        }
                        case "74": {
                            return "16";
                        }
                        case "69": {
                            return "15";
                        }
                    }
                }
            }
            return name;
        }

        public int age(Instant now) {
            Path f;
            int ret = -1;
            switch (this.kind.ordinal()) {
                case 1: {
                    f = this.dir.resolve(Janitor.ALL_CHECKSUM_NAME);
                    break;
                }
                default: {
                    f = this.dir.resolve(Janitor.LOGFILE_NAME);
                }
            }
            if (Files.isRegularFile(f, new LinkOption[0])) {
                try {
                    Instant lastModified = Files.getLastModifiedTime(f, new LinkOption[0]).toInstant();
                    ret = (int)Duration.between(lastModified, now).toDays();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return ret;
        }

        public void delete() {
            try {
                Files.walkFileTree(this.dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Janitor couldn't remove " + this.dir.toString(), ex);
            }
        }

        static enum Kind {
            USERDIR,
            CACHEDIR;

        }
    }

    public static final class PlatformOpenHook
    implements Runnable {
        @Override
        public void run() {
            JANITOR_RP.post(Janitor::markUserCacheDirs, 5000);
            if (Janitor.isEnabled()) {
                JANITOR_RP.post(Janitor::scanForJunk, 60000);
            }
        }
    }
}

