/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.Blockstorage;
import com.oracle.bmc.core.BlockstoragePaginators;
import com.oracle.bmc.core.BlockstorageWaiters;
import com.oracle.bmc.core.model.BlockVolumeReplica;
import com.oracle.bmc.core.model.BootVolume;
import com.oracle.bmc.core.model.BootVolumeBackup;
import com.oracle.bmc.core.model.BootVolumeKmsKey;
import com.oracle.bmc.core.model.BootVolumeReplica;
import com.oracle.bmc.core.model.Volume;
import com.oracle.bmc.core.model.VolumeBackup;
import com.oracle.bmc.core.model.VolumeBackupPolicy;
import com.oracle.bmc.core.model.VolumeBackupPolicyAssignment;
import com.oracle.bmc.core.model.VolumeGroup;
import com.oracle.bmc.core.model.VolumeGroupBackup;
import com.oracle.bmc.core.model.VolumeGroupReplica;
import com.oracle.bmc.core.model.VolumeKmsKey;
import com.oracle.bmc.core.requests.ChangeBootVolumeBackupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeBootVolumeCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeBackupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeGroupBackupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeGroupCompartmentRequest;
import com.oracle.bmc.core.requests.CopyBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.CopyVolumeBackupRequest;
import com.oracle.bmc.core.requests.CopyVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.CreateBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.CreateBootVolumeRequest;
import com.oracle.bmc.core.requests.CreateVolumeBackupPolicyAssignmentRequest;
import com.oracle.bmc.core.requests.CreateVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.CreateVolumeBackupRequest;
import com.oracle.bmc.core.requests.CreateVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.CreateVolumeGroupRequest;
import com.oracle.bmc.core.requests.CreateVolumeRequest;
import com.oracle.bmc.core.requests.DeleteBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.DeleteBootVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.DeleteBootVolumeRequest;
import com.oracle.bmc.core.requests.DeleteVolumeBackupPolicyAssignmentRequest;
import com.oracle.bmc.core.requests.DeleteVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.DeleteVolumeBackupRequest;
import com.oracle.bmc.core.requests.DeleteVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.DeleteVolumeGroupRequest;
import com.oracle.bmc.core.requests.DeleteVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.DeleteVolumeRequest;
import com.oracle.bmc.core.requests.GetBlockVolumeReplicaRequest;
import com.oracle.bmc.core.requests.GetBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.GetBootVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.GetBootVolumeReplicaRequest;
import com.oracle.bmc.core.requests.GetBootVolumeRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupPolicyAssetAssignmentRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupPolicyAssignmentRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupReplicaRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupRequest;
import com.oracle.bmc.core.requests.GetVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.GetVolumeRequest;
import com.oracle.bmc.core.requests.ListBlockVolumeReplicasRequest;
import com.oracle.bmc.core.requests.ListBootVolumeBackupsRequest;
import com.oracle.bmc.core.requests.ListBootVolumeReplicasRequest;
import com.oracle.bmc.core.requests.ListBootVolumesRequest;
import com.oracle.bmc.core.requests.ListVolumeBackupPoliciesRequest;
import com.oracle.bmc.core.requests.ListVolumeBackupsRequest;
import com.oracle.bmc.core.requests.ListVolumeGroupBackupsRequest;
import com.oracle.bmc.core.requests.ListVolumeGroupReplicasRequest;
import com.oracle.bmc.core.requests.ListVolumeGroupsRequest;
import com.oracle.bmc.core.requests.ListVolumesRequest;
import com.oracle.bmc.core.requests.UpdateBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.UpdateBootVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.UpdateBootVolumeRequest;
import com.oracle.bmc.core.requests.UpdateVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.UpdateVolumeBackupRequest;
import com.oracle.bmc.core.requests.UpdateVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.UpdateVolumeGroupRequest;
import com.oracle.bmc.core.requests.UpdateVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.UpdateVolumeRequest;
import com.oracle.bmc.core.responses.ChangeBootVolumeBackupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeBootVolumeCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeBackupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeGroupBackupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeGroupCompartmentResponse;
import com.oracle.bmc.core.responses.CopyBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.CopyVolumeBackupResponse;
import com.oracle.bmc.core.responses.CopyVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.CreateBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.CreateBootVolumeResponse;
import com.oracle.bmc.core.responses.CreateVolumeBackupPolicyAssignmentResponse;
import com.oracle.bmc.core.responses.CreateVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.CreateVolumeBackupResponse;
import com.oracle.bmc.core.responses.CreateVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.CreateVolumeGroupResponse;
import com.oracle.bmc.core.responses.CreateVolumeResponse;
import com.oracle.bmc.core.responses.DeleteBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.DeleteBootVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.DeleteBootVolumeResponse;
import com.oracle.bmc.core.responses.DeleteVolumeBackupPolicyAssignmentResponse;
import com.oracle.bmc.core.responses.DeleteVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.DeleteVolumeBackupResponse;
import com.oracle.bmc.core.responses.DeleteVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.DeleteVolumeGroupResponse;
import com.oracle.bmc.core.responses.DeleteVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.DeleteVolumeResponse;
import com.oracle.bmc.core.responses.GetBlockVolumeReplicaResponse;
import com.oracle.bmc.core.responses.GetBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.GetBootVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.GetBootVolumeReplicaResponse;
import com.oracle.bmc.core.responses.GetBootVolumeResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupPolicyAssetAssignmentResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupPolicyAssignmentResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupReplicaResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupResponse;
import com.oracle.bmc.core.responses.GetVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.GetVolumeResponse;
import com.oracle.bmc.core.responses.ListBlockVolumeReplicasResponse;
import com.oracle.bmc.core.responses.ListBootVolumeBackupsResponse;
import com.oracle.bmc.core.responses.ListBootVolumeReplicasResponse;
import com.oracle.bmc.core.responses.ListBootVolumesResponse;
import com.oracle.bmc.core.responses.ListVolumeBackupPoliciesResponse;
import com.oracle.bmc.core.responses.ListVolumeBackupsResponse;
import com.oracle.bmc.core.responses.ListVolumeGroupBackupsResponse;
import com.oracle.bmc.core.responses.ListVolumeGroupReplicasResponse;
import com.oracle.bmc.core.responses.ListVolumeGroupsResponse;
import com.oracle.bmc.core.responses.ListVolumesResponse;
import com.oracle.bmc.core.responses.UpdateBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.UpdateBootVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.UpdateBootVolumeResponse;
import com.oracle.bmc.core.responses.UpdateVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.UpdateVolumeBackupResponse;
import com.oracle.bmc.core.responses.UpdateVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.UpdateVolumeGroupResponse;
import com.oracle.bmc.core.responses.UpdateVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.UpdateVolumeResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.workrequests.WorkRequest;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockstorageClient
extends BaseSyncClient
implements Blockstorage {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BLOCKSTORAGE").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(BlockstorageClient.class);
    protected final ExecutorService executorService;
    private final BlockstorageWaiters waiters;
    private final BlockstoragePaginators paginators;

    BlockstorageClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Blockstorage-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.executorService = executorService;
        this.waiters = new BlockstorageWaiters(executorService, this);
        this.paginators = new BlockstoragePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeBootVolumeBackupCompartmentResponse changeBootVolumeBackupCompartment(ChangeBootVolumeBackupCompartmentRequest request) {
        Validate.notBlank((String)request.getBootVolumeBackupId(), (String)"bootVolumeBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeBootVolumeBackupCompartmentDetails(), "changeBootVolumeBackupCompartmentDetails is required");
        return (ChangeBootVolumeBackupCompartmentResponse)this.clientCall(request, ChangeBootVolumeBackupCompartmentResponse::builder).logger(LOG, "changeBootVolumeBackupCompartment").serviceDetails("Blockstorage", "ChangeBootVolumeBackupCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeBackup/ChangeBootVolumeBackupCompartment").method(Method.POST).requestBuilder(ChangeBootVolumeBackupCompartmentRequest::builder).basePath("/20160918").appendPathParam("bootVolumeBackups").appendPathParam(request.getBootVolumeBackupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", ChangeBootVolumeBackupCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeBootVolumeBackupCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeBootVolumeCompartmentResponse changeBootVolumeCompartment(ChangeBootVolumeCompartmentRequest request) {
        Validate.notBlank((String)request.getBootVolumeId(), (String)"bootVolumeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeBootVolumeCompartmentDetails(), "changeBootVolumeCompartmentDetails is required");
        return (ChangeBootVolumeCompartmentResponse)this.clientCall(request, ChangeBootVolumeCompartmentResponse::builder).logger(LOG, "changeBootVolumeCompartment").serviceDetails("Blockstorage", "ChangeBootVolumeCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolume/ChangeBootVolumeCompartment").method(Method.POST).requestBuilder(ChangeBootVolumeCompartmentRequest::builder).basePath("/20160918").appendPathParam("bootVolumes").appendPathParam(request.getBootVolumeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", ChangeBootVolumeCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeBootVolumeCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeVolumeBackupCompartmentResponse changeVolumeBackupCompartment(ChangeVolumeBackupCompartmentRequest request) {
        Validate.notBlank((String)request.getVolumeBackupId(), (String)"volumeBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVolumeBackupCompartmentDetails(), "changeVolumeBackupCompartmentDetails is required");
        return (ChangeVolumeBackupCompartmentResponse)this.clientCall(request, ChangeVolumeBackupCompartmentResponse::builder).logger(LOG, "changeVolumeBackupCompartment").serviceDetails("Blockstorage", "ChangeVolumeBackupCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackup/ChangeVolumeBackupCompartment").method(Method.POST).requestBuilder(ChangeVolumeBackupCompartmentRequest::builder).basePath("/20160918").appendPathParam("volumeBackups").appendPathParam(request.getVolumeBackupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", ChangeVolumeBackupCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeVolumeBackupCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeVolumeCompartmentResponse changeVolumeCompartment(ChangeVolumeCompartmentRequest request) {
        Validate.notBlank((String)request.getVolumeId(), (String)"volumeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVolumeCompartmentDetails(), "changeVolumeCompartmentDetails is required");
        return (ChangeVolumeCompartmentResponse)this.clientCall(request, ChangeVolumeCompartmentResponse::builder).logger(LOG, "changeVolumeCompartment").serviceDetails("Blockstorage", "ChangeVolumeCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Volume/ChangeVolumeCompartment").method(Method.POST).requestBuilder(ChangeVolumeCompartmentRequest::builder).basePath("/20160918").appendPathParam("volumes").appendPathParam(request.getVolumeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", ChangeVolumeCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeVolumeCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeVolumeGroupBackupCompartmentResponse changeVolumeGroupBackupCompartment(ChangeVolumeGroupBackupCompartmentRequest request) {
        Validate.notBlank((String)request.getVolumeGroupBackupId(), (String)"volumeGroupBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVolumeGroupBackupCompartmentDetails(), "changeVolumeGroupBackupCompartmentDetails is required");
        return (ChangeVolumeGroupBackupCompartmentResponse)this.clientCall(request, ChangeVolumeGroupBackupCompartmentResponse::builder).logger(LOG, "changeVolumeGroupBackupCompartment").serviceDetails("Blockstorage", "ChangeVolumeGroupBackupCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroupBackup/ChangeVolumeGroupBackupCompartment").method(Method.POST).requestBuilder(ChangeVolumeGroupBackupCompartmentRequest::builder).basePath("/20160918").appendPathParam("volumeGroupBackups").appendPathParam(request.getVolumeGroupBackupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", ChangeVolumeGroupBackupCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeVolumeGroupBackupCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeVolumeGroupCompartmentResponse changeVolumeGroupCompartment(ChangeVolumeGroupCompartmentRequest request) {
        Validate.notBlank((String)request.getVolumeGroupId(), (String)"volumeGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVolumeGroupCompartmentDetails(), "changeVolumeGroupCompartmentDetails is required");
        return (ChangeVolumeGroupCompartmentResponse)this.clientCall(request, ChangeVolumeGroupCompartmentResponse::builder).logger(LOG, "changeVolumeGroupCompartment").serviceDetails("Blockstorage", "ChangeVolumeGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroup/ChangeVolumeGroupCompartment").method(Method.POST).requestBuilder(ChangeVolumeGroupCompartmentRequest::builder).basePath("/20160918").appendPathParam("volumeGroups").appendPathParam(request.getVolumeGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", ChangeVolumeGroupCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeVolumeGroupCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CopyBootVolumeBackupResponse copyBootVolumeBackup(CopyBootVolumeBackupRequest request) {
        Validate.notBlank((String)request.getBootVolumeBackupId(), (String)"bootVolumeBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCopyBootVolumeBackupDetails(), "copyBootVolumeBackupDetails is required");
        return (CopyBootVolumeBackupResponse)this.clientCall(request, CopyBootVolumeBackupResponse::builder).logger(LOG, "copyBootVolumeBackup").serviceDetails("Blockstorage", "CopyBootVolumeBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeBackup/CopyBootVolumeBackup").method(Method.POST).requestBuilder(CopyBootVolumeBackupRequest::builder).basePath("/20160918").appendPathParam("bootVolumeBackups").appendPathParam(request.getBootVolumeBackupId()).appendPathParam("actions").appendPathParam("copy").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BootVolumeBackup.class, CopyBootVolumeBackupResponse.Builder::bootVolumeBackup).handleResponseHeaderString("etag", CopyBootVolumeBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CopyBootVolumeBackupResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CopyBootVolumeBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CopyBootVolumeBackupResponse.Builder::location).handleResponseHeaderString("content-location", CopyBootVolumeBackupResponse.Builder::contentLocation).callSync();
    }

    @Override
    public CopyVolumeBackupResponse copyVolumeBackup(CopyVolumeBackupRequest request) {
        Validate.notBlank((String)request.getVolumeBackupId(), (String)"volumeBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCopyVolumeBackupDetails(), "copyVolumeBackupDetails is required");
        return (CopyVolumeBackupResponse)this.clientCall(request, CopyVolumeBackupResponse::builder).logger(LOG, "copyVolumeBackup").serviceDetails("Blockstorage", "CopyVolumeBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackup/CopyVolumeBackup").method(Method.POST).requestBuilder(CopyVolumeBackupRequest::builder).basePath("/20160918").appendPathParam("volumeBackups").appendPathParam(request.getVolumeBackupId()).appendPathParam("actions").appendPathParam("copy").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(VolumeBackup.class, CopyVolumeBackupResponse.Builder::volumeBackup).handleResponseHeaderString("etag", CopyVolumeBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CopyVolumeBackupResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CopyVolumeBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CopyVolumeBackupResponse.Builder::location).handleResponseHeaderString("content-location", CopyVolumeBackupResponse.Builder::contentLocation).callSync();
    }

    @Override
    public CopyVolumeGroupBackupResponse copyVolumeGroupBackup(CopyVolumeGroupBackupRequest request) {
        Validate.notBlank((String)request.getVolumeGroupBackupId(), (String)"volumeGroupBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCopyVolumeGroupBackupDetails(), "copyVolumeGroupBackupDetails is required");
        return (CopyVolumeGroupBackupResponse)this.clientCall(request, CopyVolumeGroupBackupResponse::builder).logger(LOG, "copyVolumeGroupBackup").serviceDetails("Blockstorage", "CopyVolumeGroupBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroupBackup/CopyVolumeGroupBackup").method(Method.POST).requestBuilder(CopyVolumeGroupBackupRequest::builder).basePath("/20160918").appendPathParam("volumeGroupBackups").appendPathParam(request.getVolumeGroupBackupId()).appendPathParam("actions").appendPathParam("copy").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(VolumeGroupBackup.class, CopyVolumeGroupBackupResponse.Builder::volumeGroupBackup).handleResponseHeaderString("etag", CopyVolumeGroupBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CopyVolumeGroupBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateBootVolumeResponse createBootVolume(CreateBootVolumeRequest request) {
        Objects.requireNonNull(request.getCreateBootVolumeDetails(), "createBootVolumeDetails is required");
        return (CreateBootVolumeResponse)this.clientCall(request, CreateBootVolumeResponse::builder).logger(LOG, "createBootVolume").serviceDetails("Blockstorage", "CreateBootVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolume/CreateBootVolume").method(Method.POST).requestBuilder(CreateBootVolumeRequest::builder).basePath("/20160918").appendPathParam("bootVolumes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(BootVolume.class, CreateBootVolumeResponse.Builder::bootVolume).handleResponseHeaderString("etag", CreateBootVolumeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateBootVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateBootVolumeBackupResponse createBootVolumeBackup(CreateBootVolumeBackupRequest request) {
        Objects.requireNonNull(request.getCreateBootVolumeBackupDetails(), "createBootVolumeBackupDetails is required");
        return (CreateBootVolumeBackupResponse)this.clientCall(request, CreateBootVolumeBackupResponse::builder).logger(LOG, "createBootVolumeBackup").serviceDetails("Blockstorage", "CreateBootVolumeBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeBackup/CreateBootVolumeBackup").method(Method.POST).requestBuilder(CreateBootVolumeBackupRequest::builder).basePath("/20160918").appendPathParam("bootVolumeBackups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(BootVolumeBackup.class, CreateBootVolumeBackupResponse.Builder::bootVolumeBackup).handleResponseHeaderString("etag", CreateBootVolumeBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateBootVolumeBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVolumeResponse createVolume(CreateVolumeRequest request) {
        Objects.requireNonNull(request.getCreateVolumeDetails(), "createVolumeDetails is required");
        return (CreateVolumeResponse)this.clientCall(request, CreateVolumeResponse::builder).logger(LOG, "createVolume").serviceDetails("Blockstorage", "CreateVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Volume/CreateVolume").method(Method.POST).requestBuilder(CreateVolumeRequest::builder).basePath("/20160918").appendPathParam("volumes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Volume.class, CreateVolumeResponse.Builder::volume).handleResponseHeaderString("etag", CreateVolumeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVolumeBackupResponse createVolumeBackup(CreateVolumeBackupRequest request) {
        Objects.requireNonNull(request.getCreateVolumeBackupDetails(), "createVolumeBackupDetails is required");
        return (CreateVolumeBackupResponse)this.clientCall(request, CreateVolumeBackupResponse::builder).logger(LOG, "createVolumeBackup").serviceDetails("Blockstorage", "CreateVolumeBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackup/CreateVolumeBackup").method(Method.POST).requestBuilder(CreateVolumeBackupRequest::builder).basePath("/20160918").appendPathParam("volumeBackups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(VolumeBackup.class, CreateVolumeBackupResponse.Builder::volumeBackup).handleResponseHeaderString("etag", CreateVolumeBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVolumeBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVolumeBackupPolicyResponse createVolumeBackupPolicy(CreateVolumeBackupPolicyRequest request) {
        Objects.requireNonNull(request.getCreateVolumeBackupPolicyDetails(), "createVolumeBackupPolicyDetails is required");
        return (CreateVolumeBackupPolicyResponse)this.clientCall(request, CreateVolumeBackupPolicyResponse::builder).logger(LOG, "createVolumeBackupPolicy").serviceDetails("Blockstorage", "CreateVolumeBackupPolicy", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackupPolicy/CreateVolumeBackupPolicy").method(Method.POST).requestBuilder(CreateVolumeBackupPolicyRequest::builder).basePath("/20160918").appendPathParam("volumeBackupPolicies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(VolumeBackupPolicy.class, CreateVolumeBackupPolicyResponse.Builder::volumeBackupPolicy).handleResponseHeaderString("etag", CreateVolumeBackupPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVolumeBackupPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVolumeBackupPolicyAssignmentResponse createVolumeBackupPolicyAssignment(CreateVolumeBackupPolicyAssignmentRequest request) {
        Objects.requireNonNull(request.getCreateVolumeBackupPolicyAssignmentDetails(), "createVolumeBackupPolicyAssignmentDetails is required");
        return (CreateVolumeBackupPolicyAssignmentResponse)this.clientCall(request, CreateVolumeBackupPolicyAssignmentResponse::builder).logger(LOG, "createVolumeBackupPolicyAssignment").serviceDetails("Blockstorage", "CreateVolumeBackupPolicyAssignment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackupPolicyAssignment/CreateVolumeBackupPolicyAssignment").method(Method.POST).requestBuilder(CreateVolumeBackupPolicyAssignmentRequest::builder).basePath("/20160918").appendPathParam("volumeBackupPolicyAssignments").accept(new String[]{"application/json"}).hasBody().handleBody(VolumeBackupPolicyAssignment.class, CreateVolumeBackupPolicyAssignmentResponse.Builder::volumeBackupPolicyAssignment).handleResponseHeaderString("etag", CreateVolumeBackupPolicyAssignmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVolumeBackupPolicyAssignmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVolumeGroupResponse createVolumeGroup(CreateVolumeGroupRequest request) {
        Objects.requireNonNull(request.getCreateVolumeGroupDetails(), "createVolumeGroupDetails is required");
        return (CreateVolumeGroupResponse)this.clientCall(request, CreateVolumeGroupResponse::builder).logger(LOG, "createVolumeGroup").serviceDetails("Blockstorage", "CreateVolumeGroup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroup/CreateVolumeGroup").method(Method.POST).requestBuilder(CreateVolumeGroupRequest::builder).basePath("/20160918").appendPathParam("volumeGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(VolumeGroup.class, CreateVolumeGroupResponse.Builder::volumeGroup).handleResponseHeaderString("etag", CreateVolumeGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVolumeGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVolumeGroupBackupResponse createVolumeGroupBackup(CreateVolumeGroupBackupRequest request) {
        Objects.requireNonNull(request.getCreateVolumeGroupBackupDetails(), "createVolumeGroupBackupDetails is required");
        return (CreateVolumeGroupBackupResponse)this.clientCall(request, CreateVolumeGroupBackupResponse::builder).logger(LOG, "createVolumeGroupBackup").serviceDetails("Blockstorage", "CreateVolumeGroupBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroupBackup/CreateVolumeGroupBackup").method(Method.POST).requestBuilder(CreateVolumeGroupBackupRequest::builder).basePath("/20160918").appendPathParam("volumeGroupBackups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(VolumeGroupBackup.class, CreateVolumeGroupBackupResponse.Builder::volumeGroupBackup).handleResponseHeaderString("etag", CreateVolumeGroupBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVolumeGroupBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteBootVolumeResponse deleteBootVolume(DeleteBootVolumeRequest request) {
        Validate.notBlank((String)request.getBootVolumeId(), (String)"bootVolumeId must not be blank", (Object[])new Object[0]);
        return (DeleteBootVolumeResponse)this.clientCall(request, DeleteBootVolumeResponse::builder).logger(LOG, "deleteBootVolume").serviceDetails("Blockstorage", "DeleteBootVolume", "").method(Method.DELETE).requestBuilder(DeleteBootVolumeRequest::builder).basePath("/20160918").appendPathParam("bootVolumes").appendPathParam(request.getBootVolumeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteBootVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteBootVolumeBackupResponse deleteBootVolumeBackup(DeleteBootVolumeBackupRequest request) {
        Validate.notBlank((String)request.getBootVolumeBackupId(), (String)"bootVolumeBackupId must not be blank", (Object[])new Object[0]);
        return (DeleteBootVolumeBackupResponse)this.clientCall(request, DeleteBootVolumeBackupResponse::builder).logger(LOG, "deleteBootVolumeBackup").serviceDetails("Blockstorage", "DeleteBootVolumeBackup", "").method(Method.DELETE).requestBuilder(DeleteBootVolumeBackupRequest::builder).basePath("/20160918").appendPathParam("bootVolumeBackups").appendPathParam(request.getBootVolumeBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteBootVolumeBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteBootVolumeKmsKeyResponse deleteBootVolumeKmsKey(DeleteBootVolumeKmsKeyRequest request) {
        Validate.notBlank((String)request.getBootVolumeId(), (String)"bootVolumeId must not be blank", (Object[])new Object[0]);
        return (DeleteBootVolumeKmsKeyResponse)this.clientCall(request, DeleteBootVolumeKmsKeyResponse::builder).logger(LOG, "deleteBootVolumeKmsKey").serviceDetails("Blockstorage", "DeleteBootVolumeKmsKey", "").method(Method.DELETE).requestBuilder(DeleteBootVolumeKmsKeyRequest::builder).basePath("/20160918").appendPathParam("bootVolumes").appendPathParam(request.getBootVolumeId()).appendPathParam("kmsKey").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteBootVolumeKmsKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVolumeResponse deleteVolume(DeleteVolumeRequest request) {
        Validate.notBlank((String)request.getVolumeId(), (String)"volumeId must not be blank", (Object[])new Object[0]);
        return (DeleteVolumeResponse)this.clientCall(request, DeleteVolumeResponse::builder).logger(LOG, "deleteVolume").serviceDetails("Blockstorage", "DeleteVolume", "").method(Method.DELETE).requestBuilder(DeleteVolumeRequest::builder).basePath("/20160918").appendPathParam("volumes").appendPathParam(request.getVolumeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVolumeBackupResponse deleteVolumeBackup(DeleteVolumeBackupRequest request) {
        Validate.notBlank((String)request.getVolumeBackupId(), (String)"volumeBackupId must not be blank", (Object[])new Object[0]);
        return (DeleteVolumeBackupResponse)this.clientCall(request, DeleteVolumeBackupResponse::builder).logger(LOG, "deleteVolumeBackup").serviceDetails("Blockstorage", "DeleteVolumeBackup", "").method(Method.DELETE).requestBuilder(DeleteVolumeBackupRequest::builder).basePath("/20160918").appendPathParam("volumeBackups").appendPathParam(request.getVolumeBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteVolumeBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVolumeBackupPolicyResponse deleteVolumeBackupPolicy(DeleteVolumeBackupPolicyRequest request) {
        Validate.notBlank((String)request.getPolicyId(), (String)"policyId must not be blank", (Object[])new Object[0]);
        return (DeleteVolumeBackupPolicyResponse)this.clientCall(request, DeleteVolumeBackupPolicyResponse::builder).logger(LOG, "deleteVolumeBackupPolicy").serviceDetails("Blockstorage", "DeleteVolumeBackupPolicy", "").method(Method.DELETE).requestBuilder(DeleteVolumeBackupPolicyRequest::builder).basePath("/20160918").appendPathParam("volumeBackupPolicies").appendPathParam(request.getPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteVolumeBackupPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVolumeBackupPolicyAssignmentResponse deleteVolumeBackupPolicyAssignment(DeleteVolumeBackupPolicyAssignmentRequest request) {
        Validate.notBlank((String)request.getPolicyAssignmentId(), (String)"policyAssignmentId must not be blank", (Object[])new Object[0]);
        return (DeleteVolumeBackupPolicyAssignmentResponse)this.clientCall(request, DeleteVolumeBackupPolicyAssignmentResponse::builder).logger(LOG, "deleteVolumeBackupPolicyAssignment").serviceDetails("Blockstorage", "DeleteVolumeBackupPolicyAssignment", "").method(Method.DELETE).requestBuilder(DeleteVolumeBackupPolicyAssignmentRequest::builder).basePath("/20160918").appendPathParam("volumeBackupPolicyAssignments").appendPathParam(request.getPolicyAssignmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteVolumeBackupPolicyAssignmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVolumeGroupResponse deleteVolumeGroup(DeleteVolumeGroupRequest request) {
        Validate.notBlank((String)request.getVolumeGroupId(), (String)"volumeGroupId must not be blank", (Object[])new Object[0]);
        return (DeleteVolumeGroupResponse)this.clientCall(request, DeleteVolumeGroupResponse::builder).logger(LOG, "deleteVolumeGroup").serviceDetails("Blockstorage", "DeleteVolumeGroup", "").method(Method.DELETE).requestBuilder(DeleteVolumeGroupRequest::builder).basePath("/20160918").appendPathParam("volumeGroups").appendPathParam(request.getVolumeGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteVolumeGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVolumeGroupBackupResponse deleteVolumeGroupBackup(DeleteVolumeGroupBackupRequest request) {
        Validate.notBlank((String)request.getVolumeGroupBackupId(), (String)"volumeGroupBackupId must not be blank", (Object[])new Object[0]);
        return (DeleteVolumeGroupBackupResponse)this.clientCall(request, DeleteVolumeGroupBackupResponse::builder).logger(LOG, "deleteVolumeGroupBackup").serviceDetails("Blockstorage", "DeleteVolumeGroupBackup", "").method(Method.DELETE).requestBuilder(DeleteVolumeGroupBackupRequest::builder).basePath("/20160918").appendPathParam("volumeGroupBackups").appendPathParam(request.getVolumeGroupBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteVolumeGroupBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVolumeKmsKeyResponse deleteVolumeKmsKey(DeleteVolumeKmsKeyRequest request) {
        Validate.notBlank((String)request.getVolumeId(), (String)"volumeId must not be blank", (Object[])new Object[0]);
        return (DeleteVolumeKmsKeyResponse)this.clientCall(request, DeleteVolumeKmsKeyResponse::builder).logger(LOG, "deleteVolumeKmsKey").serviceDetails("Blockstorage", "DeleteVolumeKmsKey", "").method(Method.DELETE).requestBuilder(DeleteVolumeKmsKeyRequest::builder).basePath("/20160918").appendPathParam("volumes").appendPathParam(request.getVolumeId()).appendPathParam("kmsKey").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteVolumeKmsKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBlockVolumeReplicaResponse getBlockVolumeReplica(GetBlockVolumeReplicaRequest request) {
        Validate.notBlank((String)request.getBlockVolumeReplicaId(), (String)"blockVolumeReplicaId must not be blank", (Object[])new Object[0]);
        return (GetBlockVolumeReplicaResponse)this.clientCall(request, GetBlockVolumeReplicaResponse::builder).logger(LOG, "getBlockVolumeReplica").serviceDetails("Blockstorage", "GetBlockVolumeReplica", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BlockVolumeReplica/GetBlockVolumeReplica").method(Method.GET).requestBuilder(GetBlockVolumeReplicaRequest::builder).basePath("/20160918").appendPathParam("blockVolumeReplicas").appendPathParam(request.getBlockVolumeReplicaId()).accept(new String[]{"application/json"}).handleBody(BlockVolumeReplica.class, GetBlockVolumeReplicaResponse.Builder::blockVolumeReplica).handleResponseHeaderString("etag", GetBlockVolumeReplicaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBlockVolumeReplicaResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBootVolumeResponse getBootVolume(GetBootVolumeRequest request) {
        Validate.notBlank((String)request.getBootVolumeId(), (String)"bootVolumeId must not be blank", (Object[])new Object[0]);
        return (GetBootVolumeResponse)this.clientCall(request, GetBootVolumeResponse::builder).logger(LOG, "getBootVolume").serviceDetails("Blockstorage", "GetBootVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolume/GetBootVolume").method(Method.GET).requestBuilder(GetBootVolumeRequest::builder).basePath("/20160918").appendPathParam("bootVolumes").appendPathParam(request.getBootVolumeId()).accept(new String[]{"application/json"}).handleBody(BootVolume.class, GetBootVolumeResponse.Builder::bootVolume).handleResponseHeaderString("etag", GetBootVolumeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBootVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBootVolumeBackupResponse getBootVolumeBackup(GetBootVolumeBackupRequest request) {
        Validate.notBlank((String)request.getBootVolumeBackupId(), (String)"bootVolumeBackupId must not be blank", (Object[])new Object[0]);
        return (GetBootVolumeBackupResponse)this.clientCall(request, GetBootVolumeBackupResponse::builder).logger(LOG, "getBootVolumeBackup").serviceDetails("Blockstorage", "GetBootVolumeBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeBackup/GetBootVolumeBackup").method(Method.GET).requestBuilder(GetBootVolumeBackupRequest::builder).basePath("/20160918").appendPathParam("bootVolumeBackups").appendPathParam(request.getBootVolumeBackupId()).accept(new String[]{"application/json"}).handleBody(BootVolumeBackup.class, GetBootVolumeBackupResponse.Builder::bootVolumeBackup).handleResponseHeaderString("etag", GetBootVolumeBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBootVolumeBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBootVolumeKmsKeyResponse getBootVolumeKmsKey(GetBootVolumeKmsKeyRequest request) {
        Validate.notBlank((String)request.getBootVolumeId(), (String)"bootVolumeId must not be blank", (Object[])new Object[0]);
        return (GetBootVolumeKmsKeyResponse)this.clientCall(request, GetBootVolumeKmsKeyResponse::builder).logger(LOG, "getBootVolumeKmsKey").serviceDetails("Blockstorage", "GetBootVolumeKmsKey", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeKmsKey/GetBootVolumeKmsKey").method(Method.GET).requestBuilder(GetBootVolumeKmsKeyRequest::builder).basePath("/20160918").appendPathParam("bootVolumes").appendPathParam(request.getBootVolumeId()).appendPathParam("kmsKey").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleBody(BootVolumeKmsKey.class, GetBootVolumeKmsKeyResponse.Builder::bootVolumeKmsKey).handleResponseHeaderString("etag", GetBootVolumeKmsKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBootVolumeKmsKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBootVolumeReplicaResponse getBootVolumeReplica(GetBootVolumeReplicaRequest request) {
        Validate.notBlank((String)request.getBootVolumeReplicaId(), (String)"bootVolumeReplicaId must not be blank", (Object[])new Object[0]);
        return (GetBootVolumeReplicaResponse)this.clientCall(request, GetBootVolumeReplicaResponse::builder).logger(LOG, "getBootVolumeReplica").serviceDetails("Blockstorage", "GetBootVolumeReplica", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeReplica/GetBootVolumeReplica").method(Method.GET).requestBuilder(GetBootVolumeReplicaRequest::builder).basePath("/20160918").appendPathParam("bootVolumeReplicas").appendPathParam(request.getBootVolumeReplicaId()).accept(new String[]{"application/json"}).handleBody(BootVolumeReplica.class, GetBootVolumeReplicaResponse.Builder::bootVolumeReplica).handleResponseHeaderString("etag", GetBootVolumeReplicaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBootVolumeReplicaResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVolumeResponse getVolume(GetVolumeRequest request) {
        Validate.notBlank((String)request.getVolumeId(), (String)"volumeId must not be blank", (Object[])new Object[0]);
        return (GetVolumeResponse)this.clientCall(request, GetVolumeResponse::builder).logger(LOG, "getVolume").serviceDetails("Blockstorage", "GetVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Volume/GetVolume").method(Method.GET).requestBuilder(GetVolumeRequest::builder).basePath("/20160918").appendPathParam("volumes").appendPathParam(request.getVolumeId()).accept(new String[]{"application/json"}).handleBody(Volume.class, GetVolumeResponse.Builder::volume).handleResponseHeaderString("etag", GetVolumeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVolumeBackupResponse getVolumeBackup(GetVolumeBackupRequest request) {
        Validate.notBlank((String)request.getVolumeBackupId(), (String)"volumeBackupId must not be blank", (Object[])new Object[0]);
        return (GetVolumeBackupResponse)this.clientCall(request, GetVolumeBackupResponse::builder).logger(LOG, "getVolumeBackup").serviceDetails("Blockstorage", "GetVolumeBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackup/GetVolumeBackup").method(Method.GET).requestBuilder(GetVolumeBackupRequest::builder).basePath("/20160918").appendPathParam("volumeBackups").appendPathParam(request.getVolumeBackupId()).accept(new String[]{"application/json"}).handleBody(VolumeBackup.class, GetVolumeBackupResponse.Builder::volumeBackup).handleResponseHeaderString("etag", GetVolumeBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVolumeBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVolumeBackupPolicyResponse getVolumeBackupPolicy(GetVolumeBackupPolicyRequest request) {
        Validate.notBlank((String)request.getPolicyId(), (String)"policyId must not be blank", (Object[])new Object[0]);
        return (GetVolumeBackupPolicyResponse)this.clientCall(request, GetVolumeBackupPolicyResponse::builder).logger(LOG, "getVolumeBackupPolicy").serviceDetails("Blockstorage", "GetVolumeBackupPolicy", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackupPolicy/GetVolumeBackupPolicy").method(Method.GET).requestBuilder(GetVolumeBackupPolicyRequest::builder).basePath("/20160918").appendPathParam("volumeBackupPolicies").appendPathParam(request.getPolicyId()).accept(new String[]{"application/json"}).handleBody(VolumeBackupPolicy.class, GetVolumeBackupPolicyResponse.Builder::volumeBackupPolicy).handleResponseHeaderString("etag", GetVolumeBackupPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVolumeBackupPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVolumeBackupPolicyAssetAssignmentResponse getVolumeBackupPolicyAssetAssignment(GetVolumeBackupPolicyAssetAssignmentRequest request) {
        Objects.requireNonNull(request.getAssetId(), "assetId is required");
        return (GetVolumeBackupPolicyAssetAssignmentResponse)this.clientCall(request, GetVolumeBackupPolicyAssetAssignmentResponse::builder).logger(LOG, "getVolumeBackupPolicyAssetAssignment").serviceDetails("Blockstorage", "GetVolumeBackupPolicyAssetAssignment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackupPolicyAssignment/GetVolumeBackupPolicyAssetAssignment").method(Method.GET).requestBuilder(GetVolumeBackupPolicyAssetAssignmentRequest::builder).basePath("/20160918").appendPathParam("volumeBackupPolicyAssignments").appendQueryParam("assetId", (Object)request.getAssetId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).handleBodyList(VolumeBackupPolicyAssignment.class, GetVolumeBackupPolicyAssetAssignmentResponse.Builder::items).handleResponseHeaderString("opc-next-page", GetVolumeBackupPolicyAssetAssignmentResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", GetVolumeBackupPolicyAssetAssignmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVolumeBackupPolicyAssignmentResponse getVolumeBackupPolicyAssignment(GetVolumeBackupPolicyAssignmentRequest request) {
        Validate.notBlank((String)request.getPolicyAssignmentId(), (String)"policyAssignmentId must not be blank", (Object[])new Object[0]);
        return (GetVolumeBackupPolicyAssignmentResponse)this.clientCall(request, GetVolumeBackupPolicyAssignmentResponse::builder).logger(LOG, "getVolumeBackupPolicyAssignment").serviceDetails("Blockstorage", "GetVolumeBackupPolicyAssignment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackupPolicyAssignment/GetVolumeBackupPolicyAssignment").method(Method.GET).requestBuilder(GetVolumeBackupPolicyAssignmentRequest::builder).basePath("/20160918").appendPathParam("volumeBackupPolicyAssignments").appendPathParam(request.getPolicyAssignmentId()).accept(new String[]{"application/json"}).handleBody(VolumeBackupPolicyAssignment.class, GetVolumeBackupPolicyAssignmentResponse.Builder::volumeBackupPolicyAssignment).handleResponseHeaderString("etag", GetVolumeBackupPolicyAssignmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVolumeBackupPolicyAssignmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVolumeGroupResponse getVolumeGroup(GetVolumeGroupRequest request) {
        Validate.notBlank((String)request.getVolumeGroupId(), (String)"volumeGroupId must not be blank", (Object[])new Object[0]);
        return (GetVolumeGroupResponse)this.clientCall(request, GetVolumeGroupResponse::builder).logger(LOG, "getVolumeGroup").serviceDetails("Blockstorage", "GetVolumeGroup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroup/GetVolumeGroup").method(Method.GET).requestBuilder(GetVolumeGroupRequest::builder).basePath("/20160918").appendPathParam("volumeGroups").appendPathParam(request.getVolumeGroupId()).accept(new String[]{"application/json"}).handleBody(VolumeGroup.class, GetVolumeGroupResponse.Builder::volumeGroup).handleResponseHeaderString("etag", GetVolumeGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVolumeGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVolumeGroupBackupResponse getVolumeGroupBackup(GetVolumeGroupBackupRequest request) {
        Validate.notBlank((String)request.getVolumeGroupBackupId(), (String)"volumeGroupBackupId must not be blank", (Object[])new Object[0]);
        return (GetVolumeGroupBackupResponse)this.clientCall(request, GetVolumeGroupBackupResponse::builder).logger(LOG, "getVolumeGroupBackup").serviceDetails("Blockstorage", "GetVolumeGroupBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroupBackup/GetVolumeGroupBackup").method(Method.GET).requestBuilder(GetVolumeGroupBackupRequest::builder).basePath("/20160918").appendPathParam("volumeGroupBackups").appendPathParam(request.getVolumeGroupBackupId()).accept(new String[]{"application/json"}).handleBody(VolumeGroupBackup.class, GetVolumeGroupBackupResponse.Builder::volumeGroupBackup).handleResponseHeaderString("etag", GetVolumeGroupBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVolumeGroupBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVolumeGroupReplicaResponse getVolumeGroupReplica(GetVolumeGroupReplicaRequest request) {
        Validate.notBlank((String)request.getVolumeGroupReplicaId(), (String)"volumeGroupReplicaId must not be blank", (Object[])new Object[0]);
        return (GetVolumeGroupReplicaResponse)this.clientCall(request, GetVolumeGroupReplicaResponse::builder).logger(LOG, "getVolumeGroupReplica").serviceDetails("Blockstorage", "GetVolumeGroupReplica", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroupReplica/GetVolumeGroupReplica").method(Method.GET).requestBuilder(GetVolumeGroupReplicaRequest::builder).basePath("/20160918").appendPathParam("volumeGroupReplicas").appendPathParam(request.getVolumeGroupReplicaId()).accept(new String[]{"application/json"}).handleBody(VolumeGroupReplica.class, GetVolumeGroupReplicaResponse.Builder::volumeGroupReplica).handleResponseHeaderString("etag", GetVolumeGroupReplicaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVolumeGroupReplicaResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVolumeKmsKeyResponse getVolumeKmsKey(GetVolumeKmsKeyRequest request) {
        Validate.notBlank((String)request.getVolumeId(), (String)"volumeId must not be blank", (Object[])new Object[0]);
        return (GetVolumeKmsKeyResponse)this.clientCall(request, GetVolumeKmsKeyResponse::builder).logger(LOG, "getVolumeKmsKey").serviceDetails("Blockstorage", "GetVolumeKmsKey", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeKmsKey/GetVolumeKmsKey").method(Method.GET).requestBuilder(GetVolumeKmsKeyRequest::builder).basePath("/20160918").appendPathParam("volumes").appendPathParam(request.getVolumeId()).appendPathParam("kmsKey").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleBody(VolumeKmsKey.class, GetVolumeKmsKeyResponse.Builder::volumeKmsKey).handleResponseHeaderString("etag", GetVolumeKmsKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVolumeKmsKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListBlockVolumeReplicasResponse listBlockVolumeReplicas(ListBlockVolumeReplicasRequest request) {
        return (ListBlockVolumeReplicasResponse)this.clientCall(request, ListBlockVolumeReplicasResponse::builder).logger(LOG, "listBlockVolumeReplicas").serviceDetails("Blockstorage", "ListBlockVolumeReplicas", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BlockVolumeReplica/ListBlockVolumeReplicas").method(Method.GET).requestBuilder(ListBlockVolumeReplicasRequest::builder).basePath("/20160918").appendPathParam("blockVolumeReplicas").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("volumeGroupReplicaId", (Object)request.getVolumeGroupReplicaId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(BlockVolumeReplica.class, ListBlockVolumeReplicasResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListBlockVolumeReplicasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListBlockVolumeReplicasResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListBootVolumeBackupsResponse listBootVolumeBackups(ListBootVolumeBackupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListBootVolumeBackupsResponse)this.clientCall(request, ListBootVolumeBackupsResponse::builder).logger(LOG, "listBootVolumeBackups").serviceDetails("Blockstorage", "ListBootVolumeBackups", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeBackup/ListBootVolumeBackups").method(Method.GET).requestBuilder(ListBootVolumeBackupsRequest::builder).basePath("/20160918").appendPathParam("bootVolumeBackups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("bootVolumeId", (Object)request.getBootVolumeId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("sourceBootVolumeBackupId", (Object)request.getSourceBootVolumeBackupId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(BootVolumeBackup.class, ListBootVolumeBackupsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListBootVolumeBackupsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListBootVolumeBackupsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListBootVolumeReplicasResponse listBootVolumeReplicas(ListBootVolumeReplicasRequest request) {
        return (ListBootVolumeReplicasResponse)this.clientCall(request, ListBootVolumeReplicasResponse::builder).logger(LOG, "listBootVolumeReplicas").serviceDetails("Blockstorage", "ListBootVolumeReplicas", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeReplica/ListBootVolumeReplicas").method(Method.GET).requestBuilder(ListBootVolumeReplicasRequest::builder).basePath("/20160918").appendPathParam("bootVolumeReplicas").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("volumeGroupReplicaId", (Object)request.getVolumeGroupReplicaId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(BootVolumeReplica.class, ListBootVolumeReplicasResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListBootVolumeReplicasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListBootVolumeReplicasResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListBootVolumesResponse listBootVolumes(ListBootVolumesRequest request) {
        return (ListBootVolumesResponse)this.clientCall(request, ListBootVolumesResponse::builder).logger(LOG, "listBootVolumes").serviceDetails("Blockstorage", "ListBootVolumes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolume/ListBootVolumes").method(Method.GET).requestBuilder(ListBootVolumesRequest::builder).basePath("/20160918").appendPathParam("bootVolumes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("volumeGroupId", (Object)request.getVolumeGroupId()).accept(new String[]{"application/json"}).handleBodyList(BootVolume.class, ListBootVolumesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListBootVolumesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListBootVolumesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVolumeBackupPoliciesResponse listVolumeBackupPolicies(ListVolumeBackupPoliciesRequest request) {
        return (ListVolumeBackupPoliciesResponse)this.clientCall(request, ListVolumeBackupPoliciesResponse::builder).logger(LOG, "listVolumeBackupPolicies").serviceDetails("Blockstorage", "ListVolumeBackupPolicies", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackupPolicy/ListVolumeBackupPolicies").method(Method.GET).requestBuilder(ListVolumeBackupPoliciesRequest::builder).basePath("/20160918").appendPathParam("volumeBackupPolicies").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).handleBodyList(VolumeBackupPolicy.class, ListVolumeBackupPoliciesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVolumeBackupPoliciesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVolumeBackupPoliciesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVolumeBackupsResponse listVolumeBackups(ListVolumeBackupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVolumeBackupsResponse)this.clientCall(request, ListVolumeBackupsResponse::builder).logger(LOG, "listVolumeBackups").serviceDetails("Blockstorage", "ListVolumeBackups", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackup/ListVolumeBackups").method(Method.GET).requestBuilder(ListVolumeBackupsRequest::builder).basePath("/20160918").appendPathParam("volumeBackups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("volumeId", (Object)request.getVolumeId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("sourceVolumeBackupId", (Object)request.getSourceVolumeBackupId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(VolumeBackup.class, ListVolumeBackupsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVolumeBackupsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVolumeBackupsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVolumeGroupBackupsResponse listVolumeGroupBackups(ListVolumeGroupBackupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVolumeGroupBackupsResponse)this.clientCall(request, ListVolumeGroupBackupsResponse::builder).logger(LOG, "listVolumeGroupBackups").serviceDetails("Blockstorage", "ListVolumeGroupBackups", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroupBackup/ListVolumeGroupBackups").method(Method.GET).requestBuilder(ListVolumeGroupBackupsRequest::builder).basePath("/20160918").appendPathParam("volumeGroupBackups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("volumeGroupId", (Object)request.getVolumeGroupId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(VolumeGroupBackup.class, ListVolumeGroupBackupsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVolumeGroupBackupsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVolumeGroupBackupsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVolumeGroupReplicasResponse listVolumeGroupReplicas(ListVolumeGroupReplicasRequest request) {
        Objects.requireNonNull(request.getAvailabilityDomain(), "availabilityDomain is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVolumeGroupReplicasResponse)this.clientCall(request, ListVolumeGroupReplicasResponse::builder).logger(LOG, "listVolumeGroupReplicas").serviceDetails("Blockstorage", "ListVolumeGroupReplicas", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroupReplica/ListVolumeGroupReplicas").method(Method.GET).requestBuilder(ListVolumeGroupReplicasRequest::builder).basePath("/20160918").appendPathParam("volumeGroupReplicas").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(VolumeGroupReplica.class, ListVolumeGroupReplicasResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVolumeGroupReplicasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVolumeGroupReplicasResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVolumeGroupsResponse listVolumeGroups(ListVolumeGroupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVolumeGroupsResponse)this.clientCall(request, ListVolumeGroupsResponse::builder).logger(LOG, "listVolumeGroups").serviceDetails("Blockstorage", "ListVolumeGroups", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroup/ListVolumeGroups").method(Method.GET).requestBuilder(ListVolumeGroupsRequest::builder).basePath("/20160918").appendPathParam("volumeGroups").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(VolumeGroup.class, ListVolumeGroupsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVolumeGroupsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVolumeGroupsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVolumesResponse listVolumes(ListVolumesRequest request) {
        return (ListVolumesResponse)this.clientCall(request, ListVolumesResponse::builder).logger(LOG, "listVolumes").serviceDetails("Blockstorage", "ListVolumes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Volume/ListVolumes").method(Method.GET).requestBuilder(ListVolumesRequest::builder).basePath("/20160918").appendPathParam("volumes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("volumeGroupId", (Object)request.getVolumeGroupId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(Volume.class, ListVolumesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVolumesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVolumesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateBootVolumeResponse updateBootVolume(UpdateBootVolumeRequest request) {
        Validate.notBlank((String)request.getBootVolumeId(), (String)"bootVolumeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBootVolumeDetails(), "updateBootVolumeDetails is required");
        return (UpdateBootVolumeResponse)this.clientCall(request, UpdateBootVolumeResponse::builder).logger(LOG, "updateBootVolume").serviceDetails("Blockstorage", "UpdateBootVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolume/UpdateBootVolume").method(Method.PUT).requestBuilder(UpdateBootVolumeRequest::builder).basePath("/20160918").appendPathParam("bootVolumes").appendPathParam(request.getBootVolumeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(BootVolume.class, UpdateBootVolumeResponse.Builder::bootVolume).handleResponseHeaderString("etag", UpdateBootVolumeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateBootVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateBootVolumeBackupResponse updateBootVolumeBackup(UpdateBootVolumeBackupRequest request) {
        Validate.notBlank((String)request.getBootVolumeBackupId(), (String)"bootVolumeBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBootVolumeBackupDetails(), "updateBootVolumeBackupDetails is required");
        return (UpdateBootVolumeBackupResponse)this.clientCall(request, UpdateBootVolumeBackupResponse::builder).logger(LOG, "updateBootVolumeBackup").serviceDetails("Blockstorage", "UpdateBootVolumeBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeBackup/UpdateBootVolumeBackup").method(Method.PUT).requestBuilder(UpdateBootVolumeBackupRequest::builder).basePath("/20160918").appendPathParam("bootVolumeBackups").appendPathParam(request.getBootVolumeBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(BootVolumeBackup.class, UpdateBootVolumeBackupResponse.Builder::bootVolumeBackup).handleResponseHeaderString("etag", UpdateBootVolumeBackupResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateBootVolumeKmsKeyResponse updateBootVolumeKmsKey(UpdateBootVolumeKmsKeyRequest request) {
        Validate.notBlank((String)request.getBootVolumeId(), (String)"bootVolumeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBootVolumeKmsKeyDetails(), "updateBootVolumeKmsKeyDetails is required");
        return (UpdateBootVolumeKmsKeyResponse)this.clientCall(request, UpdateBootVolumeKmsKeyResponse::builder).logger(LOG, "updateBootVolumeKmsKey").serviceDetails("Blockstorage", "UpdateBootVolumeKmsKey", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeKmsKey/UpdateBootVolumeKmsKey").method(Method.PUT).requestBuilder(UpdateBootVolumeKmsKeyRequest::builder).basePath("/20160918").appendPathParam("bootVolumes").appendPathParam(request.getBootVolumeId()).appendPathParam("kmsKey").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(BootVolumeKmsKey.class, UpdateBootVolumeKmsKeyResponse.Builder::bootVolumeKmsKey).handleResponseHeaderString("etag", UpdateBootVolumeKmsKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateBootVolumeKmsKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVolumeResponse updateVolume(UpdateVolumeRequest request) {
        Validate.notBlank((String)request.getVolumeId(), (String)"volumeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVolumeDetails(), "updateVolumeDetails is required");
        return (UpdateVolumeResponse)this.clientCall(request, UpdateVolumeResponse::builder).logger(LOG, "updateVolume").serviceDetails("Blockstorage", "UpdateVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Volume/UpdateVolume").method(Method.PUT).requestBuilder(UpdateVolumeRequest::builder).basePath("/20160918").appendPathParam("volumes").appendPathParam(request.getVolumeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Volume.class, UpdateVolumeResponse.Builder::volume).handleResponseHeaderString("etag", UpdateVolumeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVolumeBackupResponse updateVolumeBackup(UpdateVolumeBackupRequest request) {
        Validate.notBlank((String)request.getVolumeBackupId(), (String)"volumeBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVolumeBackupDetails(), "updateVolumeBackupDetails is required");
        return (UpdateVolumeBackupResponse)this.clientCall(request, UpdateVolumeBackupResponse::builder).logger(LOG, "updateVolumeBackup").serviceDetails("Blockstorage", "UpdateVolumeBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackup/UpdateVolumeBackup").method(Method.PUT).requestBuilder(UpdateVolumeBackupRequest::builder).basePath("/20160918").appendPathParam("volumeBackups").appendPathParam(request.getVolumeBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(VolumeBackup.class, UpdateVolumeBackupResponse.Builder::volumeBackup).handleResponseHeaderString("etag", UpdateVolumeBackupResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateVolumeBackupPolicyResponse updateVolumeBackupPolicy(UpdateVolumeBackupPolicyRequest request) {
        Validate.notBlank((String)request.getPolicyId(), (String)"policyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVolumeBackupPolicyDetails(), "updateVolumeBackupPolicyDetails is required");
        return (UpdateVolumeBackupPolicyResponse)this.clientCall(request, UpdateVolumeBackupPolicyResponse::builder).logger(LOG, "updateVolumeBackupPolicy").serviceDetails("Blockstorage", "UpdateVolumeBackupPolicy", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeBackupPolicy/UpdateVolumeBackupPolicy").method(Method.PUT).requestBuilder(UpdateVolumeBackupPolicyRequest::builder).basePath("/20160918").appendPathParam("volumeBackupPolicies").appendPathParam(request.getPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(VolumeBackupPolicy.class, UpdateVolumeBackupPolicyResponse.Builder::volumeBackupPolicy).handleResponseHeaderString("etag", UpdateVolumeBackupPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVolumeBackupPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVolumeGroupResponse updateVolumeGroup(UpdateVolumeGroupRequest request) {
        Validate.notBlank((String)request.getVolumeGroupId(), (String)"volumeGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVolumeGroupDetails(), "updateVolumeGroupDetails is required");
        return (UpdateVolumeGroupResponse)this.clientCall(request, UpdateVolumeGroupResponse::builder).logger(LOG, "updateVolumeGroup").serviceDetails("Blockstorage", "UpdateVolumeGroup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroup/UpdateVolumeGroup").method(Method.PUT).requestBuilder(UpdateVolumeGroupRequest::builder).basePath("/20160918").appendPathParam("volumeGroups").appendPathParam(request.getVolumeGroupId()).appendQueryParam("preserveVolumeReplica", (Object)request.getPreserveVolumeReplica()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(VolumeGroup.class, UpdateVolumeGroupResponse.Builder::volumeGroup).handleResponseHeaderString("etag", UpdateVolumeGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVolumeGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVolumeGroupBackupResponse updateVolumeGroupBackup(UpdateVolumeGroupBackupRequest request) {
        Validate.notBlank((String)request.getVolumeGroupBackupId(), (String)"volumeGroupBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVolumeGroupBackupDetails(), "updateVolumeGroupBackupDetails is required");
        return (UpdateVolumeGroupBackupResponse)this.clientCall(request, UpdateVolumeGroupBackupResponse::builder).logger(LOG, "updateVolumeGroupBackup").serviceDetails("Blockstorage", "UpdateVolumeGroupBackup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeGroupBackup/UpdateVolumeGroupBackup").method(Method.PUT).requestBuilder(UpdateVolumeGroupBackupRequest::builder).basePath("/20160918").appendPathParam("volumeGroupBackups").appendPathParam(request.getVolumeGroupBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(VolumeGroupBackup.class, UpdateVolumeGroupBackupResponse.Builder::volumeGroupBackup).handleResponseHeaderString("etag", UpdateVolumeGroupBackupResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateVolumeKmsKeyResponse updateVolumeKmsKey(UpdateVolumeKmsKeyRequest request) {
        Validate.notBlank((String)request.getVolumeId(), (String)"volumeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVolumeKmsKeyDetails(), "updateVolumeKmsKeyDetails is required");
        return (UpdateVolumeKmsKeyResponse)this.clientCall(request, UpdateVolumeKmsKeyResponse::builder).logger(LOG, "updateVolumeKmsKey").serviceDetails("Blockstorage", "UpdateVolumeKmsKey", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeKmsKey/UpdateVolumeKmsKey").method(Method.PUT).requestBuilder(UpdateVolumeKmsKeyRequest::builder).basePath("/20160918").appendPathParam("volumes").appendPathParam(request.getVolumeId()).appendPathParam("kmsKey").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(VolumeKmsKey.class, UpdateVolumeKmsKeyResponse.Builder::volumeKmsKey).handleResponseHeaderString("etag", UpdateVolumeKmsKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVolumeKmsKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BlockstorageWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public BlockstorageWaiters newWaiters(WorkRequest workRequestClient) {
        return new BlockstorageWaiters(this.executorService, this, workRequestClient);
    }

    @Override
    public BlockstoragePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public BlockstorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)BlockstorageClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockstorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(BlockstorageClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockstorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)BlockstorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockstorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)BlockstorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockstorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)BlockstorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockstorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)BlockstorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockstorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BlockstorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockstorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BlockstorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BlockstorageClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "core";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"core");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public BlockstorageClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new BlockstorageClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

