/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.ChangeInstanceCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeInstanceCompartmentRequest
extends BmcRequest<ChangeInstanceCompartmentDetails> {
    private String instanceId;
    private ChangeInstanceCompartmentDetails changeInstanceCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getInstanceId() {
        return this.instanceId;
    }

    public ChangeInstanceCompartmentDetails getChangeInstanceCompartmentDetails() {
        return this.changeInstanceCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeInstanceCompartmentDetails getBody$() {
        return this.changeInstanceCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().instanceId(this.instanceId).changeInstanceCompartmentDetails(this.changeInstanceCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceId=").append(String.valueOf(this.instanceId));
        sb.append(",changeInstanceCompartmentDetails=").append(String.valueOf((Object)this.changeInstanceCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeInstanceCompartmentRequest)) {
            return false;
        }
        ChangeInstanceCompartmentRequest other = (ChangeInstanceCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals((Object)this.changeInstanceCompartmentDetails, (Object)other.changeInstanceCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.changeInstanceCompartmentDetails == null ? 43 : this.changeInstanceCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceId = null;
        private ChangeInstanceCompartmentDetails changeInstanceCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder changeInstanceCompartmentDetails(ChangeInstanceCompartmentDetails changeInstanceCompartmentDetails) {
            this.changeInstanceCompartmentDetails = changeInstanceCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeInstanceCompartmentRequest o) {
            this.instanceId(o.getInstanceId());
            this.changeInstanceCompartmentDetails(o.getChangeInstanceCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeInstanceCompartmentRequest build() {
            ChangeInstanceCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeInstanceCompartmentDetails body) {
            this.changeInstanceCompartmentDetails(body);
            return this;
        }

        public ChangeInstanceCompartmentRequest buildWithoutInvocationCallback() {
            ChangeInstanceCompartmentRequest request = new ChangeInstanceCompartmentRequest();
            request.instanceId = this.instanceId;
            request.changeInstanceCompartmentDetails = this.changeInstanceCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

