/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetImageShapeCompatibilityEntryRequest
extends BmcRequest<Void> {
    private String imageId;
    private String shapeName;
    private String opcRequestId;

    public String getImageId() {
        return this.imageId;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().imageId(this.imageId).shapeName(this.shapeName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",imageId=").append(String.valueOf(this.imageId));
        sb.append(",shapeName=").append(String.valueOf(this.shapeName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetImageShapeCompatibilityEntryRequest)) {
            return false;
        }
        GetImageShapeCompatibilityEntryRequest other = (GetImageShapeCompatibilityEntryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.imageId, other.imageId) && Objects.equals(this.shapeName, other.shapeName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetImageShapeCompatibilityEntryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String imageId = null;
        private String shapeName = null;
        private String opcRequestId = null;

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetImageShapeCompatibilityEntryRequest o) {
            this.imageId(o.getImageId());
            this.shapeName(o.getShapeName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetImageShapeCompatibilityEntryRequest build() {
            GetImageShapeCompatibilityEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetImageShapeCompatibilityEntryRequest buildWithoutInvocationCallback() {
            GetImageShapeCompatibilityEntryRequest request = new GetImageShapeCompatibilityEntryRequest();
            request.imageId = this.imageId;
            request.shapeName = this.shapeName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

