/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetRouteTableRequest
extends BmcRequest<Void> {
    private String rtId;

    public String getRtId() {
        return this.rtId;
    }

    public Builder toBuilder() {
        return new Builder().rtId(this.rtId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",rtId=").append(String.valueOf(this.rtId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRouteTableRequest)) {
            return false;
        }
        GetRouteTableRequest other = (GetRouteTableRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.rtId, other.rtId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.rtId == null ? 43 : this.rtId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRouteTableRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String rtId = null;

        public Builder rtId(String rtId) {
            this.rtId = rtId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRouteTableRequest o) {
            this.rtId(o.getRtId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRouteTableRequest build() {
            GetRouteTableRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRouteTableRequest buildWithoutInvocationCallback() {
            GetRouteTableRequest request = new GetRouteTableRequest();
            request.rtId = this.rtId;
            return request;
        }
    }
}

