/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectNode;

public class ObjectFieldNode
extends ObjectNode
implements HeapWalkerFieldNode {
    private ObjectFieldValue fieldValue;

    public ObjectFieldNode(ObjectFieldValue fieldValue, HeapWalkerNode parent) {
        this(fieldValue, parent, parent == null ? 1 : parent.getMode());
    }

    public ObjectFieldNode(ObjectFieldValue fieldValue, HeapWalkerNode parent, int mode) {
        super(mode != 2 ? fieldValue.getInstance() : fieldValue.getDefiningInstance(), fieldValue.getField().getName(), parent, mode);
        this.fieldValue = fieldValue;
        if (!this.isLoop() && this.getMode() == 2 && this.isStatic()) {
            this.loopTo = this.computeClassLoopTo();
        }
    }

    public ObjectFieldValue getFieldValue() {
        return this.fieldValue;
    }

    @Override
    public boolean isStatic() {
        return this.fieldValue.getField().isStatic();
    }

    @Override
    protected Icon computeIcon() {
        ImageIcon icon = BrowserUtils.ICON_INSTANCE;
        if (this.isStatic()) {
            icon = BrowserUtils.createStaticIcon(icon);
        }
        if (this.getMode() == 2 && this.getInstance().isGCRoot()) {
            icon = BrowserUtils.createGCRootIcon(icon);
        }
        return this.processLoopIcon(icon);
    }

    private HeapWalkerNode computeClassLoopTo() {
        JavaClass declaringClass = this.fieldValue.getField().getDeclaringClass();
        HeapWalkerNode parent = this.getParent();
        while (parent instanceof HeapWalkerInstanceNode) {
            HeapWalkerFieldNode parentF;
            if (parent instanceof HeapWalkerFieldNode && (parentF = (HeapWalkerFieldNode)((Object)parent)).isStatic() && parentF.getFieldValue().getField().getDeclaringClass().equals((Object)declaringClass)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    public Object getNodeID() {
        return this.fieldValue;
    }
}

