/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.proxy;

import java.lang.reflect.Array;

class HashUtil {
    static final int SEED = 23;
    private static final int ODD_PRIME_NUMBER = 37;

    HashUtil() {
    }

    static int hash(int seed, boolean bool) {
        return HashUtil.firstTerm(seed) + (bool ? 1 : 0);
    }

    static int hash(int seed, char c) {
        return HashUtil.firstTerm(seed) + c;
    }

    static int hash(int seed, int i) {
        return HashUtil.firstTerm(seed) + i;
    }

    static int hash(int seed, long l) {
        return HashUtil.firstTerm(seed) + (int)(l ^ l >>> 32);
    }

    static int hash(int seed, float f) {
        return HashUtil.hash(seed, Float.floatToIntBits(f));
    }

    static int hash(int seed, double d) {
        return HashUtil.hash(seed, Double.doubleToLongBits(d));
    }

    static int hash(int seed, Object obj) {
        int res = seed;
        if (obj == null) {
            res = HashUtil.hash(res, 0);
        } else if (!obj.getClass().isArray()) {
            res = HashUtil.hash(res, obj.hashCode());
        } else {
            int length = Array.getLength(obj);
            for (int idx = 0; idx < length; ++idx) {
                Object item = Array.get(obj, idx);
                res = HashUtil.hash(res, item);
            }
        }
        return res;
    }

    private static int firstTerm(int seed) {
        return 37 * seed;
    }
}

