/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.tuners.stats;

import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.tuners.stats.Histogram;
import oracle.ucp.tuners.stats.HistogramInsertionException;
import oracle.ucp.tuners.stats.HistogramRegistry;
import oracle.ucp.tuners.stats.RingRegistry;
import oracle.ucp.util.RingBuffer;
import oracle.ucp.util.Util;

public class HistogramRingRegistry
implements RingRegistry,
Diagnosable {
    static final String CLASS_NAME = HistogramRingRegistry.class.getName();
    private final long min;
    private final long max;
    private final long step;
    private final RingBuffer<HistogramRegistry> ringBuffer;
    private static final boolean enabled = Util.isSelfTunerEnabled();
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();

    public HistogramRingRegistry(int maxFrames, long min, long max, long step, Diagnosable diagnosticsCollector) {
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
        this.ringBuffer = new RingBuffer(maxFrames);
        this.min = min;
        this.max = max;
        this.step = step;
        this.turnRing();
    }

    public void insert(ConnectionRetrievalInfo cri, long time) {
        if (!enabled) {
            return;
        }
        try {
            this.ringBuffer.getAsList().get(0).getHistogram(cri).insert(Math.max(this.min, Math.min(this.max - 1L, time)));
        }
        catch (HistogramInsertionException e) {
            this.trace(Level.WARNING, CLASS_NAME, "insert", "", null, e, new Object[0]);
        }
    }

    @Override
    public void turnRing() {
        if (!enabled) {
            return;
        }
        this.ringBuffer.addItem(new HistogramRegistry(this.min, this.max, this.step));
    }

    @Override
    public HistogramRegistry collect() {
        HistogramRegistry collectedRegistry = new HistogramRegistry(this.min, this.max, this.step);
        List<HistogramRegistry> listRegistry = this.ringBuffer.getAsList();
        listRegistry.forEach(p -> this.collect(collectedRegistry, (HistogramRegistry)p));
        return collectedRegistry;
    }

    private void collect(HistogramRegistry collectedHreg, HistogramRegistry hreg) {
        hreg.forEach((cri, hist) -> this.collect(collectedHreg, (ConnectionRetrievalInfo)cri, (Histogram)hist));
    }

    private void collect(HistogramRegistry collectedHreg, ConnectionRetrievalInfo cri, Histogram hist) {
        collectedHreg.getHistogram(cri).add(hist);
    }

    @Override
    public HistogramRingRegistry merge(HistogramRingRegistry that) {
        HistogramRingRegistry reg = new HistogramRingRegistry(this.ringBuffer.getCapacity() + that.ringBuffer.getCapacity(), this.min, this.max, this.step, this.getDiagnosable());
        this.ringBuffer.getAsList().forEach(p -> reg.ringBuffer.addItem((HistogramRegistry)p));
        that.ringBuffer.getAsList().forEach(p -> reg.ringBuffer.addItem((HistogramRegistry)p));
        return reg;
    }

    @Override
    public HistogramRingRegistry merge(HistogramRegistry histReg) {
        HistogramRingRegistry reg = new HistogramRingRegistry(this.ringBuffer.getCapacity() + 1, this.min, this.max, this.step, this.getDiagnosable());
        this.ringBuffer.getAsList().forEach(p -> reg.ringBuffer.addItem((HistogramRegistry)p));
        reg.ringBuffer.addItem(histReg);
        return reg;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }
}

