/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Pattern;
import org.opensearch.common.Nullable;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.core.common.Strings;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;

public final class HierarchicalRoutingProcessor
extends AbstractProcessor {
    public static final String TYPE = "hierarchical_routing";
    private final String pathField;
    private final int anchorDepth;
    private final String pathSeparator;
    private final boolean ignoreMissing;
    private final boolean overrideExisting;
    private final Pattern pathSeparatorPattern;
    private final Pattern multiSeparatorPattern;

    HierarchicalRoutingProcessor(String tag, @Nullable String description, String pathField, int anchorDepth, String pathSeparator, boolean ignoreMissing, boolean overrideExisting) {
        super(tag, description);
        this.pathField = pathField;
        this.anchorDepth = anchorDepth;
        this.pathSeparator = pathSeparator;
        this.ignoreMissing = ignoreMissing;
        this.overrideExisting = overrideExisting;
        this.pathSeparatorPattern = Pattern.compile(Pattern.quote(pathSeparator));
        this.multiSeparatorPattern = Pattern.compile(Pattern.quote(pathSeparator) + "{2,}");
    }

    public IngestDocument execute(IngestDocument document) throws Exception {
        Object pathValue;
        if (!this.overrideExisting) {
            try {
                Object existingRouting = document.getFieldValue("_routing", Object.class, true);
                if (existingRouting != null) {
                    return document;
                }
            }
            catch (Exception existingRouting) {
                // empty catch block
            }
        }
        if ((pathValue = document.getFieldValue(this.pathField, Object.class, this.ignoreMissing)) == null && this.ignoreMissing) {
            return document;
        }
        if (pathValue == null) {
            throw new IllegalArgumentException("field [" + this.pathField + "] doesn't exist");
        }
        String path = pathValue.toString();
        if (Strings.isNullOrEmpty((String)path)) {
            if (this.ignoreMissing) {
                return document;
            }
            throw new IllegalArgumentException("field [" + this.pathField + "] is null or empty");
        }
        String routingValue = this.computeRoutingValue(path);
        document.setFieldValue("_routing", (Object)routingValue);
        return document;
    }

    private String computeRoutingValue(String path) {
        String normalizedPath = this.normalizePath(path);
        String[] segments = this.pathSeparatorPattern.split(normalizedPath);
        String anchor = this.extractAnchor(segments, this.anchorDepth);
        byte[] anchorBytes = anchor.getBytes(StandardCharsets.UTF_8);
        long hash = MurmurHash3.hash128((byte[])anchorBytes, (int)0, (int)anchorBytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128()).h1;
        return String.valueOf(hash == Long.MIN_VALUE ? 0L : (hash < 0L ? -hash : hash));
    }

    private String normalizePath(String path) {
        String normalized = path.trim();
        while (normalized.startsWith(this.pathSeparator)) {
            normalized = normalized.substring(this.pathSeparator.length());
        }
        while (normalized.endsWith(this.pathSeparator)) {
            normalized = normalized.substring(0, normalized.length() - this.pathSeparator.length());
        }
        normalized = this.multiSeparatorPattern.matcher(normalized).replaceAll(this.pathSeparator);
        return normalized;
    }

    private String extractAnchor(String[] segments, int depth) {
        StringBuilder anchor = new StringBuilder();
        int effectiveDepth = Math.min(depth, segments.length);
        int addedSegments = 0;
        for (int i = 0; i < effectiveDepth && addedSegments < depth; ++i) {
            if (Strings.isNullOrEmpty((String)segments[i])) continue;
            if (addedSegments > 0) {
                anchor.append(this.pathSeparator);
            }
            anchor.append(segments[i]);
            ++addedSegments;
        }
        if (anchor.length() == 0) {
            return "_root";
        }
        return anchor.toString();
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public HierarchicalRoutingProcessor create(Map<String, Processor.Factory> processorFactories, String tag, @Nullable String description, Map<String, Object> config) throws Exception {
            String pathField = ConfigurationUtils.readStringProperty((String)HierarchicalRoutingProcessor.TYPE, (String)tag, config, (String)"path_field");
            int anchorDepth = ConfigurationUtils.readIntProperty((String)HierarchicalRoutingProcessor.TYPE, (String)tag, config, (String)"anchor_depth", (Integer)2);
            String pathSeparator = ConfigurationUtils.readOptionalStringProperty((String)HierarchicalRoutingProcessor.TYPE, (String)tag, config, (String)"path_separator");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)HierarchicalRoutingProcessor.TYPE, (String)tag, config, (String)"ignore_missing", (boolean)false);
            boolean overrideExisting = ConfigurationUtils.readBooleanProperty((String)HierarchicalRoutingProcessor.TYPE, (String)tag, config, (String)"override_existing", (boolean)true);
            if (pathSeparator == null) {
                pathSeparator = "/";
            }
            if (anchorDepth <= 0) {
                throw ConfigurationUtils.newConfigurationException((String)HierarchicalRoutingProcessor.TYPE, (String)tag, (String)"anchor_depth", (String)"must be greater than 0");
            }
            if (Strings.isNullOrEmpty((String)pathSeparator)) {
                throw ConfigurationUtils.newConfigurationException((String)HierarchicalRoutingProcessor.TYPE, (String)tag, (String)"path_separator", (String)"cannot be null or empty");
            }
            if (Strings.isNullOrEmpty((String)pathField)) {
                throw ConfigurationUtils.newConfigurationException((String)HierarchicalRoutingProcessor.TYPE, (String)tag, (String)"path_field", (String)"cannot be null or empty");
            }
            return new HierarchicalRoutingProcessor(tag, description, pathField, anchorDepth, pathSeparator, ignoreMissing, overrideExisting);
        }
    }
}

