/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.calcite;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.SparkSqlDialect;

public class OpenSearchSparkSqlDialect
extends SparkSqlDialect {
    public static final OpenSearchSparkSqlDialect DEFAULT = new OpenSearchSparkSqlDialect();
    private static final Map<String, String> CALCITE_TO_SPARK_MAPPING = ImmutableMap.of((Object)"ARG_MIN", (Object)"MIN_BY", (Object)"ARG_MAX", (Object)"MAX_BY", (Object)"SAFE_CAST", (Object)"TRY_CAST");
    private static final Map<String, String> CALL_SEPARATOR = ImmutableMap.of((Object)"SAFE_CAST", (Object)"AS");

    private OpenSearchSparkSqlDialect() {
        super(DEFAULT_CONTEXT);
    }

    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        String operatorName = call.getOperator().getName();
        if (CALCITE_TO_SPARK_MAPPING.containsKey(operatorName)) {
            this.unparseFunction(writer, call, CALCITE_TO_SPARK_MAPPING.get(operatorName), leftPrec, rightPrec, CALL_SEPARATOR.getOrDefault(operatorName, ","));
        } else {
            super.unparseCall(writer, call, leftPrec, rightPrec);
        }
    }

    private void unparseFunction(SqlWriter writer, SqlCall call, String functionName, int leftPrec, int rightPrec, String separator) {
        writer.print(functionName);
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (int i = 0; i < call.operandCount(); ++i) {
            if (i > 0) {
                writer.sep(separator);
            }
            call.operand(i).unparse(writer, 0, rightPrec);
        }
        writer.endList(frame);
    }
}

