/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

public abstract class IOSpliterator<T>
implements Spliterator<T> {
    public static final int DEFAULT_BATCH_SIZE = 256;
    public static final int DEFAULT_CHARACTERISTICS = 1296;
    private final int characteristics;
    private final int batchSize;
    private long estimatedSize;

    public IOSpliterator(int characteristics, int batchSize, long estimatedSize) {
        this.characteristics = characteristics | 0x4000;
        this.batchSize = batchSize;
        this.estimatedSize = estimatedSize;
    }

    public IOSpliterator(int characteristics, long estimatedSize) {
        this(characteristics, 256, estimatedSize);
    }

    public IOSpliterator(int characteristics) {
        this(characteristics, 256, Long.MAX_VALUE);
    }

    public IOSpliterator() {
        this(1296);
    }

    @Override
    public Spliterator<T> trySplit() {
        BufferConsumer holder = new BufferConsumer();
        if (!this.tryAdvance(holder)) {
            return null;
        }
        Object[] a = new Object[this.batchSize];
        int j = 0;
        do {
            a[j] = holder.value;
        } while (++j < this.batchSize && this.tryAdvance(holder));
        if (this.estimatedSize != Long.MAX_VALUE) {
            this.estimatedSize -= (long)j;
        }
        return Spliterators.spliterator(a, 0, j, this.characteristics() | 0x40);
    }

    @Override
    public long estimateSize() {
        return this.estimatedSize;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    static final class BufferConsumer<T>
    implements Consumer<T> {
        T value;

        BufferConsumer() {
        }

        @Override
        public void accept(T value) {
            this.value = value;
        }
    }
}

