/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PatternAnalyzer
implements AnalyzerVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, PatternAnalyzer> {
    @Nullable
    private final String flags;
    @Nullable
    private final Boolean lowercase;
    @Nonnull
    private final String pattern;
    @Nonnull
    private final List<String> stopwords;
    @Nullable
    private final String version;
    public static final JsonpDeserializer<PatternAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternAnalyzer::setupPatternAnalyzerDeserializer);

    private PatternAnalyzer(Builder builder) {
        this.flags = builder.flags;
        this.lowercase = builder.lowercase;
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
        this.stopwords = ApiTypeHelper.unmodifiable(builder.stopwords);
        this.version = builder.version;
    }

    public static PatternAnalyzer of(Function<Builder, ObjectBuilder<PatternAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Pattern;
    }

    @Nullable
    public final String flags() {
        return this.flags;
    }

    @Nullable
    public final Boolean lowercase() {
        return this.lowercase;
    }

    @Nonnull
    public final String pattern() {
        return this.pattern;
    }

    @Nonnull
    public final List<String> stopwords() {
        return this.stopwords;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern");
        if (this.flags != null) {
            generator.writeKey("flags");
            generator.write(this.flags);
        }
        if (this.lowercase != null) {
            generator.writeKey("lowercase");
            generator.write(this.lowercase.booleanValue());
        }
        generator.writeKey("pattern");
        generator.write(this.pattern);
        if (ApiTypeHelper.isDefined(this.stopwords)) {
            generator.writeKey("stopwords");
            generator.writeStartArray();
            for (String item0 : this.stopwords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPatternAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags");
        op.add(Builder::lowercase, JsonpDeserializer.booleanDeserializer(), "lowercase");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.ignore("type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.flags);
        result = 31 * result + Objects.hashCode(this.lowercase);
        result = 31 * result + this.pattern.hashCode();
        result = 31 * result + Objects.hashCode(this.stopwords);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternAnalyzer other = (PatternAnalyzer)o;
        return Objects.equals(this.flags, other.flags) && Objects.equals(this.lowercase, other.lowercase) && this.pattern.equals(other.pattern) && Objects.equals(this.stopwords, other.stopwords) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, PatternAnalyzer> {
        @Nullable
        private String flags;
        @Nullable
        private Boolean lowercase;
        private String pattern;
        @Nullable
        private List<String> stopwords;
        @Nullable
        private String version;

        public Builder() {
        }

        private Builder(PatternAnalyzer o) {
            this.flags = o.flags;
            this.lowercase = o.lowercase;
            this.pattern = o.pattern;
            this.stopwords = Builder._listCopy(o.stopwords);
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.flags = o.flags;
            this.lowercase = o.lowercase;
            this.pattern = o.pattern;
            this.stopwords = Builder._listCopy(o.stopwords);
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder flags(@Nullable String value) {
            this.flags = value;
            return this;
        }

        @Nonnull
        public final Builder lowercase(@Nullable Boolean value) {
            this.lowercase = value;
            return this;
        }

        @Nonnull
        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        @Nonnull
        public final Builder stopwords(List<String> list) {
            this.stopwords = Builder._listAddAll(this.stopwords, list);
            return this;
        }

        @Nonnull
        public final Builder stopwords(String value, String ... values) {
            this.stopwords = Builder._listAdd(this.stopwords, value, values);
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public PatternAnalyzer build() {
            this._checkSingleUse();
            return new PatternAnalyzer(this);
        }
    }
}

