/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.opensearch.ism.RefreshSearchAnalyzersResponseDetails;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RefreshSearchAnalyzersResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RefreshSearchAnalyzersResponse> {
    @Nullable
    private final ShardStatistics shards;
    @Nonnull
    private final List<RefreshSearchAnalyzersResponseDetails> successfulRefreshDetails;
    public static final JsonpDeserializer<RefreshSearchAnalyzersResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RefreshSearchAnalyzersResponse::setupRefreshSearchAnalyzersResponseDeserializer);

    private RefreshSearchAnalyzersResponse(Builder builder) {
        this.shards = builder.shards;
        this.successfulRefreshDetails = ApiTypeHelper.unmodifiable(builder.successfulRefreshDetails);
    }

    public static RefreshSearchAnalyzersResponse of(Function<Builder, ObjectBuilder<RefreshSearchAnalyzersResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Nonnull
    public final List<RefreshSearchAnalyzersResponseDetails> successfulRefreshDetails() {
        return this.successfulRefreshDetails;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.shards != null) {
            generator.writeKey("_shards");
            this.shards.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.successfulRefreshDetails)) {
            generator.writeKey("successful_refresh_details");
            generator.writeStartArray();
            for (RefreshSearchAnalyzersResponseDetails item0 : this.successfulRefreshDetails) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRefreshSearchAnalyzersResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::successfulRefreshDetails, JsonpDeserializer.arrayDeserializer(RefreshSearchAnalyzersResponseDetails._DESERIALIZER), "successful_refresh_details");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.shards);
        result = 31 * result + Objects.hashCode(this.successfulRefreshDetails);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefreshSearchAnalyzersResponse other = (RefreshSearchAnalyzersResponse)o;
        return Objects.equals(this.shards, other.shards) && Objects.equals(this.successfulRefreshDetails, other.successfulRefreshDetails);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RefreshSearchAnalyzersResponse> {
        @Nullable
        private ShardStatistics shards;
        @Nullable
        private List<RefreshSearchAnalyzersResponseDetails> successfulRefreshDetails;

        public Builder() {
        }

        private Builder(RefreshSearchAnalyzersResponse o) {
            this.shards = o.shards;
            this.successfulRefreshDetails = Builder._listCopy(o.successfulRefreshDetails);
        }

        private Builder(Builder o) {
            this.shards = o.shards;
            this.successfulRefreshDetails = Builder._listCopy(o.successfulRefreshDetails);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return this;
        }

        @Nonnull
        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Nonnull
        public final Builder successfulRefreshDetails(List<RefreshSearchAnalyzersResponseDetails> list) {
            this.successfulRefreshDetails = Builder._listAddAll(this.successfulRefreshDetails, list);
            return this;
        }

        @Nonnull
        public final Builder successfulRefreshDetails(RefreshSearchAnalyzersResponseDetails value, RefreshSearchAnalyzersResponseDetails ... values) {
            this.successfulRefreshDetails = Builder._listAdd(this.successfulRefreshDetails, value, values);
            return this;
        }

        @Nonnull
        public final Builder successfulRefreshDetails(Function<RefreshSearchAnalyzersResponseDetails.Builder, ObjectBuilder<RefreshSearchAnalyzersResponseDetails>> fn) {
            return this.successfulRefreshDetails(fn.apply(new RefreshSearchAnalyzersResponseDetails.Builder()).build(), new RefreshSearchAnalyzersResponseDetails[0]);
        }

        @Override
        @Nonnull
        public RefreshSearchAnalyzersResponse build() {
            this._checkSingleUse();
            return new RefreshSearchAnalyzersResponse(this);
        }
    }
}

