/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.security.NoSuchAlgorithmException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.codec.StringDigester;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;

public class EntityIDDigestGenerator
implements Function<CriteriaSet, String> {
    @Nonnull
    private StringDigester digester;
    @Nullable
    private String prefix;
    @Nullable
    private String suffix;
    @Nullable
    private String separator;

    public EntityIDDigestGenerator() {
        this(null, null, null, null);
    }

    public EntityIDDigestGenerator(@Nullable StringDigester valueDigester, @Nullable String keyPrefix, @Nullable String keySuffix, @Nullable String valueSeparator) {
        this.prefix = StringSupport.trimOrNull(keyPrefix);
        this.suffix = StringSupport.trimOrNull(keySuffix);
        this.separator = StringSupport.trimOrNull(valueSeparator);
        if (valueDigester != null) {
            this.digester = valueDigester;
        } else {
            try {
                this.digester = new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("No SHA-1 support in runtime");
            }
        }
    }

    @Override
    @Nullable
    public String apply(@Nullable CriteriaSet criteria) {
        EntityIdCriterion criterion;
        EntityIdCriterion entityIdCriterion = criterion = criteria != null ? criteria.get(EntityIdCriterion.class) : null;
        if (criterion == null) {
            return null;
        }
        String digested = this.digester.apply(criterion.getEntityId());
        if (digested != null) {
            return this.buildKey(digested);
        }
        return null;
    }

    protected String buildKey(@Nonnull String keyValue) {
        if (this.prefix == null && this.suffix == null) {
            return keyValue;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.prefix != null) {
            buffer.append(this.prefix);
            if (this.separator != null) {
                buffer.append(this.separator);
            }
        }
        buffer.append(keyValue);
        if (this.suffix != null) {
            if (this.separator != null) {
                buffer.append(this.separator);
            }
            buffer.append(this.suffix);
        }
        return buffer.toString();
    }
}

