/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.user.AuthCredentials;

public class HTTPHelper {
    public static AuthCredentials extractCredentials(String authorizationHeader, Logger log) {
        if (authorizationHeader != null) {
            if (!authorizationHeader.trim().toLowerCase().startsWith("basic ")) {
                return null;
            }
            String decodedBasicHeader = new String(Base64.getDecoder().decode(authorizationHeader.split(" ")[1]), StandardCharsets.UTF_8);
            int firstColonIndex = decodedBasicHeader.indexOf(58);
            String username = null;
            String password = null;
            if (firstColonIndex > 0) {
                username = decodedBasicHeader.substring(0, firstColonIndex);
                password = decodedBasicHeader.length() - 1 != firstColonIndex ? decodedBasicHeader.substring(firstColonIndex + 1) : "";
            }
            if (username == null || password == null) {
                log.warn("Invalid 'Authorization' header for HTTP Basic auth");
                return null;
            }
            return new AuthCredentials(username, password.getBytes(StandardCharsets.UTF_8)).markComplete();
        }
        return null;
    }

    public static boolean containsBadHeader(SecurityRequest request) {
        Map<String, List<String>> headers;
        if (request != null && (headers = request.getHeaders()) != null) {
            for (String key : headers.keySet()) {
                if (key == null || !key.trim().toLowerCase().startsWith("_opendistro_security_".toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }
}

