/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.CodecsTruffleModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextAbstractBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextUnicodeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.codecs.ErrorHandlers;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.UnicodeObjectNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.str.NativeCharSequence;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.lib.PyTupleGetItem;
import com.oracle.graal.python.lib.PyUnicodeCheckExactNode;
import com.oracle.graal.python.lib.PyUnicodeFSDecoderNode;
import com.oracle.graal.python.lib.PyUnicodeFromEncodedObject;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class PythonCextUnicodeBuiltins {
    static TruffleString convertEncoding(Object obj) {
        return obj == PNone.NO_VALUE ? StringLiterals.T_UTF8 : (TruffleString)obj;
    }

    static TruffleString convertErrors(Object obj) {
        return obj == PNone.NO_VALUE ? StringLiterals.T_STRICT : (TruffleString)obj;
    }

    static boolean isStringSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
        return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PString);
    }

    static boolean isAnyString(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
        return PGuards.isString(obj) || PythonCextUnicodeBuiltins.isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode);
    }

    static abstract class PyUnicode_Count
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyUnicode_Count() {
        }

        @Specialization
        long count(Object string, Object sub, long start, long end, @Cached StringBuiltins.CountNode countNode) {
            return countNode.execute(string, sub, CastToJavaIntLossyNode.castLong(start), CastToJavaIntLossyNode.castLong(end));
        }
    }

    static abstract class GraalPyPrivate_PyUnicode_Find
    extends PythonCextBuiltins.CApi5BuiltinNode {
        GraalPyPrivate_PyUnicode_Find() {
        }

        @Specialization(guards={"direction > 0"})
        long find(Object string, Object sub, long start, long end, int direction, @Cached StringBuiltins.FindNode findNode) {
            return GraalPyPrivate_PyUnicode_Find.convertResult(findNode.execute(string, sub, CastToJavaIntLossyNode.castLong(start), CastToJavaIntLossyNode.castLong(end)));
        }

        @Specialization(guards={"direction <= 0"})
        long find(Object string, Object sub, long start, long end, int direction, @Cached StringBuiltins.RFindNode rFindNode) {
            return GraalPyPrivate_PyUnicode_Find.convertResult(rFindNode.execute(string, sub, CastToJavaIntLossyNode.castLong(start), CastToJavaIntLossyNode.castLong(end)));
        }

        private static int convertResult(int result) {
            return result >= 0 ? result : -2;
        }
    }

    static abstract class PyUnicodeDecodeError_Create
    extends PythonCextBuiltins.CApi6BuiltinNode {
        PyUnicodeDecodeError_Create() {
        }

        @Specialization
        static Object doit(Object encoding, Object object, long length, long start, long end, Object reason, @Bind Node inliningTarget, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached CallNode callNode, @Cached PRaiseNode raiseNode) {
            PBytes bytes;
            try {
                bytes = PFactory.createBytes(PythonLanguage.get(inliningTarget), getByteArrayNode.execute(inliningTarget, object, length));
            }
            catch (InteropException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.NEGATIVE_SIZE_PASSED);
            }
            return callNode.executeWithoutFrame((Object)PythonBuiltinClassType.UnicodeDecodeError, encoding, bytes, start, end, reason);
        }
    }

    static abstract class _Py_GetErrorHandler
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        _Py_GetErrorHandler() {
        }

        @Specialization
        static Object doGeneric(TruffleString errors, @Bind Node inliningTarget, @Cached ErrorHandlers.GetErrorHandlerNode getErrorHandlerNode) {
            return getErrorHandlerNode.execute(inliningTarget, errors).getNativeValue();
        }

        @Specialization
        static Object doNull(PNone noValue) {
            return ErrorHandlers.ErrorHandler.STRICT.getNativeValue();
        }
    }

    static abstract class GraalPyPrivate_Unicode_FromFormat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Unicode_FromFormat() {
        }

        @Specialization
        static Object doGeneric(TruffleString format, Object vaList, @Bind Node inliningTarget, @Cached CExtNodes.UnicodeFromFormatNode unicodeFromFormatNode) {
            return unicodeFromFormatNode.execute(inliningTarget, format, vaList);
        }
    }

    static abstract class GraalPyPrivate_Unicode_AsWideChar
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Unicode_AsWideChar() {
        }

        @Specialization
        static Object doUnicode(Object s, int elementSize, @Bind Node inliningTarget, @Cached UnicodeObjectNodes.UnicodeAsWideCharNode asWideCharNode, @Cached CastToTruffleStringNode castStr, @Cached PRaiseNode raiseNode) {
            try {
                PBytes wchars = asWideCharNode.executeLittleEndian(inliningTarget, castStr.execute(inliningTarget, s), elementSize);
                if (wchars != null) {
                    return wchars;
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.UNSUPPORTED_SIZE_WAS, "wchar", elementSize);
            }
            catch (IllegalArgumentException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.LookupError, ErrorMessages.M, e);
            }
        }
    }

    static abstract class GraalPyPrivate_Unicode_FillUnicode
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Unicode_FillUnicode() {
        }

        @Specialization
        static Object doNative(PythonAbstractNativeObject s, @Bind Node inliningTarget, @Cached CastToTruffleStringNode cast, @Cached UnicodeObjectNodes.UnicodeAsWideCharNode asWideCharNode, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached CStructAccess.AllocateNode allocateNode, @Cached CStructAccess.WriteByteNode writeByteNode) {
            int wcharSize = CStructs.wchar_t.size();
            PBytes bytes = asWideCharNode.executeNativeOrder(inliningTarget, cast.castKnownString(inliningTarget, s), wcharSize);
            int len = bufferLib.getBufferLength(bytes);
            Object mem = allocateNode.alloc(len + wcharSize, true);
            writeByteNode.writeByteArray(mem, bufferLib.getInternalOrCopiedByteArray(bytes), len, 0, 0);
            return 0;
        }
    }

    static abstract class GraalPyPrivate_Unicode_IsMaterialized
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Unicode_IsMaterialized() {
        }

        @Specialization
        static int pstring(PString s) {
            if (s.isNativeCharSequence()) {
                return s.isNativeMaterialized() ? 1 : 0;
            }
            return s.isMaterialized() ? 1 : 0;
        }

        @Fallback
        static Object other(Object s) {
            return 1;
        }
    }

    static abstract class GraalPyPrivate_Unicode_AsUnicodeAndSize
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Unicode_AsUnicodeAndSize() {
        }

        @Specialization
        static Object doUnicode(PString s, Object sizePtr, @Bind Node inliningTarget, @CachedLibrary(limit="2") InteropLibrary lib, @Cached InlinedConditionProfile hasSizeProfile, @Cached InlinedConditionProfile hasUnicodeProfile, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached UnicodeObjectNodes.UnicodeAsWideCharNode asWideCharNode) {
            int wcharSize = CStructs.wchar_t.size();
            if (hasUnicodeProfile.profile(inliningTarget, s.getWCharBytes() == null)) {
                PBytes bytes = asWideCharNode.executeNativeOrder(inliningTarget, s, wcharSize);
                s.setWCharBytes(bytes);
            }
            if (hasSizeProfile.profile(inliningTarget, !lib.isNull(sizePtr))) {
                writeLongNode.write(sizePtr, s.getWCharBytes().getSequenceStorage().length() / wcharSize);
            }
            return PySequenceArrayWrapper.ensureNativeSequence(s.getWCharBytes());
        }

        @Fallback
        static Object doError(Object s, Object sizePtr, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    static abstract class GraalPyPrivate_Unicode_FillUtf8
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Unicode_FillUtf8() {
        }

        @Specialization
        static Object doNative(PythonAbstractNativeObject s, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached _PyUnicode_AsUTF8String asUTF8String, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached CStructAccess.AllocateNode allocateNode, @Cached CStructAccess.WriteByteNode writeByteNode) {
            PBytes bytes = (PBytes)asUTF8String.execute(s, StringLiterals.T_STRICT);
            int len = bufferLib.getBufferLength(bytes);
            Object mem = allocateNode.alloc(len + 1, true);
            writeByteNode.writeByteArray(mem, bufferLib.getInternalOrCopiedByteArray(bytes), len, 0, 0);
            writePointerNode.writeToObj(s, CFields.PyCompactUnicodeObject__utf8, mem);
            writeLongNode.writeToObject(s, CFields.PyCompactUnicodeObject__utf8_length, len);
            return 0;
        }
    }

    static abstract class GraalPyPrivate_Unicode_AsUTF8AndSize
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Unicode_AsUTF8AndSize() {
        }

        @Specialization
        static Object doUnicode(PString s, Object sizePtr, @Bind Node inliningTarget, @CachedLibrary(limit="2") InteropLibrary lib, @Cached InlinedConditionProfile hasSizeProfile, @Cached InlinedConditionProfile hasUtf8Profile, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached _PyUnicode_AsUTF8String asUTF8String) {
            if (hasUtf8Profile.profile(inliningTarget, s.getUtf8Bytes() == null)) {
                PBytes bytes = (PBytes)asUTF8String.execute(s, StringLiterals.T_STRICT);
                s.setUtf8Bytes(bytes);
            }
            if (hasSizeProfile.profile(inliningTarget, !lib.isNull(sizePtr))) {
                writeLongNode.write(sizePtr, s.getUtf8Bytes().getSequenceStorage().length());
            }
            return PySequenceArrayWrapper.ensureNativeSequence(s.getUtf8Bytes());
        }

        @Fallback
        static Object doError(Object s, Object sizePtr, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    static abstract class _PyUnicode_AsUTF8String
    extends NativeEncoderNode {
        protected _PyUnicode_AsUTF8String() {
            super(StandardCharsets.UTF_8);
        }

        @NeverDefault
        public static _PyUnicode_AsUTF8String create() {
            return PythonCextUnicodeBuiltinsFactory._PyUnicode_AsUTF8StringNodeGen.create();
        }
    }

    static abstract class _PyUnicode_AsASCIIString
    extends NativeEncoderNode {
        protected _PyUnicode_AsASCIIString() {
            super(StandardCharsets.US_ASCII);
        }
    }

    static abstract class _PyUnicode_AsLatin1String
    extends NativeEncoderNode {
        protected _PyUnicode_AsLatin1String() {
            super(StandardCharsets.ISO_8859_1);
        }
    }

    static abstract class NativeEncoderNode
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        private final Charset charset;

        protected NativeEncoderNode(Charset charset) {
            this.charset = charset;
        }

        @Specialization(guards={"isNoValue(errors)"})
        Object doUnicode(Object s, PNone errors, @Cached.Shared(value="encodeNode") @Cached CExtCommonNodes.EncodeNativeStringNode encodeNativeStringNode) {
            return this.doUnicode(s, StringLiterals.T_STRICT, encodeNativeStringNode);
        }

        @Specialization
        Object doUnicode(Object s, TruffleString errors, @Cached.Shared(value="encodeNode") @Cached CExtCommonNodes.EncodeNativeStringNode encodeNativeStringNode) {
            return PFactory.createBytes(PythonLanguage.get(this), encodeNativeStringNode.execute(this.charset, s, errors));
        }

        @Fallback
        static Object doUnicode(Object s, Object errors, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    static abstract class PyUnicode_FromWideChar
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_FromWideChar() {
        }

        @Specialization
        Object doInt(Object arr, long size, @Bind Node inliningTarget, @Cached CExtCommonNodes.ReadUnicodeArrayNode readArray, @Cached TruffleString.FromIntArrayUTF32Node fromArray) {
            assert (PythonUtils.TS_ENCODING == TruffleString.Encoding.UTF_32) : "needs switch_encoding otherwise";
            return PFactory.createString(PythonLanguage.get(inliningTarget), fromArray.execute(readArray.execute(inliningTarget, arr, this.castToInt(size), CStructs.wchar_t.size())));
        }
    }

    static abstract class PyUnicode_EncodeLocale
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_EncodeLocale() {
        }

        @Specialization
        static Object encode(Object s, Object errors, @Bind Node inliningTarget, @Cached CastToTruffleStringNode cast, @Cached CodecsTruffleModuleBuiltins.GetEncodingNode getEncodingNode, @Cached CodecsModuleBuiltins.EncodeNode encodeNode) {
            return encodeNode.execute(null, cast.execute(inliningTarget, s), getEncodingNode.execute(null), errors);
        }
    }

    static abstract class PyUnicode_EncodeFSDefault
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_EncodeFSDefault() {
        }

        @Specialization
        static PBytes fromObject(Object s, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castStr, @Cached CExtCommonNodes.EncodeNativeStringNode encode) {
            byte[] array = encode.execute(StandardCharsets.UTF_8, castStr.execute(inliningTarget, s), StringLiterals.T_REPLACE);
            return PFactory.createBytes(PythonLanguage.get(inliningTarget), array);
        }
    }

    static abstract class GraalPyPrivate_Unicode_Decode
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        GraalPyPrivate_Unicode_Decode() {
        }

        @Specialization
        static Object doDecode(PMemoryView mv, TruffleString encoding, TruffleString errors, @Cached CodecsModuleBuiltins.DecodeNode decodeNode) {
            return decodeNode.executeWithStrings(null, mv, encoding, errors);
        }
    }

    static abstract class GraalPyPrivate_Unicode_DecodeUTF32Stateful
    extends PythonCextBuiltins.CApi5BuiltinNode {
        GraalPyPrivate_Unicode_DecodeUTF32Stateful() {
        }

        @Specialization
        static Object decode(Object cByteArray, long size, TruffleString errors, int byteorder, int reportConsumed, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached CodecsModuleBuiltins.CodecsDecodeNode decode, @Cached PRaiseNode raiseNode) {
            try {
                PBytes bytes = PFactory.createBytes(language, getByteArrayNode.execute(inliningTarget, cByteArray, size));
                TruffleString encoding = byteorder == 0 ? CodecsModuleBuiltins.T_UTF_32 : (byteorder < 0 ? CodecsModuleBuiltins.T_UTF_32_LE : CodecsModuleBuiltins.T_UTF_32_BE);
                return decode.call(null, bytes, encoding, errors, reportConsumed == 0);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.INPUT_TOO_LONG);
            }
            catch (InteropException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
        }
    }

    static abstract class GraalPyPrivate_Unicode_DecodeUTF16Stateful
    extends PythonCextBuiltins.CApi5BuiltinNode {
        GraalPyPrivate_Unicode_DecodeUTF16Stateful() {
        }

        @Specialization
        static Object decode(Object cByteArray, long size, TruffleString errors, int byteorder, int reportConsumed, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached CodecsModuleBuiltins.CodecsDecodeNode decode, @Cached PRaiseNode raiseNode) {
            try {
                PBytes bytes = PFactory.createBytes(language, getByteArrayNode.execute(inliningTarget, cByteArray, size));
                TruffleString encoding = byteorder == 0 ? CodecsModuleBuiltins.T_UTF_16 : (byteorder < 0 ? CodecsModuleBuiltins.T_UTF_16_LE : CodecsModuleBuiltins.T_UTF_16_BE);
                return decode.call(null, bytes, encoding, errors, reportConsumed == 0);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.INPUT_TOO_LONG);
            }
            catch (InteropException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
        }
    }

    static abstract class GraalPyPrivate_Unicode_DecodeUTF8Stateful
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        GraalPyPrivate_Unicode_DecodeUTF8Stateful() {
        }

        @Specialization
        static Object doUtf8Decode(Object cByteArray, long size, TruffleString errors, int reportConsumed, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached CodecsModuleBuiltins.CodecsDecodeNode decode, @Cached PRaiseNode raiseNode) {
            try {
                PBytes bytes = PFactory.createBytes(language, getByteArrayNode.execute(inliningTarget, cByteArray, size));
                return decode.call(null, bytes, StringLiterals.T_UTF8, errors, reportConsumed == 0);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.INPUT_TOO_LONG);
            }
            catch (InteropException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
        }
    }

    static abstract class PyUnicode_Split
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_Split() {
        }

        @Specialization
        static Object split(Object string, Object sep, Object maxsplit, @Cached StringBuiltins.SplitNode splitNode) {
            return splitNode.execute(null, string, sep, maxsplit);
        }
    }

    static abstract class PyUnicode_Contains
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Contains() {
        }

        @Specialization
        static int contains(Object haystack, Object needle, @Cached StringBuiltins.ContainsNode containsNode) {
            return containsNode.executeBool(haystack, needle) ? 1 : 0;
        }
    }

    static abstract class PyUnicode_FromString
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_FromString() {
        }

        @Specialization
        static PString run(TruffleString str, @Bind PythonLanguage language) {
            return PFactory.createString(language, str);
        }

        @Specialization
        static PString run(PString str) {
            return str;
        }
    }

    static abstract class GraalPyPrivate_Unicode_FromUTF
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        GraalPyPrivate_Unicode_FromUTF() {
        }

        private static TruffleString.Encoding encodingFromKind(Node inliningTarget, int kind, PRaiseNode raiseNode) throws PException {
            return switch (kind) {
                case 1 -> TruffleString.Encoding.UTF_8;
                case 2 -> TruffleString.Encoding.UTF_16LE;
                case 4 -> TruffleString.Encoding.UTF_32LE;
                default -> throw raiseNode.raiseBadInternalCall(inliningTarget);
            };
        }

        @Specialization(guards={"ptrLib.isPointer(ptr)"})
        static Object doNative(Object ptr, long byteLength, int kind, @Bind Node inliningTarget, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached TruffleString.FromNativePointerNode fromNativePointerNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                int iByteLength = PInt.intValueExact(byteLength);
                TruffleString.Encoding srcEncoding = GraalPyPrivate_Unicode_FromUTF.encodingFromKind(inliningTarget, kind, raiseNode);
                TruffleString ts = fromNativePointerNode.execute(ptr, 0, iByteLength, srcEncoding, true);
                return PFactory.createString(PythonLanguage.get(inliningTarget), switchEncodingNode.execute((AbstractTruffleString)ts, PythonUtils.TS_ENCODING));
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }

        @Specialization(guards={"!ptrLib.isPointer(ptr)"})
        static Object doManaged(Object ptr, long byteLength, int kind, @Bind Node inliningTarget, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                TruffleString.Encoding srcEncoding = GraalPyPrivate_Unicode_FromUTF.encodingFromKind(inliningTarget, kind, raiseNode);
                byte[] ucsBytes = getByteArrayNode.execute(inliningTarget, ptr, byteLength);
                TruffleString ts = fromByteArrayNode.execute(ucsBytes, srcEncoding);
                return PFactory.createString(PythonLanguage.get(inliningTarget), switchEncodingNode.execute((AbstractTruffleString)ts, PythonUtils.TS_ENCODING));
            }
            catch (InteropException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }
    }

    static abstract class GraalPyPrivate_Unicode_FSDecoder
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Unicode_FSDecoder() {
        }

        @Specialization
        static Object fsDecoder(Object arg, @Cached PyUnicodeFSDecoderNode fsDecoderNode) {
            return fsDecoderNode.execute(null, arg);
        }
    }

    static abstract class GraalPyPrivate_Unicode_FromUCS
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        GraalPyPrivate_Unicode_FromUCS() {
        }

        private static TruffleString.Encoding encodingFromKind(Node inliningTarget, int kind, PRaiseNode raiseNode) throws PException {
            return switch (kind) {
                case 1 -> TruffleString.Encoding.ISO_8859_1;
                case 2 -> TruffleString.Encoding.UTF_16;
                case 4 -> PythonUtils.TS_ENCODING;
                default -> throw raiseNode.raiseBadInternalCall(inliningTarget);
            };
        }

        @Specialization(guards={"ptrLib.isPointer(ptr)"})
        static Object doNative(Object ptr, long byteLength, int kind, @Bind Node inliningTarget, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached TruffleString.FromNativePointerNode fromNativePointerNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                int iByteLength = PInt.intValueExact(byteLength);
                TruffleString.Encoding srcEncoding = GraalPyPrivate_Unicode_FromUCS.encodingFromKind(inliningTarget, kind, raiseNode);
                TruffleString ts = fromNativePointerNode.execute(ptr, 0, iByteLength, srcEncoding, true);
                return PFactory.createString(PythonLanguage.get(inliningTarget), switchEncodingNode.execute((AbstractTruffleString)ts, PythonUtils.TS_ENCODING));
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }

        @Specialization(guards={"!ptrLib.isPointer(ptr)"})
        static Object doManaged(Object ptr, long byteLength, int kind, @Bind Node inliningTarget, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                TruffleString.Encoding srcEncoding = GraalPyPrivate_Unicode_FromUCS.encodingFromKind(inliningTarget, kind, raiseNode);
                byte[] ucsBytes = getByteArrayNode.execute(inliningTarget, ptr, byteLength);
                TruffleString ts = fromByteArrayNode.execute(ucsBytes, srcEncoding);
                return PFactory.createString(PythonLanguage.get(inliningTarget), switchEncodingNode.execute((AbstractTruffleString)ts, PythonUtils.TS_ENCODING));
            }
            catch (InteropException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }
    }

    static abstract class GraalPyPrivate_Unicode_New
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        GraalPyPrivate_Unicode_New() {
        }

        @Specialization
        static Object doGeneric(Object ptr, long elements, long elementSize, int isAscii, @Bind PythonLanguage language) {
            return PFactory.createString(language, new NativeCharSequence(ptr, (int)elements, (int)elementSize, isAscii != 0));
        }
    }

    static abstract class PyUnicode_ReadChar
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_ReadChar() {
        }

        @Specialization
        static int doGeneric(Object type, long lindex, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached TruffleString.CodePointLengthNode lengthNode, @Cached TruffleString.CodePointAtIndexNode codepointAtIndexNode, @Cached PRaiseNode raiseNode) {
            try {
                TruffleString s = castToStringNode.execute(inliningTarget, type);
                int index = PInt.intValueExact(lindex);
                if (index < 0 || index >= lengthNode.execute((AbstractTruffleString)s, PythonUtils.TS_ENCODING)) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.STRING_INDEX_OUT_OF_RANGE);
                }
                return codepointAtIndexNode.execute((AbstractTruffleString)s, index, PythonUtils.TS_ENCODING);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.STRING_INDEX_OUT_OF_RANGE);
            }
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_AsUnicodeEscapeString
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_AsUnicodeEscapeString() {
        }

        @Specialization(guards={"isString(s)"})
        static Object escape(Object s, @Bind Node inliningTarget, @Cached.Shared @Cached CodecsModuleBuiltins.CodecsEncodeNode encodeNode, @Cached.Shared @Cached PyTupleGetItem getItemNode) {
            return getItemNode.execute(inliningTarget, encodeNode.execute(null, s, CodecsModuleBuiltins.T_UNICODE_ESCAPE, PNone.NO_VALUE), 0);
        }

        @Specialization(guards={"!isString(s)", "isStringSubtype(inliningTarget, s, getClassNode, isSubtypeNode)"})
        static Object escape(Object s, @Bind Node inliningTarget, @Cached.Shared @Cached CodecsModuleBuiltins.CodecsEncodeNode encodeNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached.Shared @Cached PyTupleGetItem getItemNode) {
            return PyUnicode_AsUnicodeEscapeString.escape(s, inliningTarget, encodeNode, getItemNode);
        }

        @Specialization(guards={"!isString(obj)", "!isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object escape(Object obj, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    @TypeSystemReference(value=PythonIntegerTypes.class)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class _PyUnicode_JoinArray
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        _PyUnicode_JoinArray() {
        }

        @Specialization
        static Object join(Object separatorObj, Object itemsObj, long seqlenlong, @Bind Node inliningTarget, @Cached CStructAccess.ReadObjectNode readNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached CastToTruffleStringNode toTruffleStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            if (seqlenlong == 0L) {
                return StringLiterals.T_EMPTY_STRING;
            }
            TruffleString separator = StringLiterals.T_SPACE;
            if (separatorObj != PNone.NO_VALUE) {
                if (PGuards.isString(separatorObj)) {
                    separator = toTruffleStringNode.execute(inliningTarget, separatorObj);
                } else {
                    throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.SEPARATOR_EXPECTED_STR_INSTANCE_P_FOUND, separatorObj);
                }
            }
            int seqlen = (int)seqlenlong;
            assert ((long)seqlen == seqlenlong);
            Object[] items = readNode.readPyObjectArray(itemsObj, seqlen);
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            for (int i = 0; i < items.length; ++i) {
                TruffleString item = toTruffleStringNode.execute(inliningTarget, items[i]);
                if (i != 0) {
                    appendStringNode.execute(sb, (AbstractTruffleString)separator);
                }
                appendStringNode.execute(sb, (AbstractTruffleString)item);
            }
            return toStringNode.execute(sb);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Replace
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyUnicode_Replace() {
        }

        @Specialization(guards={"isString(s)", "isString(substr)", "isString(replstr)"})
        static Object replace(Object s, Object substr, Object replstr, long count, @Cached.Shared @Cached StringBuiltins.ReplaceNode replaceNode) {
            return replaceNode.execute(null, s, substr, replstr, count);
        }

        @Specialization(guards={"!isString(s)", "!isString(substr)", "!isString(replstr)", "isStringSubtype(inliningTarget, s, getClassNode, isSubtypeNode)", "isStringSubtype(inliningTarget, substr, getClassNode, isSubtypeNode)", "isStringSubtype(inliningTarget, replstr, getClassNode, isSubtypeNode)"})
        static Object replace(Object s, Object substr, Object replstr, long count, @Bind Node inliningTarget, @Cached.Shared @Cached StringBuiltins.ReplaceNode replaceNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return PyUnicode_Replace.replace(s, substr, replstr, count, replaceNode);
        }

        @Specialization(guards={"!isString(s)", "!isString(substr)", "!isString(replstr)", "!isStringSubtype(inliningTarget, s, getClassNode, isSubtypeNode)", "!isStringSubtype(inliningTarget, substr, getClassNode, isSubtypeNode)", "!isStringSubtype(inliningTarget, replstr, getClassNode, isSubtypeNode)"})
        static Object replace(Object s, Object substr, Object replstr, long count, @Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return PyUnicode_Replace.getNativeNull(inliningTarget);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_AsEncodedString
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_AsEncodedString() {
        }

        @Specialization(guards={"isString(obj) || isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object encode(Object obj, Object encoding, Object errors, @Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached StringBuiltins.EncodeNode encodeNode) {
            return encodeNode.execute(null, obj, PythonCextUnicodeBuiltins.convertEncoding(encoding), PythonCextUnicodeBuiltins.convertErrors(errors));
        }

        @Specialization(guards={"!isString(obj)", "!isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object encode(Object obj, Object encoding, Object errors, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Tailmatch
    extends PythonCextBuiltins.CApi5BuiltinNode {
        PyUnicode_Tailmatch() {
        }

        @Specialization(guards={"isAnyString(inliningTarget, string, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, substring, getClassNode, isSubtypeNode)", "direction > 0"})
        static int tailmatch(Object string, Object substring, long start, long end, int direction, @Bind Node inliningTarget, @Cached.Shared @Cached PyObjectLookupAttr lookupAttrNode, @Cached.Shared @Cached PySliceNew sliceNode, @Cached.Shared @Cached CallNode callNode, @Cached StringBuiltins.EndsWithNode endsWith, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            Object getItemCallable = lookupAttrNode.execute(null, inliningTarget, string, SpecialMethodNames.T___GETITEM__);
            Object slice = callNode.executeWithoutFrame(getItemCallable, sliceNode.execute(inliningTarget, start, end, PNone.NONE));
            return (Boolean)endsWith.execute(null, slice, substring, start, end) != false ? 1 : 0;
        }

        @Specialization(guards={"isAnyString(inliningTarget, string, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, substring, getClassNode, isSubtypeNode)", "direction <= 0"})
        static int tailmatch(Object string, Object substring, long start, long end, int direction, @Bind Node inliningTarget, @Cached.Shared @Cached PyObjectLookupAttr lookupAttrNode, @Cached.Shared @Cached PySliceNew sliceNode, @Cached.Shared @Cached CallNode callNode, @Cached StringBuiltins.StartsWithNode startsWith, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            Object getItemCallable = lookupAttrNode.execute(null, inliningTarget, string, SpecialMethodNames.T___GETITEM__);
            Object slice = callNode.executeWithoutFrame(getItemCallable, sliceNode.execute(inliningTarget, start, end, PNone.NONE));
            return (Boolean)startsWith.execute(null, slice, substring, start, end) != false ? 1 : 0;
        }

        @Specialization(guards={"!isAnyString(inliningTarget, string, getClassNode, isSubtypeNode) || !isAnyString(inliningTarget, substring, getClassNode, isSubtypeNode)"})
        static Object find(Object string, Object substring, Object start, Object end, Object direction, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, string);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Compare
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Compare() {
        }

        @Specialization(guards={"isAnyString(inliningTarget, left, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object compare(Object left, Object right, @Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached StringBuiltins.StringRichCmpNode eqNode, @Cached StringBuiltins.StringRichCmpNode ltNode, @Cached InlinedConditionProfile eqProfile) {
            if (eqProfile.profile(inliningTarget, ((Boolean)eqNode.execute(null, left, right, RichCmpOp.Py_EQ)).booleanValue())) {
                return 0;
            }
            return (Boolean)ltNode.execute(null, left, right, RichCmpOp.Py_LT) != false ? -1 : 1;
        }

        @Specialization(guards={"!isAnyString(inliningTarget, left, getClassNode, isSubtypeNode) || !isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object compare(Object left, Object right, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANT_COMPARE, left, right);
        }
    }

    static abstract class PyUnicode_CompareWithASCIIString
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_CompareWithASCIIString() {
        }

        @Specialization
        static int compare(TruffleString left, TruffleString right, @Cached TruffleString.CompareIntsUTF32Node compare) {
            return compare.execute((AbstractTruffleString)left, (AbstractTruffleString)right);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class _PyUnicode_EqualToASCIIString
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyUnicode_EqualToASCIIString() {
        }

        @Specialization(guards={"isAnyString(inliningTarget, left, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object compare(Object left, Object right, @Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached StringBuiltins.StringRichCmpNode eqNode, @Cached PyObjectIsTrueNode isTrue) {
            return PInt.intValue(isTrue.execute(null, eqNode.execute(null, left, right, RichCmpOp.Py_EQ)));
        }

        @Specialization(guards={"!isAnyString(inliningTarget, left, getClassNode, isSubtypeNode) || !isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object compare(Object left, Object right, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANT_COMPARE, left, right);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Join
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Join() {
        }

        @Specialization(guards={"isString(separator) || isStringSubtype(inliningTarget, separator, getClassNode, isSubtypeNode)"})
        static Object find(Object separator, Object seq, @Bind Node inliningTarget, @Cached StringBuiltins.JoinNode joinNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return joinNode.execute(null, separator, seq);
        }

        @Specialization(guards={"!isTruffleString(separator)", "isStringSubtype(inliningTarget, separator, getClassNode, isSubtypeNode)"})
        static Object find(Object separator, Object seq, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, separator);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Substring
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_Substring() {
        }

        @Specialization(guards={"isString(s) || isStringSubtype(s, inliningTarget, getClassNode, isSubtypeNode)"}, limit="1")
        static Object doString(Object s, long start, long end, @Bind Node inliningTarget, @Cached InlinedConditionProfile profile, @Cached PyObjectLookupAttr lookupAttrNode, @Cached PySliceNew sliceNode, @Cached CallNode callNode, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            if (profile.profile(inliningTarget, start < 0L || end < 0L)) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.STRING_INDEX_OUT_OF_RANGE);
            }
            Object getItemCallable = lookupAttrNode.execute(null, inliningTarget, s, SpecialMethodNames.T___GETITEM__);
            return callNode.executeWithoutFrame(getItemCallable, sliceNode.execute(inliningTarget, start, end, PNone.NONE));
        }

        @Specialization(guards={"!isTruffleString(s)", "isStringSubtype(s, inliningTarget, getClassNode, isSubtypeNode)"}, limit="1")
        static Object doError(Object s, Object start, Object end, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, s);
        }

        protected static boolean isStringSubtype(Object obj, Node n, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
            return isSubtypeNode.execute(getClassNode.execute(n, obj), (Object)PythonBuiltinClassType.PString);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_FindChar
    extends PythonCextBuiltins.CApi5BuiltinNode {
        PyUnicode_FindChar() {
        }

        @Specialization(guards={"isString(string) || isStringSubtype(inliningTarget, string, getClassNode, isSubtypeNode)", "direction > 0"})
        static Object find(Object string, Object c, long start, long end, int direction, @Bind Node inliningTarget, @Cached.Shared @Cached BuiltinFunctions.ChrNode chrNode, @Cached StringBuiltins.FindNode findNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return findNode.execute(null, string, chrNode.execute(null, c), start, end);
        }

        @Specialization(guards={"isString(string) || isStringSubtype(inliningTarget, string, getClassNode, isSubtypeNode)", "direction <= 0"})
        static Object find(Object string, Object c, long start, long end, int direction, @Bind Node inliningTarget, @Cached.Shared @Cached BuiltinFunctions.ChrNode chrNode, @Cached StringBuiltins.RFindNode rFindNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return rFindNode.execute(null, string, chrNode.execute(null, c), start, end);
        }

        @Specialization(guards={"!isTruffleString(string)", "!isStringSubtype(inliningTarget, string, getClassNode, isSubtypeNode)"})
        static Object find(Object string, Object c, Object start, Object end, Object direction, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, string);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class _PyUnicode_FormatLong
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        _PyUnicode_FormatLong() {
        }

        protected static boolean isOF(int prec) {
            return prec > 0x7FFFFFFC;
        }

        @CompilerDirectives.TruffleBoundary
        private static char[] getCharArray(String s) {
            return s.toCharArray();
        }

        @Specialization(guards={"isOF(prec)"})
        static Object overflow(Object val, int alt, int prec, int type, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.PRECISION_TOO_LARGE);
        }

        @Specialization(guards={"!isOF(prec)"})
        static Object formatLong(Object val, int alt, int prec, int type, @Bind Node inliningTarget, @Bind PythonContext context, @Cached BuiltinFunctions.OctNode toOctBase, @Cached BuiltinFunctions.HexNode toHexBase, @Cached PyNumberIndexNode indexNode, @Cached StringBuiltins.StrNewNode strNode, @Cached CastToJavaStringNode cast, @Cached TruffleString.FromCharArrayUTF16Node fromCharArrayNode) {
            int numnondigits = 0;
            TruffleString result = null;
            switch (type) {
                case 100: 
                case 105: 
                case 117: {
                    result = (TruffleString)PythonCextAbstractBuiltins.PyNumber_ToBase.toBase10(val, 10, inliningTarget, indexNode, strNode);
                    break;
                }
                case 111: {
                    numnondigits = 2;
                    result = (TruffleString)PythonCextAbstractBuiltins.PyNumber_ToBase.toBase8(val, 8, toOctBase);
                    break;
                }
                case 88: 
                case 120: {
                    numnondigits = 2;
                    result = (TruffleString)PythonCextAbstractBuiltins.PyNumber_ToBase.toBase16(val, 16, inliningTarget, indexNode, toHexBase);
                    break;
                }
                default: {
                    CExtCommonNodes.fatalErrorString(inliningTarget, context, null, null, -1);
                }
            }
            char[] buf = _PyUnicode_FormatLong.getCharArray(cast.execute(result));
            int bufi = 0;
            int len = buf.length;
            int sign = buf[0] == '-' ? 1 : 0;
            int numdigits = len - (numnondigits += sign);
            assert (numdigits > 0);
            if (alt == 0 && (type == 111 || type == 120 || type == 88)) {
                assert (buf[bufi + sign] == '0');
                assert (buf[bufi + sign + 1] == 'x' || buf[sign + 1] == 'X' || buf[bufi + sign + 1] == 'o');
                bufi += 2;
                assert ((len -= 2) == (numnondigits -= 2) + numdigits);
            }
            if (prec > numdigits) {
                int i;
                char[] b1 = new char[numnondigits + prec];
                int b1i = 0;
                for (i = 0; i < numnondigits; ++i) {
                    b1[b1i++] = buf[bufi++];
                }
                for (i = 0; i < prec - numdigits; ++i) {
                    b1[b1i++] = 48;
                }
                for (i = 0; i < numdigits; ++i) {
                    b1[b1i++] = buf[bufi++];
                    b1[b1i] = '\u0000';
                }
                buf = b1;
                len = numnondigits + prec;
            }
            if (type == 88) {
                for (int i = bufi; i < len; ++i) {
                    if (buf[i] < 'a' || buf[i] > 'x') continue;
                    int n = i;
                    buf[n] = (char)(buf[n] - 32);
                }
            }
            return fromCharArrayNode.execute(buf);
        }
    }

    static abstract class GraalPyPrivate_Unicode_LookupAndIntern
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Unicode_LookupAndIntern() {
        }

        @Specialization
        static Object withPString(PString str, @Bind Node inliningTarget, @Cached PyUnicodeCheckExactNode unicodeCheckExactNode, @Cached CastToTruffleStringNode cast, @Cached StringNodes.IsInternedStringNode isInternedStringNode, @Cached StringNodes.InternStringNode internNode, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached HashingStorageNodes.HashingStorageSetItem setItem) {
            Object interned;
            if (!unicodeCheckExactNode.execute(inliningTarget, str)) {
                return GraalPyPrivate_Unicode_LookupAndIntern.getNativeNull(inliningTarget);
            }
            boolean isInterned = isInternedStringNode.execute(inliningTarget, str);
            if (isInterned) {
                return str;
            }
            TruffleString ts = cast.execute(inliningTarget, str);
            CApiContext cApiContext = GraalPyPrivate_Unicode_LookupAndIntern.getCApiContext(inliningTarget);
            PDict dict = cApiContext.getInternedUnicode();
            if (dict == null) {
                dict = PFactory.createDict(cApiContext.getContext().getLanguage(internNode));
                cApiContext.setInternedUnicode(dict);
            }
            if ((interned = getItem.execute(inliningTarget, dict.getDictStorage(), ts)) == null) {
                interned = internNode.execute(inliningTarget, str);
                dict.setDictStorage(setItem.execute(inliningTarget, dict.getDictStorage(), ts, interned));
            }
            return interned;
        }

        @Fallback
        Object nil(Object obj) {
            return this.getNativeNull();
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_FromEncodedObject
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_FromEncodedObject() {
        }

        @Specialization
        static Object doGeneric(Object obj, Object encodingObj, Object errorsObj, @Bind Node inliningTarget, @Cached InlinedExactClassProfile encodingProfile, @Cached InlinedExactClassProfile errorsProfile, @Cached InlinedConditionProfile nullProfile, @Cached PyUnicodeFromEncodedObject decodeNode) {
            TruffleString errors;
            TruffleString encoding;
            Object encodingObjProfiled = encodingProfile.profile(inliningTarget, encodingObj);
            if (encodingObjProfiled == PNone.NO_VALUE) {
                encoding = StringLiterals.T_UTF8;
            } else {
                assert (encodingObjProfiled instanceof TruffleString);
                encoding = (TruffleString)encodingObjProfiled;
            }
            Object errorsObjProfiled = errorsProfile.profile(inliningTarget, errorsObj);
            if (errorsObjProfiled == PNone.NO_VALUE) {
                errors = StringLiterals.T_STRICT;
            } else {
                assert (errorsObjProfiled instanceof TruffleString);
                errors = (TruffleString)errorsObjProfiled;
            }
            if (nullProfile.profile(inliningTarget, obj == PNone.NO_VALUE)) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
            }
            return decodeNode.execute(null, inliningTarget, obj, encoding, errors);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Concat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Concat() {
        }

        @Specialization(guards={"isString(left) || isStringSubtype(inliningTarget, left, getClassNode, isSubtypeNode)", "isString(right) || isStringSubtype(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object concat(Object left, Object right, @Bind Node inliningTarget, @Cached StringBuiltins.ConcatNode addNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return addNode.execute(null, left, right);
        }

        @Specialization(guards={"!isString(left)", "!isStringSubtype(inliningTarget, left, getClassNode, isSubtypeNode)"})
        static Object leftNotString(Object left, Object right, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, left);
        }

        @Specialization(guards={"!isString(right)", "!isStringSubtype(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object rightNotString(Object left, Object right, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, right);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_FromObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_FromObject() {
        }

        @Specialization
        static TruffleString fromObject(TruffleString s) {
            return s;
        }

        @Specialization(guards={"isPStringType(inliningTarget, s, getClassNode)"})
        static PString fromObject(PString s, @Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode) {
            return s;
        }

        @Specialization(guards={"!isPStringType(inliningTarget, obj, getClassNode)", "isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object fromObject(Object obj, @Bind Node inliningTarget, @Cached StringBuiltins.StrNewNode strNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return strNode.executeWith(obj);
        }

        @Specialization(guards={"!isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object fromObject(Object obj, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANT_CONVERT_TO_STR_IMPLICITLY, obj);
        }

        protected boolean isPStringType(Node inliningTarget, Object obj, GetClassNode getClassNode) {
            return getClassNode.execute(inliningTarget, obj) == PythonBuiltinClassType.PString;
        }
    }

    static abstract class PyUnicode_FromOrdinal
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_FromOrdinal() {
        }

        @Specialization
        static Object chr(int value, @Cached BuiltinFunctions.ChrNode chrNode) {
            return chrNode.execute(null, value);
        }
    }
}

