/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.jorphan.gui;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

import org.apache.jorphan.reflect.Functor;

public class DefaultTreeTableModel extends AbstractTreeTableModel {

    public DefaultTreeTableModel() {
        this(new DefaultMutableTreeNode());
    }

    /**
     * @param root
     */
    public DefaultTreeTableModel(TreeNode root) {
        super(root);
    }

    /**
     * @param root
     * @param editable
     */
    public DefaultTreeTableModel(TreeNode root, boolean editable) {
        super(root, editable);
    }

    /**
     * @param headers
     * @param readFunctors
     * @param writeFunctors
     * @param editorClasses
     */
    public DefaultTreeTableModel(String[] headers, Functor[] readFunctors,
            Functor[] writeFunctors, Class[] editorClasses) {
        super(headers, readFunctors, writeFunctors, editorClasses);
    }

}
