/* $Id: signal.c,v 1.2 2010/05/14 14:35:26 tcunha Exp $ */

/*
 * Copyright (c) 2007 Nicholas Marriott <nicm@users.sourceforge.net>
 * Copyright (c) 2010 Romain Francoise <rfrancoise@debian.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <string.h>
#include <signal.h>

#include "tmux.h"

struct event	ev_sighup;
struct event	ev_sigchld;
struct event	ev_sigcont;
struct event	ev_sigterm;
struct event	ev_sigusr1;
struct event	ev_sigwinch;

void
set_signals(void(*handler)(int, short, unused void *))
{
	struct sigaction	sigact;

	memset(&sigact, 0, sizeof sigact);
	sigemptyset(&sigact.sa_mask);
	sigact.sa_flags = SA_RESTART;
	sigact.sa_handler = SIG_IGN;
	if (sigaction(SIGINT, &sigact, NULL) != 0)
		fatal("sigaction failed");
	if (sigaction(SIGPIPE, &sigact, NULL) != 0)
		fatal("sigaction failed");
	if (sigaction(SIGUSR2, &sigact, NULL) != 0)
		fatal("sigaction failed");
	if (sigaction(SIGTSTP, &sigact, NULL) != 0)
		fatal("sigaction failed");

	signal_set(&ev_sighup, SIGHUP, handler, NULL);
	signal_add(&ev_sighup, NULL);
	signal_set(&ev_sigchld, SIGCHLD, handler, NULL);
	signal_add(&ev_sigchld, NULL);
	signal_set(&ev_sigcont, SIGCONT, handler, NULL);
	signal_add(&ev_sigcont, NULL);
	signal_set(&ev_sigterm, SIGTERM, handler, NULL);
	signal_add(&ev_sigterm, NULL);
	signal_set(&ev_sigusr1, SIGUSR1, handler, NULL);
	signal_add(&ev_sigusr1, NULL);
	signal_set(&ev_sigwinch, SIGWINCH, handler, NULL);
	signal_add(&ev_sigwinch, NULL);
}

void
clear_signals(void)
{
	struct sigaction	sigact;

	memset(&sigact, 0, sizeof sigact);
	sigemptyset(&sigact.sa_mask);
	sigact.sa_flags = SA_RESTART;
	sigact.sa_handler = SIG_DFL;
	if (sigaction(SIGINT, &sigact, NULL) != 0)
		fatal("sigaction failed");
	if (sigaction(SIGPIPE, &sigact, NULL) != 0)
		fatal("sigaction failed");
	if (sigaction(SIGUSR2, &sigact, NULL) != 0)
		fatal("sigaction failed");
	if (sigaction(SIGTSTP, &sigact, NULL) != 0)
		fatal("sigaction failed");

	event_del(&ev_sighup);
	event_del(&ev_sigchld);
	event_del(&ev_sigcont);
	event_del(&ev_sigterm);
	event_del(&ev_sigusr1);
	event_del(&ev_sigwinch);
}
