
getSelectedIndices.ggobi <-
#
# only indicates whether the return value
# should contain only the indices 
# of the points that are within in the brush region
# or whether it should be a logical vector
# indicating whether 
#
# The reason for this is efficiency.
#
#
function(.data = 1, .gobi = getDefaultGGobi())
{
  if(mode(.data) == "numeric")
    .data <- as.integer(.data - 1)

 .GGobiCall("getSelectedIndices", .data, .gobi=.gobi)
}

isObservationSelected.ggobi <-
function(.data = 1, .gobi = getDefaultGGobi())
{
  if(!inherits(.data, "ggobiDataset"))
    .data <- getDatasetReference.ggobi(.data, .gobi)

  sel <- getSelectedIndices.ggobi(.data, .gobi)
  n <- nrow(.data)

  if(is.null(sel))
    ans <- logical(n)
  else {
    ans <- !is.na(match(seq(1, length = n), sel))
  }

 return(ans)
}

getBrushSize.ggobi <-
function(.data = 1, .gobi = getDefaultGGobi(), units=0)
{
   # This is not a mistake. Passing negative dimensions
   # means that we just get the current value back and skip
   # the setting.
 setBrushSize.ggobi(as.integer(-1), as.integer(-1), .gobi=.gobi)
}

getBrushLocation.ggobi <-
function(.data=1, .gobi = getDefaultGGobi(), units=0)
{
 setBrushLocation.ggobi(as.integer(-1), as.integer(-1), .data, .gobi=.gobi)
}

setBrushSize.ggobi <-
function(w, h, .data = 1, .gobi = getDefaultGGobi(), update = TRUE, units = 0)
{
 if(length(w) > 1 && missing(h)) { 
   w <- as.integer(w)
   h <- as.integer(w[2]) 
 }

 if(mode(.data) == "numeric")
   .data <- as.integer(.data - 1)

 tmp <- .GGobiCall("setBrushSize", as.integer(c(w[1],h[1])), .data, .gobi = .gobi) 
 if(!is.null(tmp))
   names(tmp) <- c("width", "height")

 return(tmp)
}

setBrushLocation.ggobi <-
function(x, y, .data = 1, .gobi = getDefaultGGobi(), update = TRUE, units = 0)
{
 if(length(x) > 1 && missing(y)) { 
   x <- as.integer(x)
   y <- as.integer(x[2]) 
 }

 if(mode(.data) == "numeric")
   .data <- as.integer(.data - 1)

 tmp <- .GGobiCall("setBrushLocation", as.integer(c(x[1],y[1])), .data, .gobi = .gobi)
 if(!is.null(tmp))
   names(tmp) <- c("x", "y")

 return(tmp)
}


setBrushColor.ggobi <-
function(id, .gobi = getDefaultGGobi())
{
 if(is.character(id)) {
   which <- match(id,  rownames(getColorMap.ggobi(.gobi)))
   if(any(is.na(which))) { 
     stop(paste("Unrecognized color(s)", id[is.na(which)]))
   }
   id <- which
 }
  .GGobiCall("setBrushColor", as.integer(id-1), .gobi=.gobi)
}

getBrushColor.ggobi <-
function(.gobi = getDefaultGGobi())
{
  .GGobiCall("getBrushColor", .gobi=.gobi)
}

setBrushGlyph.ggobi <-
function(type = -1, size = -1, .gobi = getDefaultGGobi())
{

 if(missing(type) & missing(size))
  stop("Must specify a glyph size or type")

 if(is.character(type)) {
   type <- mapGlyphType(type)
 }

 .GGobiCall("setBrushGlyph", as.integer(c(type, size)), .gobi=.gobi)
 return(TRUE)
}

getBrushGlyph.ggobi <-
function(.gobi = getDefaultGGobi())
{
 x <- .GGobiCall("getBrushGlyph", .gobi = .gobi)
 if(is.null(x))
   return(x)

 n <- getGlyphTypes.ggobi()

 names(x) <- c( names(n)[x[1] == n], "size")
 x
}


mapGlyphType <-
function(types)
{

 if(is.character(types)) {
  sys.types <- getGlyphTypes.ggobi()
  ids <- match(types, names(sys.types))
  if(any(is.na(ids))) {
print(ids)
    stop(paste("Invalid glyph name(s):",paste(types[is.na(ids)], collapse=", ")))
  }
  types <- ids
 } else
  types <- as.integer(types)

 return(types)
}
