\name{getDisplayWindow.ggobi}
\alias{getDisplayWindow.ggobi}
\title{Get GtkWindow object of a GGobi display}
\description{
  This allows the caller to retrieve the GtkWindow
  associated with a given GGobi display.
  This window can then be used in via the \code{RGtk}
  package to manipulate the other widgets, establish
  callbacks, etc.
}
\usage{
getDisplayWindow.ggobi(display = 1, .gobi = getDefaultGGobi(), expandClasses = TRUE)
}
\arguments{
  \item{display}{an identifier for the particular display within the
    GGobi instance.}
  \item{.gobi}{the GGobi instance of interest}
  \item{expandClasses}{a logical value indicating whether to compute the
   actual class of the GtkObject returned and use that as the class name(s).}
}
\details{

}
\value{
 An object of class \code{GtkObject}.
}
\references{
  \url{http://www.omegahat.org/RGtk}
 \url{http://www.ggobi.org/}  
}
\author{Duncan Temple Lang <duncan@research.bell-labs.com>}


\seealso{
 \code{\link{ggobi}}
}
\examples{

 data(mtcars)
 ggobi(mtcars)

 getDisplayWindow.ggobi()

 d = scatterplot.ggobi("cyl", "mpg")
 getDisplayWindow.ggobi(d)

}
\keyword{dynamic}

