\name{getRecordsInPlot.ggobi}
\alias{getRecordsInPlot.ggobi}
\title{Query active records in GGobi dataset}
\description{
  This retrieves the indices of the records
  which are considered active within a GGobi dataset
  and which are therefore plotted in the different
  displays associated with the dataset.
}
\usage{
getRecordsInPlot.ggobi(.data = 1, .gobi = getDefaultGGobi())
}
\arguments{
  \item{.data}{the identifier for the GGobi dataset, either an index,
    name or reference.}
  \item{.gobi}{the GGobi instance in which to resolve the dataset.}
}
\details{
  GGobi maintains a vector indicating which
  records are to be displayed. This allows it to efficiently
  subset the dataset without copying it.
  This vector is what we are accessing here.
}
\value{
  An integer vector giving the indices of the records
  that are currently active.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}


\seealso{
\code{\link{ggobi}}
}
\examples{
 data(mtcars)
 ggobi(mtcars)
 getRecordsInPlot.ggobi()
}
\keyword{dynamic}

