\name{getVariable.ggobi}
\alias{getVariable.ggobi}
\title{Get the values of a GGobi variable}
\description{
  This retrieves the values of a variable within a GGobi dataset,
  handling categorical variables as S factors.
}
\usage{
getVariable.ggobi(which, .data=1, .gobi=getDefaultGGobi(), asDataFrame=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{which}{the identifiers for the variables to be retrieved,
   given by index or variable name}
 \item{.data}{an identifier for the dataset, either an index,
   name or \code{ggobiDataset} object.}
 \item{.gobi}{the GGobi instance, given by index or an object
   of class \code{ggobi}. The currently active GGobi instance
  is used by default.}
  \item{asDataFrame}{a logical value indicating whether
    the result should be given as a data frame or
    left as a list.}
}
\value{
  A dataframe or a list (depending on whether
  \code{asDataFrame} is \code{TRUE} or \code{FALSE})
  whose elements are the variables copied from the
  GGobi dataset.
}
\references{
\url{http://www.ggobi.org/RSggobi}
\url{http://www.ggobi.org}
}
\author{Duncan Temple Lang}

\seealso{
  \code{\link{setVariableValues.ggobi}}
  \code{\link{[.ggobiDataset}}
  \code{\link{[.ggobiDataset}}
}

\examples{
 ggobi(system.file("data", "flea.xml", package="Rggobi"))
 getVariable.ggobi("tars1")
 getVariable.ggobi(1)
}
\keyword{dynamic}
