\name{setActiveColorScheme}
\alias{setActiveColorScheme}
\alias{getActiveColorScheme}
\title{Specify the active color scheme in a GGobi instance or the
  session options.}
\description{
  This makes a particular color scheme active
  within a GGobi instance or sets the default active color scheme
  in the session options for use in new GGobi instances created after
  this call.

  \code{getActiveColorScheme} returns a complete description of the
  currently active color scheme in a GGobi instance or the session options.
}
\usage{
setActiveColorScheme(id, .gobi=NULL)
getActiveColorScheme(.gobi = NULL)
}
\arguments{
  \item{id}{an identifier for the desired color scheme
    that is to be made active. This is usually the name of the
    scheme. Alternatively it can be an integer value that
    specifies the scheme by index in the list of color schemes.}
  \item{.gobi}{ the GGobi instance to which this scheme is to be active,
    or if \code{NULL}, sets it in the GGobi session options.
    In this case, the subsequently created GGobi instances will use this
    value as their initial color scheme.}
}
\value{
  The name of the previously active color scheme.
  This can be used to restore the previous setting.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
  \code{\link{addColorScheme}}
  \code{\link{getColorSchemes}}  
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"))
  schemes <- getColorSchemes(.gobi = g)
  setActiveColorScheme(names(schemes)[1], g)
}
\keyword{iplot}
\keyword{dynamic}
