/*
 * $Id: config.c 511 2005-03-22 23:06:26Z acid $
 * gcc.wrapper - Wrapper for gcc used for apt-build
 * (c) 2005 - Julien Danjou <acid@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 */

#include "apt-build.h"


#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


char * parse_options(char *file_content)
{
  unsigned int i, j;
  char *result;

  /* Search the first " */
  for(i = 0; i <= strlen(file_content) && file_content[i] != '"'; i++);
  file_content += i + 1;

  /* Search the last " */
  for(j = strlen(file_content); j >= 1 && file_content[j - 1] != '"'; j--);
  
  if(j == 0)
  {
	fprintf(stderr, "Error parsing options, check configuration file. Exiting.\n");
	exit(EXIT_FAILURE);
  }
  
  /* Remove the first spaces if they exists */
  while(file_content[0] == ' ')
	file_content++;
  
  if(strlen(file_content) > 2)
  {
	result = strndup(file_content, j - 2);
	return result;
  }

  return NULL;
}

char **
parse_conf(unsigned int argc, char **argv)
{
  FILE *conf;
  unsigned int i = 0, nb_apt_build_options = 0;
  char *file_content;
  char buf[BUF_SIZE];
  char opt[BUF_SIZE];
  char *str;
  char **cmd_line_args;
  struct apt_build_args args;

  args.options = NULL;
  args.make_options = NULL;

  conf = fopen(APT_BUILD_CONF_PATH, "r");
  
  if(!conf)
  {
	perror("Unable to open apt-build configuration file");
	exit(EXIT_FAILURE);
  }

  file_content = (char *) malloc(sizeof(char) * BUF_SIZE);
  
  while(fgets(file_content, BUF_SIZE, conf))
  {
	if(sscanf(file_content, "%s = %s", opt, buf))
	{
	  if(!strncmp(opt, "Olevel", 6))
		args.Olevel = strdup(buf);
	  
	  if(!strncmp(opt, "march", 5))
		args.march = strdup(buf);
	  
	  if(!strncmp(opt, "mcpu", 4))
		args.mcpu = strdup(buf);
	
	  if(!strncmp(opt, "options", 7))
		args.options = parse_options(file_content);

	  if(!strncmp(opt, "make_options", 13))
		args.make_options = parse_options(file_content);
	}
  }
  fclose(conf);
  free(file_content);

  /* make options */
  if(!strcmp(basename(argv[0]), "make"))
  {
	cmd_line_args = (char **) malloc(sizeof(char *) * (argc + MAKE_ARGC + 1));
	
	if(args.make_options &&
	   strlen(args.make_options) &&
	   (str = strtok(args.make_options, " ")))
	{
	  i = 0;
	  do
	  {
		i++;
		cmd_line_args = (char **)
		  realloc(cmd_line_args, sizeof(char *) * (argc + MAKE_ARGC + 1 + i));
		cmd_line_args[MAKE_ARGC + i] = strdup(str);
	  }
	  while((str = strtok(NULL, " ")));
	  nb_apt_build_options = i;
	}
	
	/* Build the command line */
	cmd_line_args[0] = argv[0];

	/* Copy the rest of the line */
	for(i = 1; i < argc; i++)
	  cmd_line_args[MAKE_ARGC + nb_apt_build_options + i] = argv[i];
	
	cmd_line_args[argc + nb_apt_build_options + MAKE_ARGC] = NULL;
	
	/*  	for(i = 0; i < argc + nb_apt_build_options + MAKE_ARGC; i++) */
	/*  	  printf("argv[%d] -> %s\n", i, cmd_line_args[i]); */
	
  }
  else 
  {
	
	cmd_line_args = (char **) malloc(sizeof(char *) * (argc + GCC_ARGC + 1));
	
	if(args.options &&
	   strlen(args.options) &&
	   (str = strtok(args.options, " ")))
	{
	  i = 0;
	  do
	  {
		i++;
		cmd_line_args = (char **)
		  realloc(cmd_line_args, sizeof(char *) * (argc + GCC_ARGC + 1 + i));
		cmd_line_args[GCC_ARGC + i] = strdup(str);
	  }
	  while((str = strtok(NULL, " ")));
	  nb_apt_build_options = i;
	}

  /* Build the command line */
  cmd_line_args[0] = strdup(argv[0]);
  cmd_line_args[1] = args.Olevel;
  //  cmd_line_args[2] = args.march;
  cmd_line_args[2] = args.mcpu;

  /* Copy the rest of the line */
  for(i = 1; i < argc; i++)
	cmd_line_args[GCC_ARGC + nb_apt_build_options + i] = argv[i];
  
  cmd_line_args[argc + nb_apt_build_options + GCC_ARGC] = NULL;

/*   for(i = 0; i < argc + nb_apt_build_options + 4; i++) */
/* 	printf("argv[%d] -> %s\n", i, cmd_line_args[i]); */
  }
	 
  return cmd_line_args;
}
