/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * libdmachinemon debugging include file.
 *
 *
 * I can debug the output using the following kind of script:
 *
 * awk '/malloc,strdup/{a[$4]=$2 " " $3; } /free/{a[$4]="" } END{for (u in a) { if (a[u] != "" ) {print a[u]}}} ' < log
 *
 */

#ifndef __DMACHINEMON_DEBUG_H
#define __DMACHINEMON_DEBUG_H

/* define this variable... if it is really required. */
#ifdef __DMACHINEMON_DEBUG_VERSION_IS_HERE__

static void * __jmalloc (int len, const char * f, const int l)
{
  void * s = malloc(len);

  printf ("malloc %s %i: %p, size %i\n", f, l, s, len);
  return s;  
}

static void __jfree(void * n, const char * f, const int l)
{
  printf ("free %s %i: %p\n", f, l, n);
  free(n);
}

#include <string.h>

static void * __jstrdup (const char*buf, const char * f, const int l)
{
  char * s = strdup(buf);

  printf ("strdup %s %i: %p\n", f, l, s );
  return s;  
}
			 

#define malloc(A) __jmalloc(A,__FILE__,__LINE__)
#define free(A) __jfree(A,__FILE__,__LINE__)
#define strdup(A) __jstrdup(A,__FILE__,__LINE__)

#endif
#endif
